"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _Search = _interopRequireDefault(require("../Search"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2021
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;

function ExpandableSearch(props) {
  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      expanded = _useState2[0],
      setExpanded = _useState2[1];

  var searchRef = (0, _react.useRef)(null);

  function handleFocus() {
    if (!expanded) {
      setExpanded(true);
    }
  }

  function handleBlur(evt) {
    var relatedTargetIsAllowed = evt.relatedTarget && evt.relatedTarget.classList.contains("".concat(prefix, "--search-close"));

    if (expanded && !relatedTargetIsAllowed && !searchRef.current.state.hasContent) {
      setExpanded(false);
    }
  }

  (0, _react.useEffect)(function () {
    var _searchRef$current2;

    function focusInput() {
      var _searchRef$current;

      if (!expanded && (_searchRef$current = searchRef.current) !== null && _searchRef$current !== void 0 && _searchRef$current.input) {
        searchRef.current.input.focus();
      }
    }

    if ((_searchRef$current2 = searchRef.current) !== null && _searchRef$current2 !== void 0 && _searchRef$current2.magnifier) {
      var magnifier = searchRef.current.magnifier;
      magnifier.addEventListener('click', focusInput);
      return function () {
        magnifier.removeEventListener('click', focusInput);
      };
    }
  }, [expanded, searchRef]);
  var classes = (0, _classnames2.default)("".concat(prefix, "--search--expandable"), (0, _defineProperty2.default)({}, "".concat(prefix, "--search--expanded"), expanded), props.className);
  return /*#__PURE__*/_react.default.createElement(_Search.default, (0, _extends2.default)({}, props, {
    ref: searchRef,
    className: classes,
    onFocus: handleFocus,
    onBlur: handleBlur
  }));
}

ExpandableSearch.propTypes = _Search.default.propTypes;
var _default = ExpandableSearch;
exports.default = _default;