"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayoutDirection = LayoutDirection;
Object.defineProperty(exports, "LayoutDirectionContext", {
  enumerable: true,
  get: function get() {
    return _LayoutDirectionContext.LayoutDirectionContext;
  }
});

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _LayoutDirectionContext = require("./LayoutDirectionContext");

var _excluded = ["as", "children", "dir"];

function LayoutDirection(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      children = _ref.children,
      dir = _ref.dir,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var value = _react.default.useMemo(function () {
    return {
      direction: dir
    };
  }, [dir]);

  return /*#__PURE__*/_react.default.createElement(_LayoutDirectionContext.LayoutDirectionContext.Provider, {
    value: value
  }, /*#__PURE__*/_react.default.createElement(BaseComponent, (0, _extends2.default)({
    dir: dir
  }, rest), children));
}

LayoutDirection.propTypes = {
  /**
   * Customize the element type used to render the outermost node
   */
  as: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Provide child elements or components to be rendered inside of this
   * component
   */
  children: _propTypes.default.node,

  /**
   * Specify the layout direction of this part of the page
   */
  dir: _propTypes.default.oneOf(['ltr', 'rtl']).isRequired
};