"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.translationIds = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _keyboard = require("../../internal/keyboard");

var _defaultTranslations;

var prefix = _carbonComponents.settings.prefix;
/**
 * `ListBoxSelection` is used to provide controls for clearing a selection, in
 * addition to conditionally rendering a badge if the control has more than one
 * selection.
 */

var ListBoxSelection = function ListBoxSelection(_ref) {
  var _cx;

  var clearSelection = _ref.clearSelection,
      selectionCount = _ref.selectionCount,
      t = _ref.translateWithId,
      disabled = _ref.disabled,
      onClearSelection = _ref.onClearSelection;
  var className = (0, _classnames.default)("".concat(prefix, "--list-box__selection"), (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--tag--filter"), selectionCount), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--list-box__selection--multi"), selectionCount), _cx));

  var handleOnClick = function handleOnClick(event) {
    event.stopPropagation();

    if (disabled) {
      return;
    }

    clearSelection(event);

    if (onClearSelection) {
      onClearSelection(event);
    }
  };

  var handleOnKeyDown = function handleOnKeyDown(event) {
    event.stopPropagation();

    if (disabled) {
      return;
    } // When a user hits ENTER, we'll clear the selection


    if ((0, _keyboard.match)(event, _keyboard.keys.Enter)) {
      clearSelection(event);

      if (onClearSelection) {
        onClearSelection(event);
      }
    }
  };

  var description = selectionCount ? t('clear.all') : t('clear.selection');
  var tagClasses = (0, _classnames.default)("".concat(prefix, "--tag"), "".concat(prefix, "--tag--filter"), "".concat(prefix, "--tag--high-contrast"), (0, _defineProperty2.default)({}, "".concat(prefix, "--tag--disabled"), disabled));
  return selectionCount ? /*#__PURE__*/_react.default.createElement("div", {
    className: tagClasses
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--tag__label"),
    title: selectionCount
  }, selectionCount), /*#__PURE__*/_react.default.createElement("div", {
    role: "button",
    tabIndex: disabled ? -1 : 0,
    className: "".concat(prefix, "--tag__close-icon"),
    onClick: handleOnClick,
    onKeyDown: handleOnKeyDown,
    disabled: disabled,
    "aria-label": t('clear.all'),
    title: description
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Close16, null))) : /*#__PURE__*/_react.default.createElement("div", {
    role: "button",
    className: className,
    tabIndex: disabled ? -1 : 0,
    onClick: handleOnClick,
    onKeyDown: handleOnKeyDown,
    "aria-label": description,
    title: description
  }, selectionCount, /*#__PURE__*/_react.default.createElement(_iconsReact.Close16, null));
};

var translationIds = {
  'clear.all': 'clear.all',
  'clear.selection': 'clear.selection'
};
exports.translationIds = translationIds;
var defaultTranslations = (_defaultTranslations = {}, (0, _defineProperty2.default)(_defaultTranslations, translationIds['clear.all'], 'Clear all selected items'), (0, _defineProperty2.default)(_defaultTranslations, translationIds['clear.selection'], 'Clear selected item'), _defaultTranslations);
ListBoxSelection.propTypes = {
  /**
   * Specify a function to be invoked when a user interacts with the clear
   * selection element.
   */
  clearSelection: _propTypes.default.func.isRequired,

  /**
   * Specify whether or not the clear selection element should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify an optional `onClearSelection` handler that is called when the underlying
   * element is cleared
   */
  onClearSelection: _propTypes.default.func,

  /**
   * Specify an optional `onClick` handler that is called when the underlying
   * clear selection element is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Specify an optional `onKeyDown` handler that is called when the underlying
   * clear selection element fires a keydown event
   */
  onKeyDown: _propTypes.default.func,

  /**
   * Specify an optional `selectionCount` value that will be used to determine
   * whether the selection should display a badge or a single clear icon.
   */
  selectionCount: _propTypes.default.number,

  /**
   * i18n hook used to provide the appropriate description for the given menu
   * icon. This function takes in an id defined in `translationIds` and should
   * return a string message for that given message id.
   */
  translateWithId: _propTypes.default.func.isRequired
};
ListBoxSelection.defaultProps = {
  translateWithId: function translateWithId(id) {
    return defaultTranslations[id];
  }
};
var _default = ListBoxSelection;
exports.default = _default;