"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._FilterableWithLayer = exports.withLayer = exports._Filterable = exports.WithInitialSelectedItems = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _ = _interopRequireDefault(require("../"));

var _FilterableMultiSelect = _interopRequireDefault(require("./FilterableMultiSelect"));

var _Layer = require("../../Layer");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var items = [{
  id: 'downshift-1-item-0',
  text: 'Option 1'
}, {
  id: 'downshift-1-item-1',
  text: 'Option 2'
}, {
  id: 'downshift-1-item-2',
  text: 'Option 3 - a disabled item',
  disabled: true
}, {
  id: 'downshift-1-item-3',
  text: 'Option 4'
}, {
  id: 'downshift-1-item-4',
  text: 'An example option that is really long to show what should be done to handle long text'
}, {
  id: 'downshift-1-item-5',
  text: 'Option 5'
}];
var _default = {
  title: 'Components/MultiSelect',
  parameters: {
    component: _.default,
    subcomponents: {
      'MultiSelect.Filterable': _.default.Filterable
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_.default, {
    label: "Multiselect Label",
    id: "carbon-multiselect-example",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    selectionFeedback: "top-after-reopen"
  }));
};

exports.Default = Default;

var WithInitialSelectedItems = function WithInitialSelectedItems() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "carbon-multiselect-example-2",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    initialSelectedItems: [items[0], items[1]],
    selectionFeedback: "top-after-reopen"
  }));
};

exports.WithInitialSelectedItems = WithInitialSelectedItems;

var _Filterable = function _Filterable() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_FilterableMultiSelect.default, {
    id: "carbon-multiselect-example-3",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter",
    selectionFeedback: "top-after-reopen"
  }));
};

exports._Filterable = _Filterable;

var withLayer = function withLayer() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_.default, {
    label: "First Layer",
    id: "carbon-multiselect-example",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    selectionFeedback: "top-after-reopen"
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    label: "Second Layer",
    id: "carbon-multiselect-example",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    selectionFeedback: "top-after-reopen"
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    label: "Third Layer",
    id: "carbon-multiselect-example",
    titleText: "Multiselect title",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    selectionFeedback: "top-after-reopen"
  }))));
};

exports.withLayer = withLayer;

var _FilterableWithLayer = function _FilterableWithLayer() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_FilterableMultiSelect.default, {
    id: "carbon-multiselect-example-3",
    titleText: "First Layer",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter",
    selectionFeedback: "top-after-reopen"
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_FilterableMultiSelect.default, {
    id: "carbon-multiselect-example-3",
    titleText: "Second Layer",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter",
    selectionFeedback: "top-after-reopen"
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_FilterableMultiSelect.default, {
    id: "carbon-multiselect-example-3",
    titleText: "Third Layer",
    helperText: "This is helper text",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter",
    selectionFeedback: "top-after-reopen"
  }))));
};

exports._FilterableWithLayer = _FilterableWithLayer;