"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverContent = exports.Popover = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["align", "as", "caret", "className", "children", "dropShadow", "highContrast", "light", "open"],
    _excluded2 = ["className", "children"];

var Popover = /*#__PURE__*/_react.default.forwardRef(function Popover(props, ref) {
  var _cx;

  var _props$align = props.align,
      align = _props$align === void 0 ? 'bottom' : _props$align,
      _props$as = props.as,
      BaseComponent = _props$as === void 0 ? 'span' : _props$as,
      _props$caret = props.caret,
      caret = _props$caret === void 0 ? true : _props$caret,
      customClassName = props.className,
      children = props.children,
      _props$dropShadow = props.dropShadow,
      dropShadow = _props$dropShadow === void 0 ? true : _props$dropShadow,
      _props$highContrast = props.highContrast,
      highContrast = _props$highContrast === void 0 ? false : _props$highContrast,
      _props$light = props.light,
      light = _props$light === void 0 ? false : _props$light,
      open = props.open,
      rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--popover-container"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--popover--caret"), caret), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--popover--drop-shadow"), dropShadow), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--popover--high-contrast"), highContrast), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--popover--light"), light), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--popover--open"), open), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--popover--").concat(align), true), (0, _defineProperty2.default)(_cx, customClassName, !!customClassName), _cx));
  return /*#__PURE__*/_react.default.createElement(BaseComponent, (0, _extends2.default)({}, rest, {
    className: className,
    ref: ref
  }), children);
});

exports.Popover = Popover;
Popover.propTypes = {
  /**
   * Specify how the popover should align with the trigger element
   */
  align: _propTypes.default.oneOf(['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top']),

  /**
   * Provide a custom element or component to render the top-level node for the
   * component.
   */
  as: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Specify whether a caret should be rendered
   */
  caret: _propTypes.default.bool,

  /**
   * Provide elements to be rendered inside of the component
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom class name to be added to the outermost node in the
   * component
   */
  className: _propTypes.default.string,

  /**
   * Specify whether a drop shadow should be rendered on the popover
   */
  dropShadow: _propTypes.default.bool,

  /**
   * Render the component using the high-contrast variant
   */
  highContrast: _propTypes.default.bool,

  /**
   * Render the component using the light variant
   */
  light: _propTypes.default.bool,

  /**
   * Specify whether the component is currently open or closed
   */
  open: _propTypes.default.bool.isRequired
};

var PopoverContent = /*#__PURE__*/_react.default.forwardRef(function PopoverContent(_ref, ref) {
  var className = _ref.className,
      children = _ref.children,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded2);
  var prefix = (0, _usePrefix.usePrefix)();
  return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({}, rest, {
    className: "".concat(prefix, "--popover")
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: (0, _classnames.default)("".concat(prefix, "--popover-content"), className),
    ref: ref
  }, children), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--popover-caret")
  }));
});

exports.PopoverContent = PopoverContent;
PopoverContent.propTypes = {
  /**
   * Provide elements to be rendered inside of the component
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom class name to be added to the outermost node in the
   * component
   */
  className: _propTypes.default.string
};