"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _warning = require("../../internal/warning");

var _excluded = ["labelText", "iconDescription"];
var prefix = _carbonComponents.settings.prefix;
var didWarnAboutDeprecation = false;
/**
 * The filter button for `<Search>`.
 */

var SearchFilterButton = function SearchFilterButton(_ref) {
  var labelText = _ref.labelText,
      iconDescription = _ref.iconDescription,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  if (process.env.NODE_ENV !== "production") {
    process.env.NODE_ENV !== "production" ? (0, _warning.warning)(didWarnAboutDeprecation, 'The SearchFilterButton component has been deprecated and will be removed in the next major release of `carbon-components-react`') : void 0;
    didWarnAboutDeprecation = true;
  }

  return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    className: "".concat(prefix, "--search-button"),
    type: "button",
    "aria-label": labelText,
    title: labelText
  }, other), /*#__PURE__*/_react.default.createElement(_iconsReact.Filter16, {
    className: "".concat(prefix, "--search-filter"),
    "aria-label": iconDescription
  }));
};

SearchFilterButton.propTypes = {
  /**
   * The icon description.
   */
  iconDescription: _propTypes.default.string,

  /**
   * The a11y label text.
   */
  labelText: _propTypes.default.string
};
SearchFilterButton.defaultProps = {
  labelText: 'Search',
  iconDescription: 'filter'
};
var _default = SearchFilterButton;
exports.default = _default;