"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var FeatureFlags = _interopRequireWildcard(require("@carbon/feature-flags"));

var _carbonComponents = require("carbon-components");

var _excluded = ["children", "className", "disabled", "label"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var prefix = _carbonComponents.settings.prefix;

var SelectItemGroup = function SelectItemGroup(_ref) {
  var children = _ref.children,
      className = _ref.className,
      disabled = _ref.disabled,
      label = _ref.label,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classNames = (0, _classnames.default)("".concat(prefix, "--select-optgroup"), className);
  return /*#__PURE__*/_react.default.createElement("optgroup", (0, _extends2.default)({
    className: classNames,
    label: label,
    disabled: disabled
  }, other), children);
};

SelectItemGroup.propTypes = {
  /**
   * Provide the contents of your <SelectItemGroup>
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the <SelectItemGroup> should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify the label to be displayed
   */
  label: _propTypes.default.string.isRequired
};
SelectItemGroup.defaultProps = {
  disabled: false,
  label: FeatureFlags.enabled('enable-v11-release') ? undefined : 'Provide label'
};
var _default = SelectItemGroup;
exports.default = _default;