"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.ControlledSlider = exports.Playground = exports.Default = exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireWildcard(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Slider = _interopRequireDefault(require("../Slider"));

var _Slider2 = _interopRequireDefault(require("../Slider/Slider.Skeleton"));

var _FeatureFlags = require("../../internal/FeatureFlags");

var _Slider3 = _interopRequireDefault(require("./Slider.mdx"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var props = function props() {
  return {
    name: (0, _addonKnobs.text)('Form item name (name)', ''),
    inputType: (0, _addonKnobs.text)('The form element type (inputType)', 'number'),
    ariaLabelInput: (0, _addonKnobs.text)('The ARIA label for the <input> (ariaLabelInput)', 'Label for slider value'),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    light: (0, _addonKnobs.boolean)('Light variant (light)', false),
    hideTextInput: (0, _addonKnobs.boolean)('Without text input (hideTextInput)', false),
    value: !_FeatureFlags.sliderValuePropSync ? 50 : (0, _addonKnobs.number)('The value (value)', 50),
    min: (0, _addonKnobs.number)('The minimum value (min)', 0),
    max: (0, _addonKnobs.number)('The maximum value (max)', 100),
    step: (0, _addonKnobs.number)('The step (step)', 1),
    stepMultiplier: (0, _addonKnobs.number)('The step factor for Shift+arrow keys (stepMultiplier)', 5),
    labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Slider Label'),
    minLabel: (0, _addonKnobs.text)('Label for minimum value (minLabel)', ''),
    maxLabel: (0, _addonKnobs.text)('Label for maximum value (maxLabel)', ''),
    onChange: (0, _addonActions.action)('onChange'),
    onRelease: (0, _addonActions.action)('onRelease')
  };
};

var _default = {
  title: 'Components/Slider',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Slider.default,
    docs: {
      page: _Slider3.default
    },
    subcomponents: {
      SliderSkeleton: _Slider2.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_Slider.default, {
    labelText: "Slider Label",
    value: 50,
    min: 30,
    max: 100,
    step: 1,
    stepMultiplier: 10,
    novalidate: true
  });
};

exports.Default = Default;
Default.story = {
  name: 'Slider'
};

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement(_Slider.default, (0, _extends2.default)({
    id: "slider"
  }, props()));
};

exports.Playground = Playground;

var ControlledSlider = function ControlledSlider() {
  var _useState = (0, _react.useState)(87),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      val = _useState2[0],
      setVal = _useState2[1];

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setVal(Math.round(Math.random() * 100));
    }
  }, "randomize value"), /*#__PURE__*/_react.default.createElement(_Slider.default, {
    max: 100,
    min: 0,
    value: val,
    onChange: function onChange(_ref) {
      var value = _ref.value;
      return setVal(value);
    }
  }), /*#__PURE__*/_react.default.createElement("h1", null, val));
};

exports.ControlledSlider = ControlledSlider;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_Slider2.default, null);
};

exports.Skeleton = Skeleton;