"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.Skeleton = exports.Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Toggle = _interopRequireDefault(require("../Toggle"));

var _Toggle2 = _interopRequireDefault(require("../Toggle/Toggle.Skeleton"));

var _Text = require("../Text");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined
};

var toggleProps = function toggleProps() {
  return {
    labelText: (0, _addonKnobs.text)('Label toggle input control (labelText)', 'Toggle element label'),
    className: 'some-class',
    labelA: (0, _addonKnobs.text)('Label for untoggled state (labelA)', 'Off'),
    labelB: (0, _addonKnobs.text)('Label for toggled state (labelB)', 'On'),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    onChange: (0, _addonActions.action)('onChange'),
    onToggle: (0, _addonActions.action)('onToggle'),
    size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined
  };
};

var _default = {
  title: 'Components/Toggle',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Toggle.default,
    subcomponents: {}
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Toggle.default, {
    labelText: "Toggle (md)",
    size: "md",
    labelA: "Off",
    labelB: "On",
    defaultToggled: true,
    className: "some-class",
    id: "toggle-1"
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Toggle.default, {
    labelText: "Toggle (sm)",
    size: "sm",
    defaultToggled: true,
    className: "some-class",
    id: "toggle-2"
  }));
};

exports.Default = Default;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Text.Text, {
    as: "p"
  }, "Md skeleton with label"), /*#__PURE__*/_react.default.createElement(_Toggle2.default, {
    labelText: "Toggle label",
    id: "toggle-skeleton-id"
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Text.Text, {
    as: "p"
  }, "Sm skeleton with label"), /*#__PURE__*/_react.default.createElement(_Toggle2.default, {
    labelText: "Toggle label",
    id: "toggle-skeleton-id",
    size: "sm"
  }));
};

exports.Skeleton = Skeleton;

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement(_Toggle.default, (0, _extends2.default)({
    defaultToggled: true
  }, toggleProps(), {
    className: "some-class",
    id: "toggle-3"
  }));
};

exports.Playground = Playground;
Default.storyName = 'Toggle';