"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = _interopRequireDefault(require("lodash.debounce"));

var _setupGetInstanceId = _interopRequireDefault(require("../../tools/setupGetInstanceId"));

var _events = require("../../tools/events");

var _keyboard = require("../../internal/keyboard");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["id", "className", "triggerClassName", "children", "direction", "align", "onBlur", "onFocus", "onMouseEnter", "onMouseLeave", "tooltipText"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var getInstanceId = (0, _setupGetInstanceId.default)();

var TooltipDefinition = function TooltipDefinition(_ref) {
  var _cx;

  var id = _ref.id,
      className = _ref.className,
      triggerClassName = _ref.triggerClassName,
      children = _ref.children,
      direction = _ref.direction,
      align = _ref.align,
      onBlur = _ref.onBlur,
      onFocus = _ref.onFocus,
      onMouseEnter = _ref.onMouseEnter,
      onMouseLeave = _ref.onMouseLeave,
      tooltipText = _ref.tooltipText,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();

  var _useState = (0, _react.useState)(true),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      allowTooltipVisibility = _useState2[0],
      setAllowTooltipVisibility = _useState2[1];

  var _useState3 = (0, _react.useState)(false),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      tooltipVisible = _useState4[0],
      setTooltipVisible = _useState4[1];

  var tooltipId = id || "definition-tooltip-".concat(getInstanceId());
  var tooltipClassName = (0, _classnames.default)("".concat(prefix, "--tooltip--definition"), "".concat(prefix, "--tooltip--a11y"), className);
  var tooltipTriggerClasses = (0, _classnames.default)("".concat(prefix, "--tooltip__trigger"), "".concat(prefix, "--tooltip--a11y"), "".concat(prefix, "--tooltip__trigger--definition"), triggerClassName, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--tooltip--").concat(direction), direction), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--tooltip--align-").concat(align), align), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--tooltip--hidden"), !allowTooltipVisibility), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--tooltip--visible"), tooltipVisible), _cx));
  var debounceTooltipVisible = (0, _lodash.default)(function () {
    return setTooltipVisible(false);
  }, 100);

  var handleFocus = function handleFocus() {
    debounceTooltipVisible.cancel();
    setAllowTooltipVisibility(true);
    setTooltipVisible(true);
  };

  var handleBlur = debounceTooltipVisible;

  var handleMouseEnter = function handleMouseEnter() {
    debounceTooltipVisible.cancel();
    setAllowTooltipVisibility(true);
    setTooltipVisible(true);
  };

  var handleMouseLeave = debounceTooltipVisible;
  (0, _react.useEffect)(function () {
    var handleEscKeyDown = function handleEscKeyDown(event) {
      if ((0, _keyboard.matches)(event, [_keyboard.keys.Escape])) {
        setAllowTooltipVisibility(false);
      }
    };

    document.addEventListener('keydown', handleEscKeyDown);
    return function () {
      return document.removeEventListener('keydown', handleEscKeyDown);
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({}, rest, {
    className: tooltipClassName,
    onMouseEnter: (0, _events.composeEventHandlers)([onMouseEnter, handleMouseEnter]),
    onMouseLeave: (0, _events.composeEventHandlers)([onMouseLeave, handleMouseLeave])
  }), /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    className: tooltipTriggerClasses,
    "aria-describedby": tooltipId,
    onFocus: (0, _events.composeEventHandlers)([onFocus, handleFocus]),
    onBlur: (0, _events.composeEventHandlers)([onBlur, handleBlur])
  }, children), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--assistive-text"),
    id: tooltipId,
    role: "tooltip"
  }, tooltipText));
};

TooltipDefinition.propTypes = {
  /**
   * Specify the alignment (to the trigger button) of the tooltip.
   * Can be one of: start, center, or end.
   */
  align: _propTypes.default.oneOf(['start', 'center', 'end']),

  /**
   * Specify the tooltip trigger text that is rendered to the UI for the user to
   * interact with in order to display the tooltip.
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify the direction of the tooltip. Can be either top or bottom.
   */
  direction: _propTypes.default.oneOf(['top', 'bottom']),

  /**
   * Optionally specify a custom id for the tooltip. If one is not provided, we
   * generate a unique id for you.
   */
  id: _propTypes.default.string,

  /**
   * The event handler for the `blur` event.
   */
  onBlur: _propTypes.default.func,

  /**
   * The event handler for the `focus` event.
   */
  onFocus: _propTypes.default.func,

  /**
   * The event handler for the `mouseenter` event.
   */
  onMouseEnter: _propTypes.default.func,

  /**
   * The event handler for the `mouseleave` event.
   */
  onMouseLeave: _propTypes.default.func,

  /**
   * Provide the text that will be displayed in the tooltip when it is rendered.
   * TODO: rename this prop (will be a breaking change)
   */
  tooltipText: _propTypes.default.node.isRequired,

  /**
   * The CSS class name of the trigger element
   */
  triggerClassName: _propTypes.default.string
};
TooltipDefinition.defaultProps = {
  direction: 'bottom',
  align: 'start'
};
var _default = TooltipDefinition;
exports.default = _default;