"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

var _react = _interopRequireDefault(require("react"));

var _enzyme = require("enzyme");

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _ = _interopRequireWildcard(require("./"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;
describe('TreeView', function () {
  var wrapper;
  var onTreeSelect;
  var onNodeSelect;
  beforeEach(function () {
    onTreeSelect = jest.fn();
    onNodeSelect = jest.fn();
    wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_.default, {
      label: "Tree view",
      selected: ['1'],
      onSelect: onTreeSelect
    }, /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      id: "1",
      value: "1",
      label: "1"
    }), /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      id: "2",
      value: "2",
      label: "2",
      onSelect: onNodeSelect
    }), /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      id: "5",
      value: "5",
      label: "5",
      isExpanded: true
    }, /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      id: "5-1",
      value: "5-1",
      label: "5-1"
    }), /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      id: "5-2",
      value: "5-2",
      label: "5-2"
    }), /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      id: "5-3",
      value: "5-3",
      label: "5-3",
      isExpanded: true
    }, /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      id: "5-4",
      value: "5-4",
      label: "5-4"
    })))));
  });
  it('should render', function () {
    expect(wrapper).toMatchSnapshot();
  });
  it('should render with icons', function () {
    wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_.default, {
      label: "Tree view",
      selected: ['1']
    }, /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      renderIcon: _iconsReact.Document16,
      id: "1",
      value: "1",
      label: "1"
    }), /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      renderIcon: _iconsReact.Document16,
      id: "2",
      value: "2",
      label: "2"
    }), /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      renderIcon: _iconsReact.Folder16,
      id: "5",
      value: "5",
      label: "5",
      isExpanded: true
    }, /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      renderIcon: _iconsReact.Document16,
      id: "5-1",
      value: "5-1",
      label: "5-1"
    }), /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      renderIcon: _iconsReact.Document16,
      id: "5-2",
      value: "5-2",
      label: "5-2"
    }), /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      renderIcon: _iconsReact.Folder16,
      id: "5-3",
      value: "5-3",
      label: "5-3",
      isExpanded: true
    }, /*#__PURE__*/_react.default.createElement(_.TreeNode, {
      renderIcon: _iconsReact.Document16,
      id: "5-4",
      value: "5-4",
      label: "5-4"
    })))));
    expect(wrapper).toMatchSnapshot();
  });
  it('should be able to hide the label', function () {
    expect(wrapper.find('TreeLabel').text()).toBe('Tree view');
    wrapper.setProps({
      hideLabel: true
    });
    expect(wrapper.find('TreeLabel').text()).toBeFalsy();
  });
  describe('Single node selection', function () {
    it('should be able to preselect a node', function () {
      expect(wrapper.find(".".concat(prefix, "--tree-node--selected")).text()).toBe('1');
    });
    it('should handle selection at the tree level', function () {
      var onTreeSelect = jest.fn();
      wrapper.setProps({
        onSelect: onTreeSelect
      });
      wrapper.find('TreeNode[value="2"]').simulate('click');
      expect(onTreeSelect).toHaveBeenCalledTimes(1);
    });
    it('should handle selection at the node level', function () {
      wrapper.find('TreeNode[value="2"]').simulate('click');
      expect(onTreeSelect).toHaveBeenCalledTimes(1);
      expect(onNodeSelect).toHaveBeenCalledTimes(1);
    });
  });
  describe('Tree node expansion', function () {
    it('Caret icon should not render in leaf nodes', function () {
      expect(wrapper.find('ForwardRef(CaretDown16)').length).toBe(2);
    });
  });
});