"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _AriaPropTypes = require("../../prop-types/AriaPropTypes");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["aria-label", "aria-labelledby", "children", "className", "expanded"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var HeaderPanel = /*#__PURE__*/_react.default.forwardRef(function HeaderPanel(_ref, ref) {
  var _cx;

  var ariaLabel = _ref['aria-label'],
      ariaLabelledBy = _ref['aria-labelledby'],
      children = _ref.children,
      customClassName = _ref.className,
      expanded = _ref.expanded,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var accessibilityLabel = {
    'aria-label': ariaLabel,
    'aria-labelledby': ariaLabelledBy
  };
  var className = (0, _classnames.default)("".concat(prefix, "--header-panel"), (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--header-panel--expanded"), expanded), (0, _defineProperty2.default)(_cx, customClassName, !!customClassName), _cx));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, other, {
    className: className
  }, accessibilityLabel, {
    ref: ref
  }), children);
});

HeaderPanel.propTypes = _objectSpread(_objectSpread({}, _AriaPropTypes.AriaLabelPropType), {}, {
  /**
   * Optionally provide a custom class to apply to the underlying `<li>` node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the panel is expanded
   */
  expanded: _propTypes.default.bool
});
HeaderPanel.displayName = 'HeaderPanel';
var _default = HeaderPanel;
exports.default = _default;