"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _usePrefix = require("../../internal/usePrefix");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var SideNavItem = function SideNavItem(_ref) {
  var _cx;

  var customClassName = _ref.className,
      children = _ref.children,
      _ref$large = _ref.large,
      large = _ref$large === void 0 ? false : _ref$large;
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__item"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__item--large"), large), (0, _defineProperty2.default)(_cx, customClassName, !!customClassName), _cx));
  return /*#__PURE__*/_react.default.createElement("li", {
    className: className
  }, children);
};

SideNavItem.propTypes = {
  /**
   * Provide a single icon as the child to `SideNavIcon` to render in the
   * container
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Provide an optional class to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Specify if this is a large variation of the SideNavItem
   */
  large: _propTypes.default.bool
};
var _default = SideNavItem;
exports.default = _default;