// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package compute

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/compute/mgmt/2019-12-01/compute"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AccessLevel = original.AccessLevel

const (
	None  AccessLevel = original.None
	Read  AccessLevel = original.Read
	Write AccessLevel = original.Write
)

type AggregatedReplicationState = original.AggregatedReplicationState

const (
	Completed  AggregatedReplicationState = original.Completed
	Failed     AggregatedReplicationState = original.Failed
	InProgress AggregatedReplicationState = original.InProgress
	Unknown    AggregatedReplicationState = original.Unknown
)

type AvailabilitySetSkuTypes = original.AvailabilitySetSkuTypes

const (
	Aligned AvailabilitySetSkuTypes = original.Aligned
	Classic AvailabilitySetSkuTypes = original.Classic
)

type CachingTypes = original.CachingTypes

const (
	CachingTypesNone      CachingTypes = original.CachingTypesNone
	CachingTypesReadOnly  CachingTypes = original.CachingTypesReadOnly
	CachingTypesReadWrite CachingTypes = original.CachingTypesReadWrite
)

type ComponentNames = original.ComponentNames

const (
	MicrosoftWindowsShellSetup ComponentNames = original.MicrosoftWindowsShellSetup
)

type ContainerServiceOrchestratorTypes = original.ContainerServiceOrchestratorTypes

const (
	Custom     ContainerServiceOrchestratorTypes = original.Custom
	DCOS       ContainerServiceOrchestratorTypes = original.DCOS
	Kubernetes ContainerServiceOrchestratorTypes = original.Kubernetes
	Swarm      ContainerServiceOrchestratorTypes = original.Swarm
)

type ContainerServiceVMSizeTypes = original.ContainerServiceVMSizeTypes

const (
	StandardA0    ContainerServiceVMSizeTypes = original.StandardA0
	StandardA1    ContainerServiceVMSizeTypes = original.StandardA1
	StandardA10   ContainerServiceVMSizeTypes = original.StandardA10
	StandardA11   ContainerServiceVMSizeTypes = original.StandardA11
	StandardA2    ContainerServiceVMSizeTypes = original.StandardA2
	StandardA3    ContainerServiceVMSizeTypes = original.StandardA3
	StandardA4    ContainerServiceVMSizeTypes = original.StandardA4
	StandardA5    ContainerServiceVMSizeTypes = original.StandardA5
	StandardA6    ContainerServiceVMSizeTypes = original.StandardA6
	StandardA7    ContainerServiceVMSizeTypes = original.StandardA7
	StandardA8    ContainerServiceVMSizeTypes = original.StandardA8
	StandardA9    ContainerServiceVMSizeTypes = original.StandardA9
	StandardD1    ContainerServiceVMSizeTypes = original.StandardD1
	StandardD11   ContainerServiceVMSizeTypes = original.StandardD11
	StandardD11V2 ContainerServiceVMSizeTypes = original.StandardD11V2
	StandardD12   ContainerServiceVMSizeTypes = original.StandardD12
	StandardD12V2 ContainerServiceVMSizeTypes = original.StandardD12V2
	StandardD13   ContainerServiceVMSizeTypes = original.StandardD13
	StandardD13V2 ContainerServiceVMSizeTypes = original.StandardD13V2
	StandardD14   ContainerServiceVMSizeTypes = original.StandardD14
	StandardD14V2 ContainerServiceVMSizeTypes = original.StandardD14V2
	StandardD1V2  ContainerServiceVMSizeTypes = original.StandardD1V2
	StandardD2    ContainerServiceVMSizeTypes = original.StandardD2
	StandardD2V2  ContainerServiceVMSizeTypes = original.StandardD2V2
	StandardD3    ContainerServiceVMSizeTypes = original.StandardD3
	StandardD3V2  ContainerServiceVMSizeTypes = original.StandardD3V2
	StandardD4    ContainerServiceVMSizeTypes = original.StandardD4
	StandardD4V2  ContainerServiceVMSizeTypes = original.StandardD4V2
	StandardD5V2  ContainerServiceVMSizeTypes = original.StandardD5V2
	StandardDS1   ContainerServiceVMSizeTypes = original.StandardDS1
	StandardDS11  ContainerServiceVMSizeTypes = original.StandardDS11
	StandardDS12  ContainerServiceVMSizeTypes = original.StandardDS12
	StandardDS13  ContainerServiceVMSizeTypes = original.StandardDS13
	StandardDS14  ContainerServiceVMSizeTypes = original.StandardDS14
	StandardDS2   ContainerServiceVMSizeTypes = original.StandardDS2
	StandardDS3   ContainerServiceVMSizeTypes = original.StandardDS3
	StandardDS4   ContainerServiceVMSizeTypes = original.StandardDS4
	StandardG1    ContainerServiceVMSizeTypes = original.StandardG1
	StandardG2    ContainerServiceVMSizeTypes = original.StandardG2
	StandardG3    ContainerServiceVMSizeTypes = original.StandardG3
	StandardG4    ContainerServiceVMSizeTypes = original.StandardG4
	StandardG5    ContainerServiceVMSizeTypes = original.StandardG5
	StandardGS1   ContainerServiceVMSizeTypes = original.StandardGS1
	StandardGS2   ContainerServiceVMSizeTypes = original.StandardGS2
	StandardGS3   ContainerServiceVMSizeTypes = original.StandardGS3
	StandardGS4   ContainerServiceVMSizeTypes = original.StandardGS4
	StandardGS5   ContainerServiceVMSizeTypes = original.StandardGS5
)

type DedicatedHostLicenseTypes = original.DedicatedHostLicenseTypes

const (
	DedicatedHostLicenseTypesNone                   DedicatedHostLicenseTypes = original.DedicatedHostLicenseTypesNone
	DedicatedHostLicenseTypesWindowsServerHybrid    DedicatedHostLicenseTypes = original.DedicatedHostLicenseTypesWindowsServerHybrid
	DedicatedHostLicenseTypesWindowsServerPerpetual DedicatedHostLicenseTypes = original.DedicatedHostLicenseTypesWindowsServerPerpetual
)

type DiffDiskOptions = original.DiffDiskOptions

const (
	Local DiffDiskOptions = original.Local
)

type DiskCreateOption = original.DiskCreateOption

const (
	Attach    DiskCreateOption = original.Attach
	Copy      DiskCreateOption = original.Copy
	Empty     DiskCreateOption = original.Empty
	FromImage DiskCreateOption = original.FromImage
	Import    DiskCreateOption = original.Import
	Restore   DiskCreateOption = original.Restore
	Upload    DiskCreateOption = original.Upload
)

type DiskCreateOptionTypes = original.DiskCreateOptionTypes

const (
	DiskCreateOptionTypesAttach    DiskCreateOptionTypes = original.DiskCreateOptionTypesAttach
	DiskCreateOptionTypesEmpty     DiskCreateOptionTypes = original.DiskCreateOptionTypesEmpty
	DiskCreateOptionTypesFromImage DiskCreateOptionTypes = original.DiskCreateOptionTypesFromImage
)

type DiskEncryptionSetIdentityType = original.DiskEncryptionSetIdentityType

const (
	SystemAssigned DiskEncryptionSetIdentityType = original.SystemAssigned
)

type DiskState = original.DiskState

const (
	ActiveSAS     DiskState = original.ActiveSAS
	ActiveUpload  DiskState = original.ActiveUpload
	Attached      DiskState = original.Attached
	ReadyToUpload DiskState = original.ReadyToUpload
	Reserved      DiskState = original.Reserved
	Unattached    DiskState = original.Unattached
)

type DiskStorageAccountTypes = original.DiskStorageAccountTypes

const (
	PremiumLRS     DiskStorageAccountTypes = original.PremiumLRS
	StandardLRS    DiskStorageAccountTypes = original.StandardLRS
	StandardSSDLRS DiskStorageAccountTypes = original.StandardSSDLRS
	UltraSSDLRS    DiskStorageAccountTypes = original.UltraSSDLRS
)

type EncryptionType = original.EncryptionType

const (
	EncryptionAtRestWithCustomerKey EncryptionType = original.EncryptionAtRestWithCustomerKey
	EncryptionAtRestWithPlatformKey EncryptionType = original.EncryptionAtRestWithPlatformKey
)

type HostCaching = original.HostCaching

const (
	HostCachingNone      HostCaching = original.HostCachingNone
	HostCachingReadOnly  HostCaching = original.HostCachingReadOnly
	HostCachingReadWrite HostCaching = original.HostCachingReadWrite
)

type HyperVGeneration = original.HyperVGeneration

const (
	V1 HyperVGeneration = original.V1
	V2 HyperVGeneration = original.V2
)

type HyperVGenerationType = original.HyperVGenerationType

const (
	HyperVGenerationTypeV1 HyperVGenerationType = original.HyperVGenerationTypeV1
	HyperVGenerationTypeV2 HyperVGenerationType = original.HyperVGenerationTypeV2
)

type HyperVGenerationTypes = original.HyperVGenerationTypes

const (
	HyperVGenerationTypesV1 HyperVGenerationTypes = original.HyperVGenerationTypesV1
	HyperVGenerationTypesV2 HyperVGenerationTypes = original.HyperVGenerationTypesV2
)

type IPVersion = original.IPVersion

const (
	IPv4 IPVersion = original.IPv4
	IPv6 IPVersion = original.IPv6
)

type InstanceViewTypes = original.InstanceViewTypes

const (
	InstanceView InstanceViewTypes = original.InstanceView
)

type IntervalInMins = original.IntervalInMins

const (
	FiveMins   IntervalInMins = original.FiveMins
	SixtyMins  IntervalInMins = original.SixtyMins
	ThirtyMins IntervalInMins = original.ThirtyMins
	ThreeMins  IntervalInMins = original.ThreeMins
)

type MaintenanceOperationResultCodeTypes = original.MaintenanceOperationResultCodeTypes

const (
	MaintenanceOperationResultCodeTypesMaintenanceAborted   MaintenanceOperationResultCodeTypes = original.MaintenanceOperationResultCodeTypesMaintenanceAborted
	MaintenanceOperationResultCodeTypesMaintenanceCompleted MaintenanceOperationResultCodeTypes = original.MaintenanceOperationResultCodeTypesMaintenanceCompleted
	MaintenanceOperationResultCodeTypesNone                 MaintenanceOperationResultCodeTypes = original.MaintenanceOperationResultCodeTypesNone
	MaintenanceOperationResultCodeTypesRetryLater           MaintenanceOperationResultCodeTypes = original.MaintenanceOperationResultCodeTypesRetryLater
)

type OperatingSystemStateTypes = original.OperatingSystemStateTypes

const (
	Generalized OperatingSystemStateTypes = original.Generalized
	Specialized OperatingSystemStateTypes = original.Specialized
)

type OperatingSystemTypes = original.OperatingSystemTypes

const (
	Linux   OperatingSystemTypes = original.Linux
	Windows OperatingSystemTypes = original.Windows
)

type PassNames = original.PassNames

const (
	OobeSystem PassNames = original.OobeSystem
)

type ProtocolTypes = original.ProtocolTypes

const (
	HTTP  ProtocolTypes = original.HTTP
	HTTPS ProtocolTypes = original.HTTPS
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateCreating  ProvisioningState = original.ProvisioningStateCreating
	ProvisioningStateDeleting  ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed    ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateMigrating ProvisioningState = original.ProvisioningStateMigrating
	ProvisioningStateSucceeded ProvisioningState = original.ProvisioningStateSucceeded
	ProvisioningStateUpdating  ProvisioningState = original.ProvisioningStateUpdating
)

type ProvisioningState1 = original.ProvisioningState1

const (
	ProvisioningState1Creating  ProvisioningState1 = original.ProvisioningState1Creating
	ProvisioningState1Deleting  ProvisioningState1 = original.ProvisioningState1Deleting
	ProvisioningState1Failed    ProvisioningState1 = original.ProvisioningState1Failed
	ProvisioningState1Migrating ProvisioningState1 = original.ProvisioningState1Migrating
	ProvisioningState1Succeeded ProvisioningState1 = original.ProvisioningState1Succeeded
	ProvisioningState1Updating  ProvisioningState1 = original.ProvisioningState1Updating
)

type ProvisioningState2 = original.ProvisioningState2

const (
	ProvisioningState2Creating  ProvisioningState2 = original.ProvisioningState2Creating
	ProvisioningState2Deleting  ProvisioningState2 = original.ProvisioningState2Deleting
	ProvisioningState2Failed    ProvisioningState2 = original.ProvisioningState2Failed
	ProvisioningState2Migrating ProvisioningState2 = original.ProvisioningState2Migrating
	ProvisioningState2Succeeded ProvisioningState2 = original.ProvisioningState2Succeeded
	ProvisioningState2Updating  ProvisioningState2 = original.ProvisioningState2Updating
)

type ProvisioningState3 = original.ProvisioningState3

const (
	ProvisioningState3Creating  ProvisioningState3 = original.ProvisioningState3Creating
	ProvisioningState3Deleting  ProvisioningState3 = original.ProvisioningState3Deleting
	ProvisioningState3Failed    ProvisioningState3 = original.ProvisioningState3Failed
	ProvisioningState3Migrating ProvisioningState3 = original.ProvisioningState3Migrating
	ProvisioningState3Succeeded ProvisioningState3 = original.ProvisioningState3Succeeded
	ProvisioningState3Updating  ProvisioningState3 = original.ProvisioningState3Updating
)

type ProximityPlacementGroupType = original.ProximityPlacementGroupType

const (
	Standard ProximityPlacementGroupType = original.Standard
	Ultra    ProximityPlacementGroupType = original.Ultra
)

type ReplicationState = original.ReplicationState

const (
	ReplicationStateCompleted   ReplicationState = original.ReplicationStateCompleted
	ReplicationStateFailed      ReplicationState = original.ReplicationStateFailed
	ReplicationStateReplicating ReplicationState = original.ReplicationStateReplicating
	ReplicationStateUnknown     ReplicationState = original.ReplicationStateUnknown
)

type ReplicationStatusTypes = original.ReplicationStatusTypes

const (
	ReplicationStatusTypesReplicationStatus ReplicationStatusTypes = original.ReplicationStatusTypesReplicationStatus
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	ResourceIdentityTypeNone                       ResourceIdentityType = original.ResourceIdentityTypeNone
	ResourceIdentityTypeSystemAssigned             ResourceIdentityType = original.ResourceIdentityTypeSystemAssigned
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = original.ResourceIdentityTypeSystemAssignedUserAssigned
	ResourceIdentityTypeUserAssigned               ResourceIdentityType = original.ResourceIdentityTypeUserAssigned
)

type ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleType

const (
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeAutomatic
	ResourceSkuCapacityScaleTypeManual    ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeManual
	ResourceSkuCapacityScaleTypeNone      ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeNone
)

type ResourceSkuRestrictionsReasonCode = original.ResourceSkuRestrictionsReasonCode

const (
	NotAvailableForSubscription ResourceSkuRestrictionsReasonCode = original.NotAvailableForSubscription
	QuotaID                     ResourceSkuRestrictionsReasonCode = original.QuotaID
)

type ResourceSkuRestrictionsType = original.ResourceSkuRestrictionsType

const (
	Location ResourceSkuRestrictionsType = original.Location
	Zone     ResourceSkuRestrictionsType = original.Zone
)

type RollingUpgradeActionType = original.RollingUpgradeActionType

const (
	Cancel RollingUpgradeActionType = original.Cancel
	Start  RollingUpgradeActionType = original.Start
)

type RollingUpgradeStatusCode = original.RollingUpgradeStatusCode

const (
	RollingUpgradeStatusCodeCancelled      RollingUpgradeStatusCode = original.RollingUpgradeStatusCodeCancelled
	RollingUpgradeStatusCodeCompleted      RollingUpgradeStatusCode = original.RollingUpgradeStatusCodeCompleted
	RollingUpgradeStatusCodeFaulted        RollingUpgradeStatusCode = original.RollingUpgradeStatusCodeFaulted
	RollingUpgradeStatusCodeRollingForward RollingUpgradeStatusCode = original.RollingUpgradeStatusCodeRollingForward
)

type SettingNames = original.SettingNames

const (
	AutoLogon          SettingNames = original.AutoLogon
	FirstLogonCommands SettingNames = original.FirstLogonCommands
)

type SnapshotStorageAccountTypes = original.SnapshotStorageAccountTypes

const (
	SnapshotStorageAccountTypesPremiumLRS  SnapshotStorageAccountTypes = original.SnapshotStorageAccountTypesPremiumLRS
	SnapshotStorageAccountTypesStandardLRS SnapshotStorageAccountTypes = original.SnapshotStorageAccountTypesStandardLRS
	SnapshotStorageAccountTypesStandardZRS SnapshotStorageAccountTypes = original.SnapshotStorageAccountTypesStandardZRS
)

type StatusLevelTypes = original.StatusLevelTypes

const (
	Error   StatusLevelTypes = original.Error
	Info    StatusLevelTypes = original.Info
	Warning StatusLevelTypes = original.Warning
)

type StorageAccountType = original.StorageAccountType

const (
	StorageAccountTypeStandardLRS StorageAccountType = original.StorageAccountTypeStandardLRS
	StorageAccountTypeStandardZRS StorageAccountType = original.StorageAccountTypeStandardZRS
)

type StorageAccountTypes = original.StorageAccountTypes

const (
	StorageAccountTypesPremiumLRS     StorageAccountTypes = original.StorageAccountTypesPremiumLRS
	StorageAccountTypesStandardLRS    StorageAccountTypes = original.StorageAccountTypesStandardLRS
	StorageAccountTypesStandardSSDLRS StorageAccountTypes = original.StorageAccountTypesStandardSSDLRS
	StorageAccountTypesUltraSSDLRS    StorageAccountTypes = original.StorageAccountTypesUltraSSDLRS
)

type UpgradeMode = original.UpgradeMode

const (
	Automatic UpgradeMode = original.Automatic
	Manual    UpgradeMode = original.Manual
	Rolling   UpgradeMode = original.Rolling
)

type UpgradeOperationInvoker = original.UpgradeOperationInvoker

const (
	UpgradeOperationInvokerPlatform UpgradeOperationInvoker = original.UpgradeOperationInvokerPlatform
	UpgradeOperationInvokerUnknown  UpgradeOperationInvoker = original.UpgradeOperationInvokerUnknown
	UpgradeOperationInvokerUser     UpgradeOperationInvoker = original.UpgradeOperationInvokerUser
)

type UpgradeState = original.UpgradeState

const (
	UpgradeStateCancelled      UpgradeState = original.UpgradeStateCancelled
	UpgradeStateCompleted      UpgradeState = original.UpgradeStateCompleted
	UpgradeStateFaulted        UpgradeState = original.UpgradeStateFaulted
	UpgradeStateRollingForward UpgradeState = original.UpgradeStateRollingForward
)

type VirtualMachineEvictionPolicyTypes = original.VirtualMachineEvictionPolicyTypes

const (
	Deallocate VirtualMachineEvictionPolicyTypes = original.Deallocate
	Delete     VirtualMachineEvictionPolicyTypes = original.Delete
)

type VirtualMachinePriorityTypes = original.VirtualMachinePriorityTypes

const (
	Low     VirtualMachinePriorityTypes = original.Low
	Regular VirtualMachinePriorityTypes = original.Regular
	Spot    VirtualMachinePriorityTypes = original.Spot
)

type VirtualMachineScaleSetScaleInRules = original.VirtualMachineScaleSetScaleInRules

const (
	Default  VirtualMachineScaleSetScaleInRules = original.Default
	NewestVM VirtualMachineScaleSetScaleInRules = original.NewestVM
	OldestVM VirtualMachineScaleSetScaleInRules = original.OldestVM
)

type VirtualMachineScaleSetSkuScaleType = original.VirtualMachineScaleSetSkuScaleType

const (
	VirtualMachineScaleSetSkuScaleTypeAutomatic VirtualMachineScaleSetSkuScaleType = original.VirtualMachineScaleSetSkuScaleTypeAutomatic
	VirtualMachineScaleSetSkuScaleTypeNone      VirtualMachineScaleSetSkuScaleType = original.VirtualMachineScaleSetSkuScaleTypeNone
)

type VirtualMachineSizeTypes = original.VirtualMachineSizeTypes

const (
	VirtualMachineSizeTypesBasicA0          VirtualMachineSizeTypes = original.VirtualMachineSizeTypesBasicA0
	VirtualMachineSizeTypesBasicA1          VirtualMachineSizeTypes = original.VirtualMachineSizeTypesBasicA1
	VirtualMachineSizeTypesBasicA2          VirtualMachineSizeTypes = original.VirtualMachineSizeTypesBasicA2
	VirtualMachineSizeTypesBasicA3          VirtualMachineSizeTypes = original.VirtualMachineSizeTypesBasicA3
	VirtualMachineSizeTypesBasicA4          VirtualMachineSizeTypes = original.VirtualMachineSizeTypesBasicA4
	VirtualMachineSizeTypesStandardA0       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA0
	VirtualMachineSizeTypesStandardA1       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA1
	VirtualMachineSizeTypesStandardA10      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA10
	VirtualMachineSizeTypesStandardA11      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA11
	VirtualMachineSizeTypesStandardA1V2     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA1V2
	VirtualMachineSizeTypesStandardA2       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA2
	VirtualMachineSizeTypesStandardA2mV2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA2mV2
	VirtualMachineSizeTypesStandardA2V2     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA2V2
	VirtualMachineSizeTypesStandardA3       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA3
	VirtualMachineSizeTypesStandardA4       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA4
	VirtualMachineSizeTypesStandardA4mV2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA4mV2
	VirtualMachineSizeTypesStandardA4V2     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA4V2
	VirtualMachineSizeTypesStandardA5       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA5
	VirtualMachineSizeTypesStandardA6       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA6
	VirtualMachineSizeTypesStandardA7       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA7
	VirtualMachineSizeTypesStandardA8       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA8
	VirtualMachineSizeTypesStandardA8mV2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA8mV2
	VirtualMachineSizeTypesStandardA8V2     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA8V2
	VirtualMachineSizeTypesStandardA9       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardA9
	VirtualMachineSizeTypesStandardB1ms     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardB1ms
	VirtualMachineSizeTypesStandardB1s      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardB1s
	VirtualMachineSizeTypesStandardB2ms     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardB2ms
	VirtualMachineSizeTypesStandardB2s      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardB2s
	VirtualMachineSizeTypesStandardB4ms     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardB4ms
	VirtualMachineSizeTypesStandardB8ms     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardB8ms
	VirtualMachineSizeTypesStandardD1       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD1
	VirtualMachineSizeTypesStandardD11      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD11
	VirtualMachineSizeTypesStandardD11V2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD11V2
	VirtualMachineSizeTypesStandardD12      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD12
	VirtualMachineSizeTypesStandardD12V2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD12V2
	VirtualMachineSizeTypesStandardD13      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD13
	VirtualMachineSizeTypesStandardD13V2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD13V2
	VirtualMachineSizeTypesStandardD14      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD14
	VirtualMachineSizeTypesStandardD14V2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD14V2
	VirtualMachineSizeTypesStandardD15V2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD15V2
	VirtualMachineSizeTypesStandardD16sV3   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD16sV3
	VirtualMachineSizeTypesStandardD16V3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD16V3
	VirtualMachineSizeTypesStandardD1V2     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD1V2
	VirtualMachineSizeTypesStandardD2       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD2
	VirtualMachineSizeTypesStandardD2sV3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD2sV3
	VirtualMachineSizeTypesStandardD2V2     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD2V2
	VirtualMachineSizeTypesStandardD2V3     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD2V3
	VirtualMachineSizeTypesStandardD3       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD3
	VirtualMachineSizeTypesStandardD32sV3   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD32sV3
	VirtualMachineSizeTypesStandardD32V3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD32V3
	VirtualMachineSizeTypesStandardD3V2     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD3V2
	VirtualMachineSizeTypesStandardD4       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD4
	VirtualMachineSizeTypesStandardD4sV3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD4sV3
	VirtualMachineSizeTypesStandardD4V2     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD4V2
	VirtualMachineSizeTypesStandardD4V3     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD4V3
	VirtualMachineSizeTypesStandardD5V2     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD5V2
	VirtualMachineSizeTypesStandardD64sV3   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD64sV3
	VirtualMachineSizeTypesStandardD64V3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD64V3
	VirtualMachineSizeTypesStandardD8sV3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD8sV3
	VirtualMachineSizeTypesStandardD8V3     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardD8V3
	VirtualMachineSizeTypesStandardDS1      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS1
	VirtualMachineSizeTypesStandardDS11     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS11
	VirtualMachineSizeTypesStandardDS11V2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS11V2
	VirtualMachineSizeTypesStandardDS12     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS12
	VirtualMachineSizeTypesStandardDS12V2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS12V2
	VirtualMachineSizeTypesStandardDS13     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS13
	VirtualMachineSizeTypesStandardDS132V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS132V2
	VirtualMachineSizeTypesStandardDS134V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS134V2
	VirtualMachineSizeTypesStandardDS13V2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS13V2
	VirtualMachineSizeTypesStandardDS14     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS14
	VirtualMachineSizeTypesStandardDS144V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS144V2
	VirtualMachineSizeTypesStandardDS148V2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS148V2
	VirtualMachineSizeTypesStandardDS14V2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS14V2
	VirtualMachineSizeTypesStandardDS15V2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS15V2
	VirtualMachineSizeTypesStandardDS1V2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS1V2
	VirtualMachineSizeTypesStandardDS2      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS2
	VirtualMachineSizeTypesStandardDS2V2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS2V2
	VirtualMachineSizeTypesStandardDS3      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS3
	VirtualMachineSizeTypesStandardDS3V2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS3V2
	VirtualMachineSizeTypesStandardDS4      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS4
	VirtualMachineSizeTypesStandardDS4V2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS4V2
	VirtualMachineSizeTypesStandardDS5V2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardDS5V2
	VirtualMachineSizeTypesStandardE16sV3   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE16sV3
	VirtualMachineSizeTypesStandardE16V3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE16V3
	VirtualMachineSizeTypesStandardE2sV3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE2sV3
	VirtualMachineSizeTypesStandardE2V3     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE2V3
	VirtualMachineSizeTypesStandardE3216V3  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE3216V3
	VirtualMachineSizeTypesStandardE328sV3  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE328sV3
	VirtualMachineSizeTypesStandardE32sV3   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE32sV3
	VirtualMachineSizeTypesStandardE32V3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE32V3
	VirtualMachineSizeTypesStandardE4sV3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE4sV3
	VirtualMachineSizeTypesStandardE4V3     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE4V3
	VirtualMachineSizeTypesStandardE6416sV3 VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE6416sV3
	VirtualMachineSizeTypesStandardE6432sV3 VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE6432sV3
	VirtualMachineSizeTypesStandardE64sV3   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE64sV3
	VirtualMachineSizeTypesStandardE64V3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE64V3
	VirtualMachineSizeTypesStandardE8sV3    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE8sV3
	VirtualMachineSizeTypesStandardE8V3     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardE8V3
	VirtualMachineSizeTypesStandardF1       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF1
	VirtualMachineSizeTypesStandardF16      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF16
	VirtualMachineSizeTypesStandardF16s     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF16s
	VirtualMachineSizeTypesStandardF16sV2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF16sV2
	VirtualMachineSizeTypesStandardF1s      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF1s
	VirtualMachineSizeTypesStandardF2       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF2
	VirtualMachineSizeTypesStandardF2s      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF2s
	VirtualMachineSizeTypesStandardF2sV2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF2sV2
	VirtualMachineSizeTypesStandardF32sV2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF32sV2
	VirtualMachineSizeTypesStandardF4       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF4
	VirtualMachineSizeTypesStandardF4s      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF4s
	VirtualMachineSizeTypesStandardF4sV2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF4sV2
	VirtualMachineSizeTypesStandardF64sV2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF64sV2
	VirtualMachineSizeTypesStandardF72sV2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF72sV2
	VirtualMachineSizeTypesStandardF8       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF8
	VirtualMachineSizeTypesStandardF8s      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF8s
	VirtualMachineSizeTypesStandardF8sV2    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardF8sV2
	VirtualMachineSizeTypesStandardG1       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardG1
	VirtualMachineSizeTypesStandardG2       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardG2
	VirtualMachineSizeTypesStandardG3       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardG3
	VirtualMachineSizeTypesStandardG4       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardG4
	VirtualMachineSizeTypesStandardG5       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardG5
	VirtualMachineSizeTypesStandardGS1      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardGS1
	VirtualMachineSizeTypesStandardGS2      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardGS2
	VirtualMachineSizeTypesStandardGS3      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardGS3
	VirtualMachineSizeTypesStandardGS4      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardGS4
	VirtualMachineSizeTypesStandardGS44     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardGS44
	VirtualMachineSizeTypesStandardGS48     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardGS48
	VirtualMachineSizeTypesStandardGS5      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardGS5
	VirtualMachineSizeTypesStandardGS516    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardGS516
	VirtualMachineSizeTypesStandardGS58     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardGS58
	VirtualMachineSizeTypesStandardH16      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardH16
	VirtualMachineSizeTypesStandardH16m     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardH16m
	VirtualMachineSizeTypesStandardH16mr    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardH16mr
	VirtualMachineSizeTypesStandardH16r     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardH16r
	VirtualMachineSizeTypesStandardH8       VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardH8
	VirtualMachineSizeTypesStandardH8m      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardH8m
	VirtualMachineSizeTypesStandardL16s     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardL16s
	VirtualMachineSizeTypesStandardL32s     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardL32s
	VirtualMachineSizeTypesStandardL4s      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardL4s
	VirtualMachineSizeTypesStandardL8s      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardL8s
	VirtualMachineSizeTypesStandardM12832ms VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardM12832ms
	VirtualMachineSizeTypesStandardM12864ms VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardM12864ms
	VirtualMachineSizeTypesStandardM128ms   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardM128ms
	VirtualMachineSizeTypesStandardM128s    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardM128s
	VirtualMachineSizeTypesStandardM6416ms  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardM6416ms
	VirtualMachineSizeTypesStandardM6432ms  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardM6432ms
	VirtualMachineSizeTypesStandardM64ms    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardM64ms
	VirtualMachineSizeTypesStandardM64s     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardM64s
	VirtualMachineSizeTypesStandardNC12     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC12
	VirtualMachineSizeTypesStandardNC12sV2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC12sV2
	VirtualMachineSizeTypesStandardNC12sV3  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC12sV3
	VirtualMachineSizeTypesStandardNC24     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC24
	VirtualMachineSizeTypesStandardNC24r    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC24r
	VirtualMachineSizeTypesStandardNC24rsV2 VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC24rsV2
	VirtualMachineSizeTypesStandardNC24rsV3 VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC24rsV3
	VirtualMachineSizeTypesStandardNC24sV2  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC24sV2
	VirtualMachineSizeTypesStandardNC24sV3  VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC24sV3
	VirtualMachineSizeTypesStandardNC6      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC6
	VirtualMachineSizeTypesStandardNC6sV2   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC6sV2
	VirtualMachineSizeTypesStandardNC6sV3   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNC6sV3
	VirtualMachineSizeTypesStandardND12s    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardND12s
	VirtualMachineSizeTypesStandardND24rs   VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardND24rs
	VirtualMachineSizeTypesStandardND24s    VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardND24s
	VirtualMachineSizeTypesStandardND6s     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardND6s
	VirtualMachineSizeTypesStandardNV12     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNV12
	VirtualMachineSizeTypesStandardNV24     VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNV24
	VirtualMachineSizeTypesStandardNV6      VirtualMachineSizeTypes = original.VirtualMachineSizeTypesStandardNV6
)

type APIEntityReference = original.APIEntityReference
type APIError = original.APIError
type APIErrorBase = original.APIErrorBase
type AccessURI = original.AccessURI
type AdditionalCapabilities = original.AdditionalCapabilities
type AdditionalUnattendContent = original.AdditionalUnattendContent
type AutomaticOSUpgradePolicy = original.AutomaticOSUpgradePolicy
type AutomaticOSUpgradeProperties = original.AutomaticOSUpgradeProperties
type AutomaticRepairsPolicy = original.AutomaticRepairsPolicy
type AvailabilitySet = original.AvailabilitySet
type AvailabilitySetListResult = original.AvailabilitySetListResult
type AvailabilitySetListResultIterator = original.AvailabilitySetListResultIterator
type AvailabilitySetListResultPage = original.AvailabilitySetListResultPage
type AvailabilitySetProperties = original.AvailabilitySetProperties
type AvailabilitySetUpdate = original.AvailabilitySetUpdate
type AvailabilitySetsClient = original.AvailabilitySetsClient
type BaseClient = original.BaseClient
type BillingProfile = original.BillingProfile
type BootDiagnostics = original.BootDiagnostics
type BootDiagnosticsInstanceView = original.BootDiagnosticsInstanceView
type CloudError = original.CloudError
type ContainerService = original.ContainerService
type ContainerServiceAgentPoolProfile = original.ContainerServiceAgentPoolProfile
type ContainerServiceCustomProfile = original.ContainerServiceCustomProfile
type ContainerServiceDiagnosticsProfile = original.ContainerServiceDiagnosticsProfile
type ContainerServiceLinuxProfile = original.ContainerServiceLinuxProfile
type ContainerServiceListResult = original.ContainerServiceListResult
type ContainerServiceListResultIterator = original.ContainerServiceListResultIterator
type ContainerServiceListResultPage = original.ContainerServiceListResultPage
type ContainerServiceMasterProfile = original.ContainerServiceMasterProfile
type ContainerServiceOrchestratorProfile = original.ContainerServiceOrchestratorProfile
type ContainerServiceProperties = original.ContainerServiceProperties
type ContainerServiceSSHConfiguration = original.ContainerServiceSSHConfiguration
type ContainerServiceSSHPublicKey = original.ContainerServiceSSHPublicKey
type ContainerServiceServicePrincipalProfile = original.ContainerServiceServicePrincipalProfile
type ContainerServiceVMDiagnostics = original.ContainerServiceVMDiagnostics
type ContainerServiceWindowsProfile = original.ContainerServiceWindowsProfile
type ContainerServicesClient = original.ContainerServicesClient
type ContainerServicesCreateOrUpdateFuture = original.ContainerServicesCreateOrUpdateFuture
type ContainerServicesDeleteFuture = original.ContainerServicesDeleteFuture
type CreationData = original.CreationData
type DataDisk = original.DataDisk
type DataDiskImage = original.DataDiskImage
type DataDiskImageEncryption = original.DataDiskImageEncryption
type DedicatedHost = original.DedicatedHost
type DedicatedHostAllocatableVM = original.DedicatedHostAllocatableVM
type DedicatedHostAvailableCapacity = original.DedicatedHostAvailableCapacity
type DedicatedHostGroup = original.DedicatedHostGroup
type DedicatedHostGroupListResult = original.DedicatedHostGroupListResult
type DedicatedHostGroupListResultIterator = original.DedicatedHostGroupListResultIterator
type DedicatedHostGroupListResultPage = original.DedicatedHostGroupListResultPage
type DedicatedHostGroupProperties = original.DedicatedHostGroupProperties
type DedicatedHostGroupUpdate = original.DedicatedHostGroupUpdate
type DedicatedHostGroupsClient = original.DedicatedHostGroupsClient
type DedicatedHostInstanceView = original.DedicatedHostInstanceView
type DedicatedHostListResult = original.DedicatedHostListResult
type DedicatedHostListResultIterator = original.DedicatedHostListResultIterator
type DedicatedHostListResultPage = original.DedicatedHostListResultPage
type DedicatedHostProperties = original.DedicatedHostProperties
type DedicatedHostUpdate = original.DedicatedHostUpdate
type DedicatedHostsClient = original.DedicatedHostsClient
type DedicatedHostsCreateOrUpdateFuture = original.DedicatedHostsCreateOrUpdateFuture
type DedicatedHostsDeleteFuture = original.DedicatedHostsDeleteFuture
type DedicatedHostsUpdateFuture = original.DedicatedHostsUpdateFuture
type DiagnosticsProfile = original.DiagnosticsProfile
type DiffDiskSettings = original.DiffDiskSettings
type Disallowed = original.Disallowed
type Disk = original.Disk
type DiskEncryptionSet = original.DiskEncryptionSet
type DiskEncryptionSetList = original.DiskEncryptionSetList
type DiskEncryptionSetListIterator = original.DiskEncryptionSetListIterator
type DiskEncryptionSetListPage = original.DiskEncryptionSetListPage
type DiskEncryptionSetParameters = original.DiskEncryptionSetParameters
type DiskEncryptionSetUpdate = original.DiskEncryptionSetUpdate
type DiskEncryptionSetUpdateProperties = original.DiskEncryptionSetUpdateProperties
type DiskEncryptionSetsClient = original.DiskEncryptionSetsClient
type DiskEncryptionSetsCreateOrUpdateFuture = original.DiskEncryptionSetsCreateOrUpdateFuture
type DiskEncryptionSetsDeleteFuture = original.DiskEncryptionSetsDeleteFuture
type DiskEncryptionSetsUpdateFuture = original.DiskEncryptionSetsUpdateFuture
type DiskEncryptionSettings = original.DiskEncryptionSettings
type DiskImageEncryption = original.DiskImageEncryption
type DiskInstanceView = original.DiskInstanceView
type DiskList = original.DiskList
type DiskListIterator = original.DiskListIterator
type DiskListPage = original.DiskListPage
type DiskProperties = original.DiskProperties
type DiskSku = original.DiskSku
type DiskUpdate = original.DiskUpdate
type DiskUpdateProperties = original.DiskUpdateProperties
type DisksClient = original.DisksClient
type DisksCreateOrUpdateFuture = original.DisksCreateOrUpdateFuture
type DisksDeleteFuture = original.DisksDeleteFuture
type DisksGrantAccessFuture = original.DisksGrantAccessFuture
type DisksRevokeAccessFuture = original.DisksRevokeAccessFuture
type DisksUpdateFuture = original.DisksUpdateFuture
type Encryption = original.Encryption
type EncryptionImages = original.EncryptionImages
type EncryptionSetIdentity = original.EncryptionSetIdentity
type EncryptionSetProperties = original.EncryptionSetProperties
type EncryptionSettingsCollection = original.EncryptionSettingsCollection
type EncryptionSettingsElement = original.EncryptionSettingsElement
type GalleriesClient = original.GalleriesClient
type GalleriesCreateOrUpdateFuture = original.GalleriesCreateOrUpdateFuture
type GalleriesDeleteFuture = original.GalleriesDeleteFuture
type GalleriesUpdateFuture = original.GalleriesUpdateFuture
type Gallery = original.Gallery
type GalleryApplication = original.GalleryApplication
type GalleryApplicationList = original.GalleryApplicationList
type GalleryApplicationListIterator = original.GalleryApplicationListIterator
type GalleryApplicationListPage = original.GalleryApplicationListPage
type GalleryApplicationProperties = original.GalleryApplicationProperties
type GalleryApplicationUpdate = original.GalleryApplicationUpdate
type GalleryApplicationVersion = original.GalleryApplicationVersion
type GalleryApplicationVersionList = original.GalleryApplicationVersionList
type GalleryApplicationVersionListIterator = original.GalleryApplicationVersionListIterator
type GalleryApplicationVersionListPage = original.GalleryApplicationVersionListPage
type GalleryApplicationVersionProperties = original.GalleryApplicationVersionProperties
type GalleryApplicationVersionPublishingProfile = original.GalleryApplicationVersionPublishingProfile
type GalleryApplicationVersionUpdate = original.GalleryApplicationVersionUpdate
type GalleryApplicationVersionsClient = original.GalleryApplicationVersionsClient
type GalleryApplicationVersionsCreateOrUpdateFuture = original.GalleryApplicationVersionsCreateOrUpdateFuture
type GalleryApplicationVersionsDeleteFuture = original.GalleryApplicationVersionsDeleteFuture
type GalleryApplicationVersionsUpdateFuture = original.GalleryApplicationVersionsUpdateFuture
type GalleryApplicationsClient = original.GalleryApplicationsClient
type GalleryApplicationsCreateOrUpdateFuture = original.GalleryApplicationsCreateOrUpdateFuture
type GalleryApplicationsDeleteFuture = original.GalleryApplicationsDeleteFuture
type GalleryApplicationsUpdateFuture = original.GalleryApplicationsUpdateFuture
type GalleryArtifactPublishingProfileBase = original.GalleryArtifactPublishingProfileBase
type GalleryArtifactSource = original.GalleryArtifactSource
type GalleryArtifactVersionSource = original.GalleryArtifactVersionSource
type GalleryDataDiskImage = original.GalleryDataDiskImage
type GalleryDiskImage = original.GalleryDiskImage
type GalleryIdentifier = original.GalleryIdentifier
type GalleryImage = original.GalleryImage
type GalleryImageIdentifier = original.GalleryImageIdentifier
type GalleryImageList = original.GalleryImageList
type GalleryImageListIterator = original.GalleryImageListIterator
type GalleryImageListPage = original.GalleryImageListPage
type GalleryImageProperties = original.GalleryImageProperties
type GalleryImageUpdate = original.GalleryImageUpdate
type GalleryImageVersion = original.GalleryImageVersion
type GalleryImageVersionList = original.GalleryImageVersionList
type GalleryImageVersionListIterator = original.GalleryImageVersionListIterator
type GalleryImageVersionListPage = original.GalleryImageVersionListPage
type GalleryImageVersionProperties = original.GalleryImageVersionProperties
type GalleryImageVersionPublishingProfile = original.GalleryImageVersionPublishingProfile
type GalleryImageVersionStorageProfile = original.GalleryImageVersionStorageProfile
type GalleryImageVersionUpdate = original.GalleryImageVersionUpdate
type GalleryImageVersionsClient = original.GalleryImageVersionsClient
type GalleryImageVersionsCreateOrUpdateFuture = original.GalleryImageVersionsCreateOrUpdateFuture
type GalleryImageVersionsDeleteFuture = original.GalleryImageVersionsDeleteFuture
type GalleryImageVersionsUpdateFuture = original.GalleryImageVersionsUpdateFuture
type GalleryImagesClient = original.GalleryImagesClient
type GalleryImagesCreateOrUpdateFuture = original.GalleryImagesCreateOrUpdateFuture
type GalleryImagesDeleteFuture = original.GalleryImagesDeleteFuture
type GalleryImagesUpdateFuture = original.GalleryImagesUpdateFuture
type GalleryList = original.GalleryList
type GalleryListIterator = original.GalleryListIterator
type GalleryListPage = original.GalleryListPage
type GalleryOSDiskImage = original.GalleryOSDiskImage
type GalleryProperties = original.GalleryProperties
type GalleryUpdate = original.GalleryUpdate
type GrantAccessData = original.GrantAccessData
type HardwareProfile = original.HardwareProfile
type Image = original.Image
type ImageDataDisk = original.ImageDataDisk
type ImageDisk = original.ImageDisk
type ImageDiskReference = original.ImageDiskReference
type ImageListResult = original.ImageListResult
type ImageListResultIterator = original.ImageListResultIterator
type ImageListResultPage = original.ImageListResultPage
type ImageOSDisk = original.ImageOSDisk
type ImageProperties = original.ImageProperties
type ImagePurchasePlan = original.ImagePurchasePlan
type ImageReference = original.ImageReference
type ImageStorageProfile = original.ImageStorageProfile
type ImageUpdate = original.ImageUpdate
type ImagesClient = original.ImagesClient
type ImagesCreateOrUpdateFuture = original.ImagesCreateOrUpdateFuture
type ImagesDeleteFuture = original.ImagesDeleteFuture
type ImagesUpdateFuture = original.ImagesUpdateFuture
type InnerError = original.InnerError
type InstanceViewStatus = original.InstanceViewStatus
type KeyVaultAndKeyReference = original.KeyVaultAndKeyReference
type KeyVaultAndSecretReference = original.KeyVaultAndSecretReference
type KeyVaultKeyReference = original.KeyVaultKeyReference
type KeyVaultSecretReference = original.KeyVaultSecretReference
type LinuxConfiguration = original.LinuxConfiguration
type ListUsagesResult = original.ListUsagesResult
type ListUsagesResultIterator = original.ListUsagesResultIterator
type ListUsagesResultPage = original.ListUsagesResultPage
type ListVirtualMachineExtensionImage = original.ListVirtualMachineExtensionImage
type ListVirtualMachineImageResource = original.ListVirtualMachineImageResource
type LogAnalyticsClient = original.LogAnalyticsClient
type LogAnalyticsExportRequestRateByIntervalFuture = original.LogAnalyticsExportRequestRateByIntervalFuture
type LogAnalyticsExportThrottledRequestsFuture = original.LogAnalyticsExportThrottledRequestsFuture
type LogAnalyticsInputBase = original.LogAnalyticsInputBase
type LogAnalyticsOperationResult = original.LogAnalyticsOperationResult
type LogAnalyticsOutput = original.LogAnalyticsOutput
type MaintenanceRedeployStatus = original.MaintenanceRedeployStatus
type ManagedArtifact = original.ManagedArtifact
type ManagedDiskParameters = original.ManagedDiskParameters
type NetworkInterfaceReference = original.NetworkInterfaceReference
type NetworkInterfaceReferenceProperties = original.NetworkInterfaceReferenceProperties
type NetworkProfile = original.NetworkProfile
type OSDisk = original.OSDisk
type OSDiskImage = original.OSDiskImage
type OSDiskImageEncryption = original.OSDiskImageEncryption
type OSProfile = original.OSProfile
type OperationListResult = original.OperationListResult
type OperationValue = original.OperationValue
type OperationValueDisplay = original.OperationValueDisplay
type OperationsClient = original.OperationsClient
type Plan = original.Plan
type ProximityPlacementGroup = original.ProximityPlacementGroup
type ProximityPlacementGroupListResult = original.ProximityPlacementGroupListResult
type ProximityPlacementGroupListResultIterator = original.ProximityPlacementGroupListResultIterator
type ProximityPlacementGroupListResultPage = original.ProximityPlacementGroupListResultPage
type ProximityPlacementGroupProperties = original.ProximityPlacementGroupProperties
type ProximityPlacementGroupUpdate = original.ProximityPlacementGroupUpdate
type ProximityPlacementGroupsClient = original.ProximityPlacementGroupsClient
type PurchasePlan = original.PurchasePlan
type RecommendedMachineConfiguration = original.RecommendedMachineConfiguration
type RecoveryWalkResponse = original.RecoveryWalkResponse
type RegionalReplicationStatus = original.RegionalReplicationStatus
type ReplicationStatus = original.ReplicationStatus
type RequestRateByIntervalInput = original.RequestRateByIntervalInput
type Resource = original.Resource
type ResourceRange = original.ResourceRange
type ResourceSku = original.ResourceSku
type ResourceSkuCapabilities = original.ResourceSkuCapabilities
type ResourceSkuCapacity = original.ResourceSkuCapacity
type ResourceSkuCosts = original.ResourceSkuCosts
type ResourceSkuLocationInfo = original.ResourceSkuLocationInfo
type ResourceSkuRestrictionInfo = original.ResourceSkuRestrictionInfo
type ResourceSkuRestrictions = original.ResourceSkuRestrictions
type ResourceSkuZoneDetails = original.ResourceSkuZoneDetails
type ResourceSkusClient = original.ResourceSkusClient
type ResourceSkusResult = original.ResourceSkusResult
type ResourceSkusResultIterator = original.ResourceSkusResultIterator
type ResourceSkusResultPage = original.ResourceSkusResultPage
type RollbackStatusInfo = original.RollbackStatusInfo
type RollingUpgradePolicy = original.RollingUpgradePolicy
type RollingUpgradeProgressInfo = original.RollingUpgradeProgressInfo
type RollingUpgradeRunningStatus = original.RollingUpgradeRunningStatus
type RollingUpgradeStatusInfo = original.RollingUpgradeStatusInfo
type RollingUpgradeStatusInfoProperties = original.RollingUpgradeStatusInfoProperties
type RunCommandDocument = original.RunCommandDocument
type RunCommandDocumentBase = original.RunCommandDocumentBase
type RunCommandInput = original.RunCommandInput
type RunCommandInputParameter = original.RunCommandInputParameter
type RunCommandListResult = original.RunCommandListResult
type RunCommandListResultIterator = original.RunCommandListResultIterator
type RunCommandListResultPage = original.RunCommandListResultPage
type RunCommandParameterDefinition = original.RunCommandParameterDefinition
type RunCommandResult = original.RunCommandResult
type SSHConfiguration = original.SSHConfiguration
type SSHPublicKey = original.SSHPublicKey
type ScaleInPolicy = original.ScaleInPolicy
type ScheduledEventsProfile = original.ScheduledEventsProfile
type ShareInfoElement = original.ShareInfoElement
type Sku = original.Sku
type Snapshot = original.Snapshot
type SnapshotList = original.SnapshotList
type SnapshotListIterator = original.SnapshotListIterator
type SnapshotListPage = original.SnapshotListPage
type SnapshotProperties = original.SnapshotProperties
type SnapshotSku = original.SnapshotSku
type SnapshotUpdate = original.SnapshotUpdate
type SnapshotUpdateProperties = original.SnapshotUpdateProperties
type SnapshotsClient = original.SnapshotsClient
type SnapshotsCreateOrUpdateFuture = original.SnapshotsCreateOrUpdateFuture
type SnapshotsDeleteFuture = original.SnapshotsDeleteFuture
type SnapshotsGrantAccessFuture = original.SnapshotsGrantAccessFuture
type SnapshotsRevokeAccessFuture = original.SnapshotsRevokeAccessFuture
type SnapshotsUpdateFuture = original.SnapshotsUpdateFuture
type SourceVault = original.SourceVault
type StorageProfile = original.StorageProfile
type SubResource = original.SubResource
type SubResourceReadOnly = original.SubResourceReadOnly
type SubResourceWithColocationStatus = original.SubResourceWithColocationStatus
type TargetRegion = original.TargetRegion
type TerminateNotificationProfile = original.TerminateNotificationProfile
type ThrottledRequestsInput = original.ThrottledRequestsInput
type UpdateResource = original.UpdateResource
type UpdateResourceDefinition = original.UpdateResourceDefinition
type UpgradeOperationHistoricalStatusInfo = original.UpgradeOperationHistoricalStatusInfo
type UpgradeOperationHistoricalStatusInfoProperties = original.UpgradeOperationHistoricalStatusInfoProperties
type UpgradeOperationHistoryStatus = original.UpgradeOperationHistoryStatus
type UpgradePolicy = original.UpgradePolicy
type Usage = original.Usage
type UsageClient = original.UsageClient
type UsageName = original.UsageName
type UserArtifactSource = original.UserArtifactSource
type VMScaleSetConvertToSinglePlacementGroupInput = original.VMScaleSetConvertToSinglePlacementGroupInput
type VaultCertificate = original.VaultCertificate
type VaultSecretGroup = original.VaultSecretGroup
type VirtualHardDisk = original.VirtualHardDisk
type VirtualMachine = original.VirtualMachine
type VirtualMachineAgentInstanceView = original.VirtualMachineAgentInstanceView
type VirtualMachineCaptureParameters = original.VirtualMachineCaptureParameters
type VirtualMachineCaptureResult = original.VirtualMachineCaptureResult
type VirtualMachineExtension = original.VirtualMachineExtension
type VirtualMachineExtensionHandlerInstanceView = original.VirtualMachineExtensionHandlerInstanceView
type VirtualMachineExtensionImage = original.VirtualMachineExtensionImage
type VirtualMachineExtensionImageProperties = original.VirtualMachineExtensionImageProperties
type VirtualMachineExtensionImagesClient = original.VirtualMachineExtensionImagesClient
type VirtualMachineExtensionInstanceView = original.VirtualMachineExtensionInstanceView
type VirtualMachineExtensionProperties = original.VirtualMachineExtensionProperties
type VirtualMachineExtensionUpdate = original.VirtualMachineExtensionUpdate
type VirtualMachineExtensionUpdateProperties = original.VirtualMachineExtensionUpdateProperties
type VirtualMachineExtensionsClient = original.VirtualMachineExtensionsClient
type VirtualMachineExtensionsCreateOrUpdateFuture = original.VirtualMachineExtensionsCreateOrUpdateFuture
type VirtualMachineExtensionsDeleteFuture = original.VirtualMachineExtensionsDeleteFuture
type VirtualMachineExtensionsListResult = original.VirtualMachineExtensionsListResult
type VirtualMachineExtensionsUpdateFuture = original.VirtualMachineExtensionsUpdateFuture
type VirtualMachineHealthStatus = original.VirtualMachineHealthStatus
type VirtualMachineIdentity = original.VirtualMachineIdentity
type VirtualMachineIdentityUserAssignedIdentitiesValue = original.VirtualMachineIdentityUserAssignedIdentitiesValue
type VirtualMachineImage = original.VirtualMachineImage
type VirtualMachineImageProperties = original.VirtualMachineImageProperties
type VirtualMachineImageResource = original.VirtualMachineImageResource
type VirtualMachineImagesClient = original.VirtualMachineImagesClient
type VirtualMachineInstanceView = original.VirtualMachineInstanceView
type VirtualMachineListResult = original.VirtualMachineListResult
type VirtualMachineListResultIterator = original.VirtualMachineListResultIterator
type VirtualMachineListResultPage = original.VirtualMachineListResultPage
type VirtualMachineProperties = original.VirtualMachineProperties
type VirtualMachineReimageParameters = original.VirtualMachineReimageParameters
type VirtualMachineRunCommandsClient = original.VirtualMachineRunCommandsClient
type VirtualMachineScaleSet = original.VirtualMachineScaleSet
type VirtualMachineScaleSetDataDisk = original.VirtualMachineScaleSetDataDisk
type VirtualMachineScaleSetExtension = original.VirtualMachineScaleSetExtension
type VirtualMachineScaleSetExtensionListResult = original.VirtualMachineScaleSetExtensionListResult
type VirtualMachineScaleSetExtensionListResultIterator = original.VirtualMachineScaleSetExtensionListResultIterator
type VirtualMachineScaleSetExtensionListResultPage = original.VirtualMachineScaleSetExtensionListResultPage
type VirtualMachineScaleSetExtensionProfile = original.VirtualMachineScaleSetExtensionProfile
type VirtualMachineScaleSetExtensionProperties = original.VirtualMachineScaleSetExtensionProperties
type VirtualMachineScaleSetExtensionUpdate = original.VirtualMachineScaleSetExtensionUpdate
type VirtualMachineScaleSetExtensionsClient = original.VirtualMachineScaleSetExtensionsClient
type VirtualMachineScaleSetExtensionsCreateOrUpdateFuture = original.VirtualMachineScaleSetExtensionsCreateOrUpdateFuture
type VirtualMachineScaleSetExtensionsDeleteFuture = original.VirtualMachineScaleSetExtensionsDeleteFuture
type VirtualMachineScaleSetExtensionsUpdateFuture = original.VirtualMachineScaleSetExtensionsUpdateFuture
type VirtualMachineScaleSetIPConfiguration = original.VirtualMachineScaleSetIPConfiguration
type VirtualMachineScaleSetIPConfigurationProperties = original.VirtualMachineScaleSetIPConfigurationProperties
type VirtualMachineScaleSetIPTag = original.VirtualMachineScaleSetIPTag
type VirtualMachineScaleSetIdentity = original.VirtualMachineScaleSetIdentity
type VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue = original.VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue
type VirtualMachineScaleSetInstanceView = original.VirtualMachineScaleSetInstanceView
type VirtualMachineScaleSetInstanceViewStatusesSummary = original.VirtualMachineScaleSetInstanceViewStatusesSummary
type VirtualMachineScaleSetListOSUpgradeHistory = original.VirtualMachineScaleSetListOSUpgradeHistory
type VirtualMachineScaleSetListOSUpgradeHistoryIterator = original.VirtualMachineScaleSetListOSUpgradeHistoryIterator
type VirtualMachineScaleSetListOSUpgradeHistoryPage = original.VirtualMachineScaleSetListOSUpgradeHistoryPage
type VirtualMachineScaleSetListResult = original.VirtualMachineScaleSetListResult
type VirtualMachineScaleSetListResultIterator = original.VirtualMachineScaleSetListResultIterator
type VirtualMachineScaleSetListResultPage = original.VirtualMachineScaleSetListResultPage
type VirtualMachineScaleSetListSkusResult = original.VirtualMachineScaleSetListSkusResult
type VirtualMachineScaleSetListSkusResultIterator = original.VirtualMachineScaleSetListSkusResultIterator
type VirtualMachineScaleSetListSkusResultPage = original.VirtualMachineScaleSetListSkusResultPage
type VirtualMachineScaleSetListWithLinkResult = original.VirtualMachineScaleSetListWithLinkResult
type VirtualMachineScaleSetListWithLinkResultIterator = original.VirtualMachineScaleSetListWithLinkResultIterator
type VirtualMachineScaleSetListWithLinkResultPage = original.VirtualMachineScaleSetListWithLinkResultPage
type VirtualMachineScaleSetManagedDiskParameters = original.VirtualMachineScaleSetManagedDiskParameters
type VirtualMachineScaleSetNetworkConfiguration = original.VirtualMachineScaleSetNetworkConfiguration
type VirtualMachineScaleSetNetworkConfigurationDNSSettings = original.VirtualMachineScaleSetNetworkConfigurationDNSSettings
type VirtualMachineScaleSetNetworkConfigurationProperties = original.VirtualMachineScaleSetNetworkConfigurationProperties
type VirtualMachineScaleSetNetworkProfile = original.VirtualMachineScaleSetNetworkProfile
type VirtualMachineScaleSetOSDisk = original.VirtualMachineScaleSetOSDisk
type VirtualMachineScaleSetOSProfile = original.VirtualMachineScaleSetOSProfile
type VirtualMachineScaleSetProperties = original.VirtualMachineScaleSetProperties
type VirtualMachineScaleSetPublicIPAddressConfiguration = original.VirtualMachineScaleSetPublicIPAddressConfiguration
type VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings = original.VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings
type VirtualMachineScaleSetPublicIPAddressConfigurationProperties = original.VirtualMachineScaleSetPublicIPAddressConfigurationProperties
type VirtualMachineScaleSetReimageParameters = original.VirtualMachineScaleSetReimageParameters
type VirtualMachineScaleSetRollingUpgradesCancelFuture = original.VirtualMachineScaleSetRollingUpgradesCancelFuture
type VirtualMachineScaleSetRollingUpgradesClient = original.VirtualMachineScaleSetRollingUpgradesClient
type VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture = original.VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture
type VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture = original.VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture
type VirtualMachineScaleSetSku = original.VirtualMachineScaleSetSku
type VirtualMachineScaleSetSkuCapacity = original.VirtualMachineScaleSetSkuCapacity
type VirtualMachineScaleSetStorageProfile = original.VirtualMachineScaleSetStorageProfile
type VirtualMachineScaleSetUpdate = original.VirtualMachineScaleSetUpdate
type VirtualMachineScaleSetUpdateIPConfiguration = original.VirtualMachineScaleSetUpdateIPConfiguration
type VirtualMachineScaleSetUpdateIPConfigurationProperties = original.VirtualMachineScaleSetUpdateIPConfigurationProperties
type VirtualMachineScaleSetUpdateNetworkConfiguration = original.VirtualMachineScaleSetUpdateNetworkConfiguration
type VirtualMachineScaleSetUpdateNetworkConfigurationProperties = original.VirtualMachineScaleSetUpdateNetworkConfigurationProperties
type VirtualMachineScaleSetUpdateNetworkProfile = original.VirtualMachineScaleSetUpdateNetworkProfile
type VirtualMachineScaleSetUpdateOSDisk = original.VirtualMachineScaleSetUpdateOSDisk
type VirtualMachineScaleSetUpdateOSProfile = original.VirtualMachineScaleSetUpdateOSProfile
type VirtualMachineScaleSetUpdateProperties = original.VirtualMachineScaleSetUpdateProperties
type VirtualMachineScaleSetUpdatePublicIPAddressConfiguration = original.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration
type VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties = original.VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties
type VirtualMachineScaleSetUpdateStorageProfile = original.VirtualMachineScaleSetUpdateStorageProfile
type VirtualMachineScaleSetUpdateVMProfile = original.VirtualMachineScaleSetUpdateVMProfile
type VirtualMachineScaleSetVM = original.VirtualMachineScaleSetVM
type VirtualMachineScaleSetVMExtensionsClient = original.VirtualMachineScaleSetVMExtensionsClient
type VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture = original.VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture
type VirtualMachineScaleSetVMExtensionsDeleteFuture = original.VirtualMachineScaleSetVMExtensionsDeleteFuture
type VirtualMachineScaleSetVMExtensionsSummary = original.VirtualMachineScaleSetVMExtensionsSummary
type VirtualMachineScaleSetVMExtensionsUpdateFuture = original.VirtualMachineScaleSetVMExtensionsUpdateFuture
type VirtualMachineScaleSetVMInstanceIDs = original.VirtualMachineScaleSetVMInstanceIDs
type VirtualMachineScaleSetVMInstanceRequiredIDs = original.VirtualMachineScaleSetVMInstanceRequiredIDs
type VirtualMachineScaleSetVMInstanceView = original.VirtualMachineScaleSetVMInstanceView
type VirtualMachineScaleSetVMListResult = original.VirtualMachineScaleSetVMListResult
type VirtualMachineScaleSetVMListResultIterator = original.VirtualMachineScaleSetVMListResultIterator
type VirtualMachineScaleSetVMListResultPage = original.VirtualMachineScaleSetVMListResultPage
type VirtualMachineScaleSetVMNetworkProfileConfiguration = original.VirtualMachineScaleSetVMNetworkProfileConfiguration
type VirtualMachineScaleSetVMProfile = original.VirtualMachineScaleSetVMProfile
type VirtualMachineScaleSetVMProperties = original.VirtualMachineScaleSetVMProperties
type VirtualMachineScaleSetVMProtectionPolicy = original.VirtualMachineScaleSetVMProtectionPolicy
type VirtualMachineScaleSetVMReimageParameters = original.VirtualMachineScaleSetVMReimageParameters
type VirtualMachineScaleSetVMsClient = original.VirtualMachineScaleSetVMsClient
type VirtualMachineScaleSetVMsDeallocateFuture = original.VirtualMachineScaleSetVMsDeallocateFuture
type VirtualMachineScaleSetVMsDeleteFuture = original.VirtualMachineScaleSetVMsDeleteFuture
type VirtualMachineScaleSetVMsPerformMaintenanceFuture = original.VirtualMachineScaleSetVMsPerformMaintenanceFuture
type VirtualMachineScaleSetVMsPowerOffFuture = original.VirtualMachineScaleSetVMsPowerOffFuture
type VirtualMachineScaleSetVMsRedeployFuture = original.VirtualMachineScaleSetVMsRedeployFuture
type VirtualMachineScaleSetVMsReimageAllFuture = original.VirtualMachineScaleSetVMsReimageAllFuture
type VirtualMachineScaleSetVMsReimageFuture = original.VirtualMachineScaleSetVMsReimageFuture
type VirtualMachineScaleSetVMsRestartFuture = original.VirtualMachineScaleSetVMsRestartFuture
type VirtualMachineScaleSetVMsRunCommandFuture = original.VirtualMachineScaleSetVMsRunCommandFuture
type VirtualMachineScaleSetVMsStartFuture = original.VirtualMachineScaleSetVMsStartFuture
type VirtualMachineScaleSetVMsUpdateFuture = original.VirtualMachineScaleSetVMsUpdateFuture
type VirtualMachineScaleSetsClient = original.VirtualMachineScaleSetsClient
type VirtualMachineScaleSetsCreateOrUpdateFuture = original.VirtualMachineScaleSetsCreateOrUpdateFuture
type VirtualMachineScaleSetsDeallocateFuture = original.VirtualMachineScaleSetsDeallocateFuture
type VirtualMachineScaleSetsDeleteFuture = original.VirtualMachineScaleSetsDeleteFuture
type VirtualMachineScaleSetsDeleteInstancesFuture = original.VirtualMachineScaleSetsDeleteInstancesFuture
type VirtualMachineScaleSetsPerformMaintenanceFuture = original.VirtualMachineScaleSetsPerformMaintenanceFuture
type VirtualMachineScaleSetsPowerOffFuture = original.VirtualMachineScaleSetsPowerOffFuture
type VirtualMachineScaleSetsRedeployFuture = original.VirtualMachineScaleSetsRedeployFuture
type VirtualMachineScaleSetsReimageAllFuture = original.VirtualMachineScaleSetsReimageAllFuture
type VirtualMachineScaleSetsReimageFuture = original.VirtualMachineScaleSetsReimageFuture
type VirtualMachineScaleSetsRestartFuture = original.VirtualMachineScaleSetsRestartFuture
type VirtualMachineScaleSetsStartFuture = original.VirtualMachineScaleSetsStartFuture
type VirtualMachineScaleSetsUpdateFuture = original.VirtualMachineScaleSetsUpdateFuture
type VirtualMachineScaleSetsUpdateInstancesFuture = original.VirtualMachineScaleSetsUpdateInstancesFuture
type VirtualMachineSize = original.VirtualMachineSize
type VirtualMachineSizeListResult = original.VirtualMachineSizeListResult
type VirtualMachineSizesClient = original.VirtualMachineSizesClient
type VirtualMachineStatusCodeCount = original.VirtualMachineStatusCodeCount
type VirtualMachineUpdate = original.VirtualMachineUpdate
type VirtualMachinesCaptureFuture = original.VirtualMachinesCaptureFuture
type VirtualMachinesClient = original.VirtualMachinesClient
type VirtualMachinesConvertToManagedDisksFuture = original.VirtualMachinesConvertToManagedDisksFuture
type VirtualMachinesCreateOrUpdateFuture = original.VirtualMachinesCreateOrUpdateFuture
type VirtualMachinesDeallocateFuture = original.VirtualMachinesDeallocateFuture
type VirtualMachinesDeleteFuture = original.VirtualMachinesDeleteFuture
type VirtualMachinesPerformMaintenanceFuture = original.VirtualMachinesPerformMaintenanceFuture
type VirtualMachinesPowerOffFuture = original.VirtualMachinesPowerOffFuture
type VirtualMachinesReapplyFuture = original.VirtualMachinesReapplyFuture
type VirtualMachinesRedeployFuture = original.VirtualMachinesRedeployFuture
type VirtualMachinesReimageFuture = original.VirtualMachinesReimageFuture
type VirtualMachinesRestartFuture = original.VirtualMachinesRestartFuture
type VirtualMachinesRunCommandFuture = original.VirtualMachinesRunCommandFuture
type VirtualMachinesStartFuture = original.VirtualMachinesStartFuture
type VirtualMachinesUpdateFuture = original.VirtualMachinesUpdateFuture
type WinRMConfiguration = original.WinRMConfiguration
type WinRMListener = original.WinRMListener
type WindowsConfiguration = original.WindowsConfiguration

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAvailabilitySetListResultIterator(page AvailabilitySetListResultPage) AvailabilitySetListResultIterator {
	return original.NewAvailabilitySetListResultIterator(page)
}
func NewAvailabilitySetListResultPage(getNextPage func(context.Context, AvailabilitySetListResult) (AvailabilitySetListResult, error)) AvailabilitySetListResultPage {
	return original.NewAvailabilitySetListResultPage(getNextPage)
}
func NewAvailabilitySetsClient(subscriptionID string) AvailabilitySetsClient {
	return original.NewAvailabilitySetsClient(subscriptionID)
}
func NewAvailabilitySetsClientWithBaseURI(baseURI string, subscriptionID string) AvailabilitySetsClient {
	return original.NewAvailabilitySetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewContainerServiceListResultIterator(page ContainerServiceListResultPage) ContainerServiceListResultIterator {
	return original.NewContainerServiceListResultIterator(page)
}
func NewContainerServiceListResultPage(getNextPage func(context.Context, ContainerServiceListResult) (ContainerServiceListResult, error)) ContainerServiceListResultPage {
	return original.NewContainerServiceListResultPage(getNextPage)
}
func NewContainerServicesClient(subscriptionID string) ContainerServicesClient {
	return original.NewContainerServicesClient(subscriptionID)
}
func NewContainerServicesClientWithBaseURI(baseURI string, subscriptionID string) ContainerServicesClient {
	return original.NewContainerServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDedicatedHostGroupListResultIterator(page DedicatedHostGroupListResultPage) DedicatedHostGroupListResultIterator {
	return original.NewDedicatedHostGroupListResultIterator(page)
}
func NewDedicatedHostGroupListResultPage(getNextPage func(context.Context, DedicatedHostGroupListResult) (DedicatedHostGroupListResult, error)) DedicatedHostGroupListResultPage {
	return original.NewDedicatedHostGroupListResultPage(getNextPage)
}
func NewDedicatedHostGroupsClient(subscriptionID string) DedicatedHostGroupsClient {
	return original.NewDedicatedHostGroupsClient(subscriptionID)
}
func NewDedicatedHostGroupsClientWithBaseURI(baseURI string, subscriptionID string) DedicatedHostGroupsClient {
	return original.NewDedicatedHostGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDedicatedHostListResultIterator(page DedicatedHostListResultPage) DedicatedHostListResultIterator {
	return original.NewDedicatedHostListResultIterator(page)
}
func NewDedicatedHostListResultPage(getNextPage func(context.Context, DedicatedHostListResult) (DedicatedHostListResult, error)) DedicatedHostListResultPage {
	return original.NewDedicatedHostListResultPage(getNextPage)
}
func NewDedicatedHostsClient(subscriptionID string) DedicatedHostsClient {
	return original.NewDedicatedHostsClient(subscriptionID)
}
func NewDedicatedHostsClientWithBaseURI(baseURI string, subscriptionID string) DedicatedHostsClient {
	return original.NewDedicatedHostsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDiskEncryptionSetListIterator(page DiskEncryptionSetListPage) DiskEncryptionSetListIterator {
	return original.NewDiskEncryptionSetListIterator(page)
}
func NewDiskEncryptionSetListPage(getNextPage func(context.Context, DiskEncryptionSetList) (DiskEncryptionSetList, error)) DiskEncryptionSetListPage {
	return original.NewDiskEncryptionSetListPage(getNextPage)
}
func NewDiskEncryptionSetsClient(subscriptionID string) DiskEncryptionSetsClient {
	return original.NewDiskEncryptionSetsClient(subscriptionID)
}
func NewDiskEncryptionSetsClientWithBaseURI(baseURI string, subscriptionID string) DiskEncryptionSetsClient {
	return original.NewDiskEncryptionSetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDiskListIterator(page DiskListPage) DiskListIterator {
	return original.NewDiskListIterator(page)
}
func NewDiskListPage(getNextPage func(context.Context, DiskList) (DiskList, error)) DiskListPage {
	return original.NewDiskListPage(getNextPage)
}
func NewDisksClient(subscriptionID string) DisksClient {
	return original.NewDisksClient(subscriptionID)
}
func NewDisksClientWithBaseURI(baseURI string, subscriptionID string) DisksClient {
	return original.NewDisksClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleriesClient(subscriptionID string) GalleriesClient {
	return original.NewGalleriesClient(subscriptionID)
}
func NewGalleriesClientWithBaseURI(baseURI string, subscriptionID string) GalleriesClient {
	return original.NewGalleriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleryApplicationListIterator(page GalleryApplicationListPage) GalleryApplicationListIterator {
	return original.NewGalleryApplicationListIterator(page)
}
func NewGalleryApplicationListPage(getNextPage func(context.Context, GalleryApplicationList) (GalleryApplicationList, error)) GalleryApplicationListPage {
	return original.NewGalleryApplicationListPage(getNextPage)
}
func NewGalleryApplicationVersionListIterator(page GalleryApplicationVersionListPage) GalleryApplicationVersionListIterator {
	return original.NewGalleryApplicationVersionListIterator(page)
}
func NewGalleryApplicationVersionListPage(getNextPage func(context.Context, GalleryApplicationVersionList) (GalleryApplicationVersionList, error)) GalleryApplicationVersionListPage {
	return original.NewGalleryApplicationVersionListPage(getNextPage)
}
func NewGalleryApplicationVersionsClient(subscriptionID string) GalleryApplicationVersionsClient {
	return original.NewGalleryApplicationVersionsClient(subscriptionID)
}
func NewGalleryApplicationVersionsClientWithBaseURI(baseURI string, subscriptionID string) GalleryApplicationVersionsClient {
	return original.NewGalleryApplicationVersionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleryApplicationsClient(subscriptionID string) GalleryApplicationsClient {
	return original.NewGalleryApplicationsClient(subscriptionID)
}
func NewGalleryApplicationsClientWithBaseURI(baseURI string, subscriptionID string) GalleryApplicationsClient {
	return original.NewGalleryApplicationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleryImageListIterator(page GalleryImageListPage) GalleryImageListIterator {
	return original.NewGalleryImageListIterator(page)
}
func NewGalleryImageListPage(getNextPage func(context.Context, GalleryImageList) (GalleryImageList, error)) GalleryImageListPage {
	return original.NewGalleryImageListPage(getNextPage)
}
func NewGalleryImageVersionListIterator(page GalleryImageVersionListPage) GalleryImageVersionListIterator {
	return original.NewGalleryImageVersionListIterator(page)
}
func NewGalleryImageVersionListPage(getNextPage func(context.Context, GalleryImageVersionList) (GalleryImageVersionList, error)) GalleryImageVersionListPage {
	return original.NewGalleryImageVersionListPage(getNextPage)
}
func NewGalleryImageVersionsClient(subscriptionID string) GalleryImageVersionsClient {
	return original.NewGalleryImageVersionsClient(subscriptionID)
}
func NewGalleryImageVersionsClientWithBaseURI(baseURI string, subscriptionID string) GalleryImageVersionsClient {
	return original.NewGalleryImageVersionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleryImagesClient(subscriptionID string) GalleryImagesClient {
	return original.NewGalleryImagesClient(subscriptionID)
}
func NewGalleryImagesClientWithBaseURI(baseURI string, subscriptionID string) GalleryImagesClient {
	return original.NewGalleryImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleryListIterator(page GalleryListPage) GalleryListIterator {
	return original.NewGalleryListIterator(page)
}
func NewGalleryListPage(getNextPage func(context.Context, GalleryList) (GalleryList, error)) GalleryListPage {
	return original.NewGalleryListPage(getNextPage)
}
func NewImageListResultIterator(page ImageListResultPage) ImageListResultIterator {
	return original.NewImageListResultIterator(page)
}
func NewImageListResultPage(getNextPage func(context.Context, ImageListResult) (ImageListResult, error)) ImageListResultPage {
	return original.NewImageListResultPage(getNextPage)
}
func NewImagesClient(subscriptionID string) ImagesClient {
	return original.NewImagesClient(subscriptionID)
}
func NewImagesClientWithBaseURI(baseURI string, subscriptionID string) ImagesClient {
	return original.NewImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewListUsagesResultIterator(page ListUsagesResultPage) ListUsagesResultIterator {
	return original.NewListUsagesResultIterator(page)
}
func NewListUsagesResultPage(getNextPage func(context.Context, ListUsagesResult) (ListUsagesResult, error)) ListUsagesResultPage {
	return original.NewListUsagesResultPage(getNextPage)
}
func NewLogAnalyticsClient(subscriptionID string) LogAnalyticsClient {
	return original.NewLogAnalyticsClient(subscriptionID)
}
func NewLogAnalyticsClientWithBaseURI(baseURI string, subscriptionID string) LogAnalyticsClient {
	return original.NewLogAnalyticsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewProximityPlacementGroupListResultIterator(page ProximityPlacementGroupListResultPage) ProximityPlacementGroupListResultIterator {
	return original.NewProximityPlacementGroupListResultIterator(page)
}
func NewProximityPlacementGroupListResultPage(getNextPage func(context.Context, ProximityPlacementGroupListResult) (ProximityPlacementGroupListResult, error)) ProximityPlacementGroupListResultPage {
	return original.NewProximityPlacementGroupListResultPage(getNextPage)
}
func NewProximityPlacementGroupsClient(subscriptionID string) ProximityPlacementGroupsClient {
	return original.NewProximityPlacementGroupsClient(subscriptionID)
}
func NewProximityPlacementGroupsClientWithBaseURI(baseURI string, subscriptionID string) ProximityPlacementGroupsClient {
	return original.NewProximityPlacementGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceSkusClient(subscriptionID string) ResourceSkusClient {
	return original.NewResourceSkusClient(subscriptionID)
}
func NewResourceSkusClientWithBaseURI(baseURI string, subscriptionID string) ResourceSkusClient {
	return original.NewResourceSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceSkusResultIterator(page ResourceSkusResultPage) ResourceSkusResultIterator {
	return original.NewResourceSkusResultIterator(page)
}
func NewResourceSkusResultPage(getNextPage func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)) ResourceSkusResultPage {
	return original.NewResourceSkusResultPage(getNextPage)
}
func NewRunCommandListResultIterator(page RunCommandListResultPage) RunCommandListResultIterator {
	return original.NewRunCommandListResultIterator(page)
}
func NewRunCommandListResultPage(getNextPage func(context.Context, RunCommandListResult) (RunCommandListResult, error)) RunCommandListResultPage {
	return original.NewRunCommandListResultPage(getNextPage)
}
func NewSnapshotListIterator(page SnapshotListPage) SnapshotListIterator {
	return original.NewSnapshotListIterator(page)
}
func NewSnapshotListPage(getNextPage func(context.Context, SnapshotList) (SnapshotList, error)) SnapshotListPage {
	return original.NewSnapshotListPage(getNextPage)
}
func NewSnapshotsClient(subscriptionID string) SnapshotsClient {
	return original.NewSnapshotsClient(subscriptionID)
}
func NewSnapshotsClientWithBaseURI(baseURI string, subscriptionID string) SnapshotsClient {
	return original.NewSnapshotsClientWithBaseURI(baseURI, subscriptionID)
}
func NewUsageClient(subscriptionID string) UsageClient {
	return original.NewUsageClient(subscriptionID)
}
func NewUsageClientWithBaseURI(baseURI string, subscriptionID string) UsageClient {
	return original.NewUsageClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineExtensionImagesClient(subscriptionID string) VirtualMachineExtensionImagesClient {
	return original.NewVirtualMachineExtensionImagesClient(subscriptionID)
}
func NewVirtualMachineExtensionImagesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineExtensionImagesClient {
	return original.NewVirtualMachineExtensionImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineExtensionsClient(subscriptionID string) VirtualMachineExtensionsClient {
	return original.NewVirtualMachineExtensionsClient(subscriptionID)
}
func NewVirtualMachineExtensionsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineExtensionsClient {
	return original.NewVirtualMachineExtensionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineImagesClient(subscriptionID string) VirtualMachineImagesClient {
	return original.NewVirtualMachineImagesClient(subscriptionID)
}
func NewVirtualMachineImagesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineImagesClient {
	return original.NewVirtualMachineImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineListResultIterator(page VirtualMachineListResultPage) VirtualMachineListResultIterator {
	return original.NewVirtualMachineListResultIterator(page)
}
func NewVirtualMachineListResultPage(getNextPage func(context.Context, VirtualMachineListResult) (VirtualMachineListResult, error)) VirtualMachineListResultPage {
	return original.NewVirtualMachineListResultPage(getNextPage)
}
func NewVirtualMachineRunCommandsClient(subscriptionID string) VirtualMachineRunCommandsClient {
	return original.NewVirtualMachineRunCommandsClient(subscriptionID)
}
func NewVirtualMachineRunCommandsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineRunCommandsClient {
	return original.NewVirtualMachineRunCommandsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineScaleSetExtensionListResultIterator(page VirtualMachineScaleSetExtensionListResultPage) VirtualMachineScaleSetExtensionListResultIterator {
	return original.NewVirtualMachineScaleSetExtensionListResultIterator(page)
}
func NewVirtualMachineScaleSetExtensionListResultPage(getNextPage func(context.Context, VirtualMachineScaleSetExtensionListResult) (VirtualMachineScaleSetExtensionListResult, error)) VirtualMachineScaleSetExtensionListResultPage {
	return original.NewVirtualMachineScaleSetExtensionListResultPage(getNextPage)
}
func NewVirtualMachineScaleSetExtensionsClient(subscriptionID string) VirtualMachineScaleSetExtensionsClient {
	return original.NewVirtualMachineScaleSetExtensionsClient(subscriptionID)
}
func NewVirtualMachineScaleSetExtensionsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineScaleSetExtensionsClient {
	return original.NewVirtualMachineScaleSetExtensionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineScaleSetListOSUpgradeHistoryIterator(page VirtualMachineScaleSetListOSUpgradeHistoryPage) VirtualMachineScaleSetListOSUpgradeHistoryIterator {
	return original.NewVirtualMachineScaleSetListOSUpgradeHistoryIterator(page)
}
func NewVirtualMachineScaleSetListOSUpgradeHistoryPage(getNextPage func(context.Context, VirtualMachineScaleSetListOSUpgradeHistory) (VirtualMachineScaleSetListOSUpgradeHistory, error)) VirtualMachineScaleSetListOSUpgradeHistoryPage {
	return original.NewVirtualMachineScaleSetListOSUpgradeHistoryPage(getNextPage)
}
func NewVirtualMachineScaleSetListResultIterator(page VirtualMachineScaleSetListResultPage) VirtualMachineScaleSetListResultIterator {
	return original.NewVirtualMachineScaleSetListResultIterator(page)
}
func NewVirtualMachineScaleSetListResultPage(getNextPage func(context.Context, VirtualMachineScaleSetListResult) (VirtualMachineScaleSetListResult, error)) VirtualMachineScaleSetListResultPage {
	return original.NewVirtualMachineScaleSetListResultPage(getNextPage)
}
func NewVirtualMachineScaleSetListSkusResultIterator(page VirtualMachineScaleSetListSkusResultPage) VirtualMachineScaleSetListSkusResultIterator {
	return original.NewVirtualMachineScaleSetListSkusResultIterator(page)
}
func NewVirtualMachineScaleSetListSkusResultPage(getNextPage func(context.Context, VirtualMachineScaleSetListSkusResult) (VirtualMachineScaleSetListSkusResult, error)) VirtualMachineScaleSetListSkusResultPage {
	return original.NewVirtualMachineScaleSetListSkusResultPage(getNextPage)
}
func NewVirtualMachineScaleSetListWithLinkResultIterator(page VirtualMachineScaleSetListWithLinkResultPage) VirtualMachineScaleSetListWithLinkResultIterator {
	return original.NewVirtualMachineScaleSetListWithLinkResultIterator(page)
}
func NewVirtualMachineScaleSetListWithLinkResultPage(getNextPage func(context.Context, VirtualMachineScaleSetListWithLinkResult) (VirtualMachineScaleSetListWithLinkResult, error)) VirtualMachineScaleSetListWithLinkResultPage {
	return original.NewVirtualMachineScaleSetListWithLinkResultPage(getNextPage)
}
func NewVirtualMachineScaleSetRollingUpgradesClient(subscriptionID string) VirtualMachineScaleSetRollingUpgradesClient {
	return original.NewVirtualMachineScaleSetRollingUpgradesClient(subscriptionID)
}
func NewVirtualMachineScaleSetRollingUpgradesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineScaleSetRollingUpgradesClient {
	return original.NewVirtualMachineScaleSetRollingUpgradesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineScaleSetVMExtensionsClient(subscriptionID string) VirtualMachineScaleSetVMExtensionsClient {
	return original.NewVirtualMachineScaleSetVMExtensionsClient(subscriptionID)
}
func NewVirtualMachineScaleSetVMExtensionsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineScaleSetVMExtensionsClient {
	return original.NewVirtualMachineScaleSetVMExtensionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineScaleSetVMListResultIterator(page VirtualMachineScaleSetVMListResultPage) VirtualMachineScaleSetVMListResultIterator {
	return original.NewVirtualMachineScaleSetVMListResultIterator(page)
}
func NewVirtualMachineScaleSetVMListResultPage(getNextPage func(context.Context, VirtualMachineScaleSetVMListResult) (VirtualMachineScaleSetVMListResult, error)) VirtualMachineScaleSetVMListResultPage {
	return original.NewVirtualMachineScaleSetVMListResultPage(getNextPage)
}
func NewVirtualMachineScaleSetVMsClient(subscriptionID string) VirtualMachineScaleSetVMsClient {
	return original.NewVirtualMachineScaleSetVMsClient(subscriptionID)
}
func NewVirtualMachineScaleSetVMsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineScaleSetVMsClient {
	return original.NewVirtualMachineScaleSetVMsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineScaleSetsClient(subscriptionID string) VirtualMachineScaleSetsClient {
	return original.NewVirtualMachineScaleSetsClient(subscriptionID)
}
func NewVirtualMachineScaleSetsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineScaleSetsClient {
	return original.NewVirtualMachineScaleSetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineSizesClient(subscriptionID string) VirtualMachineSizesClient {
	return original.NewVirtualMachineSizesClient(subscriptionID)
}
func NewVirtualMachineSizesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineSizesClient {
	return original.NewVirtualMachineSizesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachinesClient(subscriptionID string) VirtualMachinesClient {
	return original.NewVirtualMachinesClient(subscriptionID)
}
func NewVirtualMachinesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachinesClient {
	return original.NewVirtualMachinesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccessLevelValues() []AccessLevel {
	return original.PossibleAccessLevelValues()
}
func PossibleAggregatedReplicationStateValues() []AggregatedReplicationState {
	return original.PossibleAggregatedReplicationStateValues()
}
func PossibleAvailabilitySetSkuTypesValues() []AvailabilitySetSkuTypes {
	return original.PossibleAvailabilitySetSkuTypesValues()
}
func PossibleCachingTypesValues() []CachingTypes {
	return original.PossibleCachingTypesValues()
}
func PossibleComponentNamesValues() []ComponentNames {
	return original.PossibleComponentNamesValues()
}
func PossibleContainerServiceOrchestratorTypesValues() []ContainerServiceOrchestratorTypes {
	return original.PossibleContainerServiceOrchestratorTypesValues()
}
func PossibleContainerServiceVMSizeTypesValues() []ContainerServiceVMSizeTypes {
	return original.PossibleContainerServiceVMSizeTypesValues()
}
func PossibleDedicatedHostLicenseTypesValues() []DedicatedHostLicenseTypes {
	return original.PossibleDedicatedHostLicenseTypesValues()
}
func PossibleDiffDiskOptionsValues() []DiffDiskOptions {
	return original.PossibleDiffDiskOptionsValues()
}
func PossibleDiskCreateOptionTypesValues() []DiskCreateOptionTypes {
	return original.PossibleDiskCreateOptionTypesValues()
}
func PossibleDiskCreateOptionValues() []DiskCreateOption {
	return original.PossibleDiskCreateOptionValues()
}
func PossibleDiskEncryptionSetIdentityTypeValues() []DiskEncryptionSetIdentityType {
	return original.PossibleDiskEncryptionSetIdentityTypeValues()
}
func PossibleDiskStateValues() []DiskState {
	return original.PossibleDiskStateValues()
}
func PossibleDiskStorageAccountTypesValues() []DiskStorageAccountTypes {
	return original.PossibleDiskStorageAccountTypesValues()
}
func PossibleEncryptionTypeValues() []EncryptionType {
	return original.PossibleEncryptionTypeValues()
}
func PossibleHostCachingValues() []HostCaching {
	return original.PossibleHostCachingValues()
}
func PossibleHyperVGenerationTypeValues() []HyperVGenerationType {
	return original.PossibleHyperVGenerationTypeValues()
}
func PossibleHyperVGenerationTypesValues() []HyperVGenerationTypes {
	return original.PossibleHyperVGenerationTypesValues()
}
func PossibleHyperVGenerationValues() []HyperVGeneration {
	return original.PossibleHyperVGenerationValues()
}
func PossibleIPVersionValues() []IPVersion {
	return original.PossibleIPVersionValues()
}
func PossibleInstanceViewTypesValues() []InstanceViewTypes {
	return original.PossibleInstanceViewTypesValues()
}
func PossibleIntervalInMinsValues() []IntervalInMins {
	return original.PossibleIntervalInMinsValues()
}
func PossibleMaintenanceOperationResultCodeTypesValues() []MaintenanceOperationResultCodeTypes {
	return original.PossibleMaintenanceOperationResultCodeTypesValues()
}
func PossibleOperatingSystemStateTypesValues() []OperatingSystemStateTypes {
	return original.PossibleOperatingSystemStateTypesValues()
}
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return original.PossibleOperatingSystemTypesValues()
}
func PossiblePassNamesValues() []PassNames {
	return original.PossiblePassNamesValues()
}
func PossibleProtocolTypesValues() []ProtocolTypes {
	return original.PossibleProtocolTypesValues()
}
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return original.PossibleProvisioningState1Values()
}
func PossibleProvisioningState2Values() []ProvisioningState2 {
	return original.PossibleProvisioningState2Values()
}
func PossibleProvisioningState3Values() []ProvisioningState3 {
	return original.PossibleProvisioningState3Values()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleProximityPlacementGroupTypeValues() []ProximityPlacementGroupType {
	return original.PossibleProximityPlacementGroupTypeValues()
}
func PossibleReplicationStateValues() []ReplicationState {
	return original.PossibleReplicationStateValues()
}
func PossibleReplicationStatusTypesValues() []ReplicationStatusTypes {
	return original.PossibleReplicationStatusTypesValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return original.PossibleResourceSkuCapacityScaleTypeValues()
}
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return original.PossibleResourceSkuRestrictionsReasonCodeValues()
}
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return original.PossibleResourceSkuRestrictionsTypeValues()
}
func PossibleRollingUpgradeActionTypeValues() []RollingUpgradeActionType {
	return original.PossibleRollingUpgradeActionTypeValues()
}
func PossibleRollingUpgradeStatusCodeValues() []RollingUpgradeStatusCode {
	return original.PossibleRollingUpgradeStatusCodeValues()
}
func PossibleSettingNamesValues() []SettingNames {
	return original.PossibleSettingNamesValues()
}
func PossibleSnapshotStorageAccountTypesValues() []SnapshotStorageAccountTypes {
	return original.PossibleSnapshotStorageAccountTypesValues()
}
func PossibleStatusLevelTypesValues() []StatusLevelTypes {
	return original.PossibleStatusLevelTypesValues()
}
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return original.PossibleStorageAccountTypeValues()
}
func PossibleStorageAccountTypesValues() []StorageAccountTypes {
	return original.PossibleStorageAccountTypesValues()
}
func PossibleUpgradeModeValues() []UpgradeMode {
	return original.PossibleUpgradeModeValues()
}
func PossibleUpgradeOperationInvokerValues() []UpgradeOperationInvoker {
	return original.PossibleUpgradeOperationInvokerValues()
}
func PossibleUpgradeStateValues() []UpgradeState {
	return original.PossibleUpgradeStateValues()
}
func PossibleVirtualMachineEvictionPolicyTypesValues() []VirtualMachineEvictionPolicyTypes {
	return original.PossibleVirtualMachineEvictionPolicyTypesValues()
}
func PossibleVirtualMachinePriorityTypesValues() []VirtualMachinePriorityTypes {
	return original.PossibleVirtualMachinePriorityTypesValues()
}
func PossibleVirtualMachineScaleSetScaleInRulesValues() []VirtualMachineScaleSetScaleInRules {
	return original.PossibleVirtualMachineScaleSetScaleInRulesValues()
}
func PossibleVirtualMachineScaleSetSkuScaleTypeValues() []VirtualMachineScaleSetSkuScaleType {
	return original.PossibleVirtualMachineScaleSetSkuScaleTypeValues()
}
func PossibleVirtualMachineSizeTypesValues() []VirtualMachineSizeTypes {
	return original.PossibleVirtualMachineSizeTypesValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
