package iptree16

// !!!DON'T EDIT!!! Generated by infobloxopen/go-trees/etc from <name>tree{{.bits}} with etc -s uint16 -d uintX.yaml -t ./<name>tree\{\{.bits\}\}

import (
	"fmt"
	"testing"

	"github.com/pmezard/go-difflib/difflib"
)

var (
	nTest   = new(node64)
	nBottom = new(node64)
	nTop    = new(node64)

	n10 = new(node64)
	n20 = new(node64)
	n21 = new(node64)
	n22 = new(node64)
	n30 = new(node64)
	n40 = new(node64)
	n50 = new(node64)
)

func TestInsert64s(t *testing.T) {
	var r *node64s

	r = r.Insert(0, 64, nTest)
	assertTree64s(r, TestTree64sWithSingleNodeInserted,
		"64-tree with single node inserted", t)

	r = nil
	r = r.Insert(0xAAAAAAAA00000000, 18, nBottom)
	r = r.Insert(0xAAAAAAAA00000000, 9, nTop)
	assertTree64s(r, TestTree64sWithTopAfterBottomToLeftNodesInserted,
		"64-tree with top after bottom to left nodes inserted", t)

	r = nil
	r = r.Insert(0xAAAAAAAA00000000, 18, nBottom)
	r = r.Insert(0xAAAAAAAA00000000, 10, nTop)
	assertTree64s(r, TestTree64sWithTopAfterBottomToRightNodesInserted,
		"64-tree with top after bottom to right nodes inserted", t)

	r = nil
	r = r.Insert(0xAAAAAAAA00000000, 18, nBottom)
	r = r.Insert(0xABAAAAAA00000000, 10, nTop)
	assertTree64s(r, TestTree64sWithTopAfterBottomAndAdditionalNotLeafNodesInserted,
		"64-tree with top after bottom and additional not leaf nodes inserted", t)

	r = nil
	r = r.Insert(0xAAAAAAAA00000000, 18, nBottom)
	oldR := r.Insert(0xABAAAAAA00000000, 10, nTop)
	newR := oldR.Insert(0xABAAAAAA00000000, 7, nTest)
	assertTree64s(oldR, TestTree64sWithOldTopReplacingTopAfterBottomNodesInserted,
		"64-tree with old top replacing top after bottom nodes inserted", t)
	assertTree64s(newR, TestTree64sWithNewTopReplacingTopAfterBottomNodesInserted,
		"64-tree with new top replacing top after bottom nodes inserted", t)

	r = nil
	r = r.Insert(0xAAAAAAAA00000000, 9, nTop)
	r = r.Insert(0xAAAAAAAA00000000, 18, nBottom)
	assertTree64s(r, TestTree64sWithTopBeforeBottomToLeftNodesInserted,
		"64-tree with top before bottom to left nodes inserted", t)

	r = nil
	r = r.Insert(0xAAAAAAAA00000000, 10, nTop)
	r = r.Insert(0xAAAAAAAA00000000, 18, nBottom)
	assertTree64s(r, TestTree64sWithTopBeforeBottomToRightNodesInserted,
		"64-tree with top before bottom to right nodes inserted", t)

	r = nil
	r = r.Insert(0xAAAAAAA00000000, 7, n10)
	r = r.Insert(0xABAAAAA00000000, 9, n20)
	r = r.Insert(0xAAAAAAA00000000, 18, n30)
	r = r.Insert(0xAABAAAA00000000, 19, n40)
	assertTree64s(r, TestTree64sWithTopBeforeBottomSeveralLevelNodesInserted,
		"64-tree with top before bottom several level nodes inserted", t)

	r = nil
	r = r.Insert(0, -10, nil)
	assertTree64s(r, TestTree64sWithNegativeNumberOfBits,
		"64-tree with negative number of significant bits", t)

	r = nil
	r = r.Insert(0, 65, nil)
	assertTree64s(r, TestTree64sWithTooBigNumberOfBits,
		"64-tree with too big number of significant bits", t)
}

func TestInplaceInsert64s(t *testing.T) {
	var r *node64s

	r = r.InplaceInsert(0, 64, nTest)
	assertTree64s(r, TestTree64sWithSingleNodeInserted,
		"64-tree with single node inplace inserted", t)

	r = nil
	r = r.InplaceInsert(0xAAAAAAAA00000000, 18, nBottom)
	r = r.InplaceInsert(0xAAAAAAAA00000000, 9, nTop)
	assertTree64s(r, TestTree64sWithTopAfterBottomToLeftNodesInserted,
		"64-tree with top after bottom to left nodes inplace inserted", t)

	r = nil
	r = r.InplaceInsert(0xAAAAAAAA00000000, 18, nBottom)
	r = r.InplaceInsert(0xAAAAAAAA00000000, 10, nTop)
	assertTree64s(r, TestTree64sWithTopAfterBottomToRightNodesInserted,
		"64-tree with top after bottom to right nodes inplace inserted", t)

	r = nil
	r = r.InplaceInsert(0xAAAAAAAA00000000, 18, nBottom)
	r = r.InplaceInsert(0xABAAAAAA00000000, 10, nTop)
	assertTree64s(r, TestTree64sWithTopAfterBottomAndAdditionalNotLeafNodesInserted,
		"64-tree with top after bottom and additional not leaf nodes inplace inserted", t)

	r = nil
	r = r.InplaceInsert(0xAAAAAAAA00000000, 18, nBottom)
	r = r.InplaceInsert(0xABAAAAAA00000000, 10, nTop)
	assertTree64s(r, TestTree64sWithOldTopReplacingTopAfterBottomNodesInserted,
		"64-tree with old top replacing top after bottom nodes inplace inserted", t)
	r = r.InplaceInsert(0xABAAAAAA00000000, 7, nTest)
	assertTree64s(r, TestTree64sWithNewTopReplacingTopAfterBottomNodesInserted,
		"64-tree with new top replacing top after bottom nodes inplace inserted", t)

	r = nil
	r = r.InplaceInsert(0xAAAAAAAA00000000, 9, nTop)
	r = r.InplaceInsert(0xAAAAAAAA00000000, 18, nBottom)
	assertTree64s(r, TestTree64sWithTopBeforeBottomToLeftNodesInserted,
		"64-tree with top before bottom to left nodes inplace inserted", t)

	r = nil
	r = r.InplaceInsert(0xAAAAAAAA00000000, 10, nTop)
	r = r.InplaceInsert(0xAAAAAAAA00000000, 18, nBottom)
	assertTree64s(r, TestTree64sWithTopBeforeBottomToRightNodesInserted,
		"64-tree with top before bottom to right nodes inplace inserted", t)

	r = nil
	r = r.InplaceInsert(0xAAAAAAA00000000, 7, n10)
	r = r.InplaceInsert(0xABAAAAA00000000, 9, n20)
	r = r.InplaceInsert(0xAAAAAAA00000000, 18, n30)
	r = r.InplaceInsert(0xAABAAAA00000000, 19, n40)
	assertTree64s(r, TestTree64sWithTopBeforeBottomSeveralLevelNodesInserted,
		"64-tree with top before bottom several level nodes inplace inserted", t)

	r = nil
	r = r.InplaceInsert(0, -10, nil)
	assertTree64s(r, TestTree64sWithNegativeNumberOfBits,
		"64-tree with negative number of significant bits (inplace)", t)

	r = nil
	r = r.InplaceInsert(0, 65, nil)
	assertTree64s(r, TestTree64sWithTooBigNumberOfBits,
		"64-tree with too big number of significant bits (inplace)", t)
}

func TestEnumerate64s(t *testing.T) {
	var r *node64s

	ch := r.Enumerate()
	assertSequence64s(ch, t, "64-tree empty tree")

	r = r.Insert(0xAAAAAAAA00000000, 7, n10)
	r = r.Insert(0xA8AAAAAA00000000, 9, n21)
	r = r.Insert(0xABAAAAAA00000000, 9, n22)
	r = r.Insert(0xAAAAAAAA00000000, 18, n30)
	r = r.Insert(0xAAABAAAA00000000, 24, n50)
	r = r.Insert(0xAABAAAAA00000000, 19, n40)
	ch = r.Enumerate()
	assertSequence64s(ch, t, "64-tree for enumeration",
		fmt.Sprintf("0xa8aaaaaa00000000/9: %p", n21),
		fmt.Sprintf("0xaaaaaaaa00000000/7: %p", n10),
		fmt.Sprintf("0xaaaaaaaa00000000/18: %p", n30),
		fmt.Sprintf("0xaaabaaaa00000000/24: %p", n50),
		fmt.Sprintf("0xaabaaaaa00000000/19: %p", n40),
		fmt.Sprintf("0xabaaaaaa00000000/9: %p", n22))
}

func TestMatch64s(t *testing.T) {
	var r *node64s

	v, ok := r.Match(0, 0)
	assertTreeNod64sMatch(v, ok, nil,
		"64-bit empty tree", t)

	r = r.Insert(0xAAAAAAAA00000000, 7, n10)
	r = r.Insert(0xA8AAAAAA00000000, 9, n21)
	r = r.Insert(0xABAAAAAA00000000, 9, n22)
	r = r.Insert(0xAAAAAAAA00000000, 18, n30)
	r = r.Insert(0xAABAAAAA00000000, 19, n40)

	v, ok = r.Match(0, -1)
	assertTreeNod64sMatch(v, ok, nil,
		"64-tree match with negative significant bits", t)

	v, ok = r.Match(0xAAAAAAAA00000000, 67)
	assertTreeNod64sMatch(v, ok, wrapNode64(n30),
		"64-tree match with overflow significant bits number", t)

	v, ok = r.Match(0xAAAAAAAA00000000, 5)
	assertTreeNod64sMatch(v, ok, nil,
		"64-tree match with small significant bits number", t)

	v, ok = r.Match(0xA8AAAAAA00000000, 9)
	assertTreeNod64sMatch(v, ok, wrapNode64(n21),
		"64-tree match with exact match to a node", t)

	v, ok = r.Match(0xA9AAAAAA00000000, 9)
	assertTreeNod64sMatch(v, ok, nil,
		"64-tree match with exact not match to a node", t)

	v, ok = r.Match(0xAABAAACA00000000, 64)
	assertTreeNod64sMatch(v, ok, wrapNode64(n40),
		"64-tree match with contains match to child node", t)

	v, ok = r.Match(0xABAAAAAA00000000, 9)
	assertTreeNod64sMatch(v, ok, wrapNode64(n22),
		"64-tree match with exact match to child node", t)

	v, ok = r.Match(0xA80AAAAA00000000, 11)
	assertTreeNod64sMatch(v, ok, nil,
		"64-tree match with contains match to non-leaf node", t)
}

func TestExactMatch64s(t *testing.T) {
	var r *node64s

	v, ok := r.ExactMatch(0, 0)
	assertTreeNod64sMatch(v, ok, nil,
		"64-bit empty tree", t)

	r = r.Insert(0xAAAAAAAA00000000, 7, n10)
	r = r.Insert(0xA8AAAAAA00000000, 9, n21)
	r = r.Insert(0xABAAAAAA00000000, 9, n22)
	r = r.Insert(0xAAAAAAAA00000000, 18, n30)
	r = r.Insert(0xAABAAAAA00000000, 19, n40)

	v, ok = r.ExactMatch(0, -1)
	assertTreeNod64sMatch(v, ok, nil,
		"64-tree exact match with negative significant bits", t)

	v, ok = r.ExactMatch(0xAAAAAAAA00000000, 65)
	assertTreeNod64sMatch(v, ok, nil,
		"64-tree exact match with overflow significant bits number", t)

	v, ok = r.ExactMatch(0xAAAAAAAA00000000, 5)
	assertTreeNod64sMatch(v, ok, nil,
		"64-tree exact match with small significant bits number", t)

	v, ok = r.ExactMatch(0xA8AAAAAA00000000, 9)
	assertTreeNod64sMatch(v, ok, wrapNode64(n21),
		"64-tree exact match with exact match to a node", t)

	v, ok = r.ExactMatch(0xA9AAAAAA00000000, 9)
	assertTreeNod64sMatch(v, ok, nil,
		"64-tree exact match with exact not match to a node", t)

	v, ok = r.ExactMatch(0xAABAAACA00000000, 64)
	assertTreeNod64sMatch(v, ok, nil,
		"64-tree exact match with contains not match to child node", t)

	v, ok = r.ExactMatch(0xABAAAAAA00000000, 9)
	assertTreeNod64sMatch(v, ok, wrapNode64(n22),
		"64-tree match with exact match to child node", t)

	v, ok = r.ExactMatch(0xA80AAAAA00000000, 11)
	assertTreeNod64sMatch(v, ok, nil,
		"64-tree match with contains match to non-leaf node", t)
}

func TestDelete64s(t *testing.T) {
	var (
		r  *node64s
		ok bool
	)

	r, ok = r.Delete(0, 64)
	assertTree64sDelete(r, ok, "", "64-bit empty tree", t)

	r = nil
	r = r.Insert(0xAAAAAAAA00000000, 18, nTest)
	r, ok = r.Delete(0xAAAAAAAA00000000, 9)
	assertTree64sDelete(r, ok, TestTree64sEmptyTree,
		"64-tree with contained node", t)

	r = nil
	r = r.Insert(0xAAAAAAAA00000000, 18, nTest)
	r, ok = r.Delete(0xBBBBBBBB00000000, 9)
	assertTree64sDelete(r, ok, "", "64-tree with not contained node", t)

	r = nil
	r = r.Insert(0xAAAAAAAA00000000, 9, nTest)
	r = r.Insert(0xAAAAAAAA00000000, 18, nTest)
	r, ok = r.Delete(0xBBBBBBBB00000000, 10)
	assertTree64sDelete(r, ok, "", "64-tree with not containing node", t)

	r, ok = r.Delete(0xAAEAAAAA00000000, 10)
	assertTree64sDelete(r, ok, "", "64-tree with empty branch", t)

	r, ok = r.Delete(0xAAABBBBB00000000, 16)
	assertTree64sDelete(r, ok, "", "64-tree with not contained branch", t)

	r, ok = r.Delete(0xAAAAAAAA00000000, 16)
	assertTree64sDelete(r, ok, TestTree64sWithDeletedChildNode,
		"64-tree with deleted child node", t)

	r, ok = r.Delete(0, -10)
	assertTree64sDelete(r, ok, TestTree64sEmptyTree,
		"64-tree with deleted all nodes by negative number of significant bits", t)

	r = nil
	r = r.Insert(0xAAAAAAAA00000000, 9, nTest)
	r = r.Insert(0xAAAAAAAA00000000, 64, nTest)
	r, ok = r.Delete(0xAAAAAAAA00000000, 65)
	assertTree64sDelete(r, ok, TestTree64sWithDeletedChildNode,
		"64-tree with deleted child node by too big number of significant bits", t)

	r = nil
	r = r.Insert(0xAAAAAAAA00000000, 7, n10)
	r = r.Insert(0xA8AAAAAA00000000, 9, n21)
	r = r.Insert(0xABAAAAAA00000000, 9, n22)
	r = r.Insert(0xAAAAAAAA00000000, 18, n30)
	r = r.Insert(0xAAABAAAA00000000, 24, n50)
	r = r.Insert(0xAABAAAAA00000000, 19, n40)

	r, ok = r.Delete(0xAABAAAAA00000000, 19)
	assertTree64sDelete(r, ok, TestTree64sWithDeletedChildAndNonLeafNodes,
		"64-tree with deleted child and non-leaf node", t)

	r, ok = r.Delete(0xAAAAAAAA00000000, 18)
	assertTree64sDelete(r, ok, TestTree64sWithDeletedTwoChildrenAndNonLeafNodes,
		"64-tree with deleted two children and non-leaf nodes", t)
}

func assertTree64s(r *node64s, e, desc string, t *testing.T) {
	assertStringLists(difflib.SplitLines(r.Dot()), difflib.SplitLines(e), desc, t)
}

func assertSequence64s(ch chan *node64s, t *testing.T, desc string, e ...string) {
	items := []string{}
	for n := range ch {
		if n == nil {
			items = append(items, fmt.Sprintf("%#v\n", n))
			continue
		}

		items = append(items, fmt.Sprintf("0x%016x/%d: %p\n", n.key, n.bits, n.value))
	}

	eItems := make([]string, len(e))
	for i, item := range e {
		eItems[i] = item + "\n"
	}

	assertStringLists(items, eItems, desc, t)
}

func wrapNode64(n *node64) **node64 {
	return &n
}

func assertTreeNod64sMatch(v *node64, ok bool, e **node64, desc string, t *testing.T) {
	if e == nil {
		if ok {
			t.Errorf("Expected no result for %s but got ok: true, value: %p", desc, v)
		}
	} else if !ok {
		t.Errorf("Expected some result for %s but got ok: false, value: %p", desc, v)
	} else if v != *e {
		t.Errorf("Expected %p as result for %s but got %p", *e, desc, v)
	}
}

func assertTree64sDelete(r *node64s, ok bool, e string, desc string, t *testing.T) {
	if len(e) > 0 {
		if !ok {
			t.Errorf("Expected something to be deleted from %s but it isn't and got old root:\n%s\n", desc, r.Dot())
			return
		}

		assertTree64s(r, e, desc, t)
	} else if ok {
		t.Errorf("Expected nothing to be deleted from %s but it is and got new root:\n%s\n", desc, r.Dot())
	}
}

var (
	TestTree64sWithSingleNodeInserted = fmt.Sprintf(`digraph d {
N0 [label="k: 0000000000000000, b: 64, v: \"%p\""]
}
`, nTest)

	TestTree64sWithTopAfterBottomToLeftNodesInserted = fmt.Sprintf(`digraph d {
N0 [label="k: aaaaaaaa00000000, b: 9, v: \"%p\""]
N0 -> { N1 N2 }
N1 [label="k: aaaaaaaa00000000, b: 18, v: \"%p\""]
N2 [label="nil"]
}
`, nTop, nBottom)

	TestTree64sWithTopAfterBottomToRightNodesInserted = fmt.Sprintf(`digraph d {
N0 [label="k: aaaaaaaa00000000, b: 10, v: \"%p\""]
N0 -> { N1 N2 }
N1 [label="nil"]
N2 [label="k: aaaaaaaa00000000, b: 18, v: \"%p\""]
}
`, nTop, nBottom)

	TestTree64sWithTopAfterBottomAndAdditionalNotLeafNodesInserted = fmt.Sprintf(`digraph d {
N0 [label="k: aa00000000000000, b: 7"]
N0 -> { N1 N2 }
N1 [label="k: aaaaaaaa00000000, b: 18, v: \"%p\""]
N2 [label="k: abaaaaaa00000000, b: 10, v: \"%p\""]
}
`, nBottom, nTop)

	TestTree64sWithOldTopReplacingTopAfterBottomNodesInserted = fmt.Sprintf(`digraph d {
N0 [label="k: aa00000000000000, b: 7"]
N0 -> { N1 N2 }
N1 [label="k: aaaaaaaa00000000, b: 18, v: \"%p\""]
N2 [label="k: abaaaaaa00000000, b: 10, v: \"%p\""]
}
`, nBottom, nTop)

	TestTree64sWithNewTopReplacingTopAfterBottomNodesInserted = fmt.Sprintf(`digraph d {
N0 [label="k: abaaaaaa00000000, b: 7, v: \"%p\""]
N0 -> { N1 N2 }
N1 [label="k: aaaaaaaa00000000, b: 18, v: \"%p\""]
N2 [label="k: abaaaaaa00000000, b: 10, v: \"%p\""]
}
`, nTest, nBottom, nTop)

	TestTree64sWithTopBeforeBottomToLeftNodesInserted = fmt.Sprintf(`digraph d {
N0 [label="k: aaaaaaaa00000000, b: 9, v: \"%p\""]
N0 -> { N1 N2 }
N1 [label="k: aaaaaaaa00000000, b: 18, v: \"%p\""]
N2 [label="nil"]
}
`, nTop, nBottom)

	TestTree64sWithTopBeforeBottomToRightNodesInserted = fmt.Sprintf(`digraph d {
N0 [label="k: aaaaaaaa00000000, b: 10, v: \"%p\""]
N0 -> { N1 N2 }
N1 [label="nil"]
N2 [label="k: aaaaaaaa00000000, b: 18, v: \"%p\""]
}
`, nTop, nBottom)

	TestTree64sWithTopBeforeBottomSeveralLevelNodesInserted = fmt.Sprintf(`digraph d {
N0 [label="k: 0aaaaaaa00000000, b: 7, v: \"%p\""]
N0 -> { N1 N2 }
N1 [label="k: 0abaaaaa00000000, b: 9, v: \"%p\""]
N1 -> { N3 N4 }
N2 [label="nil"]
N3 [label="k: 0aaa000000000000, b: 15"]
N3 -> { N5 N6 }
N4 [label="nil"]
N5 [label="k: 0aaaaaaa00000000, b: 18, v: \"%p\""]
N6 [label="k: 0aabaaaa00000000, b: 19, v: \"%p\""]
}
`, n10, n20, n30, n40)

	TestTree64sWithNegativeNumberOfBits = `digraph d {
N0 [label="k: 0000000000000000, b: 0, v: \"0x0\""]
}
`

	TestTree64sWithTooBigNumberOfBits = `digraph d {
N0 [label="k: 0000000000000000, b: 64, v: \"0x0\""]
}
`

	TestTree64sEmptyTree = `digraph d {
N0 [label="nil"]
}
`

	TestTree64sWithDeletedChildNode = fmt.Sprintf(`digraph d {
N0 [label="k: aaaaaaaa00000000, b: 9, v: \"%p\""]
}
`, nTest)

	TestTree64sWithDeletedChildAndNonLeafNodes = fmt.Sprintf(`digraph d {
N0 [label="k: a800000000000000, b: 6"]
N0 -> { N1 N2 }
N1 [label="k: a8aaaaaa00000000, b: 9, v: \"%p\""]
N2 [label="k: aaaaaaaa00000000, b: 7, v: \"%p\""]
N2 -> { N3 N4 }
N3 [label="k: aaaa000000000000, b: 15"]
N3 -> { N5 N6 }
N4 [label="k: abaaaaaa00000000, b: 9, v: \"%p\""]
N5 [label="k: aaaaaaaa00000000, b: 18, v: \"%p\""]
N6 [label="k: aaabaaaa00000000, b: 24, v: \"%p\""]
}
`, n21, n10, n22, n30, n50)

	TestTree64sWithDeletedTwoChildrenAndNonLeafNodes = fmt.Sprintf(`digraph d {
N0 [label="k: a800000000000000, b: 6"]
N0 -> { N1 N2 }
N1 [label="k: a8aaaaaa00000000, b: 9, v: \"%p\""]
N2 [label="k: aaaaaaaa00000000, b: 7, v: \"%p\""]
N2 -> { N3 N4 }
N3 [label="k: aaabaaaa00000000, b: 24, v: \"%p\""]
N4 [label="k: abaaaaaa00000000, b: 9, v: \"%p\""]
}
`, n21, n10, n50, n22)
)

/*var inv64 = []uint8{
0x0, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0, 0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
0x8, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8, 0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
0x4, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4, 0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
0xc, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec, 0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
0x2, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2, 0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
0xa, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea, 0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
0x6, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6, 0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
0xe, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee, 0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
0x1, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1, 0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
0x9, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9, 0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
0x5, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5, 0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
0xd, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed, 0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
0x3, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3, 0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
0xb, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb, 0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
0x7, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7, 0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
0xf, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef, 0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff}*/
