package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsTopicList invokes the ons.OnsTopicList API synchronously
// api document: https://help.aliyun.com/api/ons/onstopiclist.html
func (client *Client) OnsTopicList(request *OnsTopicListRequest) (response *OnsTopicListResponse, err error) {
	response = CreateOnsTopicListResponse()
	err = client.DoAction(request, response)
	return
}

// OnsTopicListWithChan invokes the ons.OnsTopicList API asynchronously
// api document: https://help.aliyun.com/api/ons/onstopiclist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsTopicListWithChan(request *OnsTopicListRequest) (<-chan *OnsTopicListResponse, <-chan error) {
	responseChan := make(chan *OnsTopicListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsTopicList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsTopicListWithCallback invokes the ons.OnsTopicList API asynchronously
// api document: https://help.aliyun.com/api/ons/onstopiclist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsTopicListWithCallback(request *OnsTopicListRequest, callback func(response *OnsTopicListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsTopicListResponse
		var err error
		defer close(result)
		response, err = client.OnsTopicList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsTopicListRequest is the request struct for api OnsTopicList
type OnsTopicListRequest struct {
	*requests.RpcRequest
	PreventCache requests.Integer `position:"Query" name:"PreventCache"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	Topic        string           `position:"Query" name:"Topic"`
}

// OnsTopicListResponse is the response struct for api OnsTopicList
type OnsTopicListResponse struct {
	*responses.BaseResponse
	RequestId string             `json:"RequestId" xml:"RequestId"`
	HelpUrl   string             `json:"HelpUrl" xml:"HelpUrl"`
	Data      DataInOnsTopicList `json:"Data" xml:"Data"`
}

// CreateOnsTopicListRequest creates a request to invoke OnsTopicList API
func CreateOnsTopicListRequest() (request *OnsTopicListRequest) {
	request = &OnsTopicListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsTopicList", "ons", "openAPI")
	return
}

// CreateOnsTopicListResponse creates a response to parse from OnsTopicList response
func CreateOnsTopicListResponse() (response *OnsTopicListResponse) {
	response = &OnsTopicListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
