package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGtmAccessStrategy invokes the alidns.DescribeGtmAccessStrategy API synchronously
// api document: https://help.aliyun.com/api/alidns/describegtmaccessstrategy.html
func (client *Client) DescribeGtmAccessStrategy(request *DescribeGtmAccessStrategyRequest) (response *DescribeGtmAccessStrategyResponse, err error) {
	response = CreateDescribeGtmAccessStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGtmAccessStrategyWithChan invokes the alidns.DescribeGtmAccessStrategy API asynchronously
// api document: https://help.aliyun.com/api/alidns/describegtmaccessstrategy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGtmAccessStrategyWithChan(request *DescribeGtmAccessStrategyRequest) (<-chan *DescribeGtmAccessStrategyResponse, <-chan error) {
	responseChan := make(chan *DescribeGtmAccessStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGtmAccessStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGtmAccessStrategyWithCallback invokes the alidns.DescribeGtmAccessStrategy API asynchronously
// api document: https://help.aliyun.com/api/alidns/describegtmaccessstrategy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeGtmAccessStrategyWithCallback(request *DescribeGtmAccessStrategyRequest, callback func(response *DescribeGtmAccessStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGtmAccessStrategyResponse
		var err error
		defer close(result)
		response, err = client.DescribeGtmAccessStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGtmAccessStrategyRequest is the request struct for api DescribeGtmAccessStrategy
type DescribeGtmAccessStrategyRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	StrategyId   string `position:"Query" name:"StrategyId"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeGtmAccessStrategyResponse is the response struct for api DescribeGtmAccessStrategy
type DescribeGtmAccessStrategyResponse struct {
	*responses.BaseResponse
	RequestId            string                           `json:"RequestId" xml:"RequestId"`
	StrategyId           string                           `json:"StrategyId" xml:"StrategyId"`
	StrategyName         string                           `json:"StrategyName" xml:"StrategyName"`
	DefultAddrPoolId     string                           `json:"DefultAddrPoolId" xml:"DefultAddrPoolId"`
	DefaultAddrPoolName  string                           `json:"DefaultAddrPoolName" xml:"DefaultAddrPoolName"`
	FailoverAddrPoolId   string                           `json:"FailoverAddrPoolId" xml:"FailoverAddrPoolId"`
	FailoverAddrPoolName string                           `json:"FailoverAddrPoolName" xml:"FailoverAddrPoolName"`
	StrategyMode         string                           `json:"StrategyMode" xml:"StrategyMode"`
	AccessMode           string                           `json:"AccessMode" xml:"AccessMode"`
	AccessStatus         string                           `json:"AccessStatus" xml:"AccessStatus"`
	InstanceId           string                           `json:"InstanceId" xml:"InstanceId"`
	Lines                LinesInDescribeGtmAccessStrategy `json:"Lines" xml:"Lines"`
}

// CreateDescribeGtmAccessStrategyRequest creates a request to invoke DescribeGtmAccessStrategy API
func CreateDescribeGtmAccessStrategyRequest() (request *DescribeGtmAccessStrategyRequest) {
	request = &DescribeGtmAccessStrategyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeGtmAccessStrategy", "Alidns", "openAPI")
	return
}

// CreateDescribeGtmAccessStrategyResponse creates a response to parse from DescribeGtmAccessStrategy response
func CreateDescribeGtmAccessStrategyResponse() (response *DescribeGtmAccessStrategyResponse) {
	response = &DescribeGtmAccessStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
