package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBuySummary invokes the aegis.DescribeBuySummary API synchronously
// api document: https://help.aliyun.com/api/aegis/describebuysummary.html
func (client *Client) DescribeBuySummary(request *DescribeBuySummaryRequest) (response *DescribeBuySummaryResponse, err error) {
	response = CreateDescribeBuySummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBuySummaryWithChan invokes the aegis.DescribeBuySummary API asynchronously
// api document: https://help.aliyun.com/api/aegis/describebuysummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBuySummaryWithChan(request *DescribeBuySummaryRequest) (<-chan *DescribeBuySummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeBuySummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBuySummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBuySummaryWithCallback invokes the aegis.DescribeBuySummary API asynchronously
// api document: https://help.aliyun.com/api/aegis/describebuysummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBuySummaryWithCallback(request *DescribeBuySummaryRequest, callback func(response *DescribeBuySummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBuySummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeBuySummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBuySummaryRequest is the request struct for api DescribeBuySummary
type DescribeBuySummaryRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeBuySummaryResponse is the response struct for api DescribeBuySummary
type DescribeBuySummaryResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	BuySummary BuySummary `json:"BuySummary" xml:"BuySummary"`
}

// CreateDescribeBuySummaryRequest creates a request to invoke DescribeBuySummary API
func CreateDescribeBuySummaryRequest() (request *DescribeBuySummaryRequest) {
	request = &DescribeBuySummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeBuySummary", "vipaegis", "openAPI")
	return
}

// CreateDescribeBuySummaryResponse creates a response to parse from DescribeBuySummary response
func CreateDescribeBuySummaryResponse() (response *DescribeBuySummaryResponse) {
	response = &DescribeBuySummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
