package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSuspEventUserSetting invokes the aegis.SaveSuspEventUserSetting API synchronously
// api document: https://help.aliyun.com/api/aegis/savesuspeventusersetting.html
func (client *Client) SaveSuspEventUserSetting(request *SaveSuspEventUserSettingRequest) (response *SaveSuspEventUserSettingResponse, err error) {
	response = CreateSaveSuspEventUserSettingResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSuspEventUserSettingWithChan invokes the aegis.SaveSuspEventUserSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/savesuspeventusersetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveSuspEventUserSettingWithChan(request *SaveSuspEventUserSettingRequest) (<-chan *SaveSuspEventUserSettingResponse, <-chan error) {
	responseChan := make(chan *SaveSuspEventUserSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSuspEventUserSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSuspEventUserSettingWithCallback invokes the aegis.SaveSuspEventUserSetting API asynchronously
// api document: https://help.aliyun.com/api/aegis/savesuspeventusersetting.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveSuspEventUserSettingWithCallback(request *SaveSuspEventUserSettingRequest, callback func(response *SaveSuspEventUserSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSuspEventUserSettingResponse
		var err error
		defer close(result)
		response, err = client.SaveSuspEventUserSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSuspEventUserSettingRequest is the request struct for api SaveSuspEventUserSetting
type SaveSuspEventUserSettingRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	From     string `position:"Query" name:"From"`
	LevelsOn string `position:"Query" name:"LevelsOn"`
}

// SaveSuspEventUserSettingResponse is the response struct for api SaveSuspEventUserSetting
type SaveSuspEventUserSettingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSaveSuspEventUserSettingRequest creates a request to invoke SaveSuspEventUserSetting API
func CreateSaveSuspEventUserSettingRequest() (request *SaveSuspEventUserSettingRequest) {
	request = &SaveSuspEventUserSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "SaveSuspEventUserSetting", "vipaegis", "openAPI")
	return
}

// CreateSaveSuspEventUserSettingResponse creates a response to parse from SaveSuspEventUserSetting response
func CreateSaveSuspEventUserSettingResponse() (response *SaveSuspEventUserSettingResponse) {
	response = &SaveSuspEventUserSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
