//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMigrationJobs invokes the dts.DescribeMigrationJobs API synchronously
// api document: https://help.aliyun.com/api/dts/describemigrationjobs.html
func (client *Client) DescribeMigrationJobs(request *DescribeMigrationJobsRequest) (response *DescribeMigrationJobsResponse, err error) {
	response = CreateDescribeMigrationJobsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMigrationJobsWithChan invokes the dts.DescribeMigrationJobs API asynchronously
// api document: https://help.aliyun.com/api/dts/describemigrationjobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMigrationJobsWithChan(request *DescribeMigrationJobsRequest) (<-chan *DescribeMigrationJobsResponse, <-chan error) {
	responseChan := make(chan *DescribeMigrationJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMigrationJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMigrationJobsWithCallback invokes the dts.DescribeMigrationJobs API asynchronously
// api document: https://help.aliyun.com/api/dts/describemigrationjobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeMigrationJobsWithCallback(request *DescribeMigrationJobsRequest, callback func(response *DescribeMigrationJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMigrationJobsResponse
		var err error
		defer close(result)
		response, err = client.DescribeMigrationJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMigrationJobsRequest is the request struct for api DescribeMigrationJobs
type DescribeMigrationJobsRequest struct {
	*requests.RpcRequest
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	PageNum          requests.Integer `position:"Query" name:"PageNum"`
	MigrationJobName string           `position:"Query" name:"MigrationJobName"`
	OwnerId          string           `position:"Query" name:"OwnerId"`
}

// DescribeMigrationJobsResponse is the response struct for api DescribeMigrationJobs
type DescribeMigrationJobsResponse struct {
	*responses.BaseResponse
	PageNumber       int                                 `json:"PageNumber" xml:"PageNumber"`
	TotalRecordCount int64                               `json:"TotalRecordCount" xml:"TotalRecordCount"`
	PageRecordCount  int                                 `json:"PageRecordCount" xml:"PageRecordCount"`
	MigrationJobs    DescribeMigrationJobsMigrationJobs0 `json:"MigrationJobs" xml:"MigrationJobs"`
}

type DescribeMigrationJobsMigrationJobs0 struct {
	MigrationJob []DescribeMigrationJobsMigrationJob1 `json:"MigrationJob" xml:"MigrationJob"`
}

type DescribeMigrationJobsMigrationJob1 struct {
	MigrationJobID          string                                        `json:"MigrationJobID" xml:"MigrationJobID"`
	MigrationJobName        string                                        `json:"MigrationJobName" xml:"MigrationJobName"`
	PayType                 string                                        `json:"PayType" xml:"PayType"`
	MigrationJobClass       string                                        `json:"MigrationJobClass" xml:"MigrationJobClass"`
	MigrationJobStatus      string                                        `json:"MigrationJobStatus" xml:"MigrationJobStatus"`
	MigrationObject         []DescribeMigrationJobsMigrationObject1       `json:"MigrationObject" xml:"MigrationObject"`
	SourceEndpoint          DescribeMigrationJobsSourceEndpoint1          `json:"SourceEndpoint" xml:"SourceEndpoint"`
	DestinationEndpoint     DescribeMigrationJobsDestinationEndpoint1     `json:"DestinationEndpoint" xml:"DestinationEndpoint"`
	MigrationMode           DescribeMigrationJobsMigrationMode1           `json:"MigrationMode" xml:"MigrationMode"`
	Precheck                DescribeMigrationJobsPrecheck1                `json:"Precheck" xml:"Precheck"`
	StructureInitialization DescribeMigrationJobsStructureInitialization1 `json:"StructureInitialization" xml:"StructureInitialization"`
	DataInitialization      DescribeMigrationJobsDataInitialization1      `json:"DataInitialization" xml:"DataInitialization"`
	DataSynchronization     DescribeMigrationJobsDataSynchronization1     `json:"DataSynchronization" xml:"DataSynchronization"`
}

type DescribeMigrationJobsMigrationObject1 struct {
	SynchronousObject []DescribeMigrationJobsSynchronousObject2 `json:"SynchronousObject" xml:"SynchronousObject"`
}

type DescribeMigrationJobsSynchronousObject2 struct {
	DatabaseName  string   `json:"DatabaseName" xml:"DatabaseName"`
	WholeDatabase string   `json:"WholeDatabase" xml:"WholeDatabase"`
	TableList     []string `json:"TableList" xml:"TableList"`
}

type DescribeMigrationJobsSourceEndpoint1 struct {
	InstanceID   string `json:"InstanceID" xml:"InstanceID"`
	InstanceType string `json:"InstanceType" xml:"InstanceType"`
	EngineName   string `json:"EngineName" xml:"EngineName"`
	IP           string `json:"IP" xml:"IP"`
	Port         string `json:"Port" xml:"Port"`
	DatabaseName string `json:"DatabaseName" xml:"DatabaseName"`
	OracleSID    string `json:"OracleSID" xml:"OracleSID"`
	UserName     string `json:"UserName" xml:"UserName"`
}

type DescribeMigrationJobsDestinationEndpoint1 struct {
	InstanceID   string `json:"InstanceID" xml:"InstanceID"`
	InstanceType string `json:"InstanceType" xml:"InstanceType"`
	EngineName   string `json:"EngineName" xml:"EngineName"`
	IP           string `json:"IP" xml:"IP"`
	Port         string `json:"Port" xml:"Port"`
	DatabaseName string `json:"DatabaseName" xml:"DatabaseName"`
	OracleSID    string `json:"OracleSID" xml:"OracleSID"`
	UserName     string `json:"UserName" xml:"UserName"`
}

type DescribeMigrationJobsMigrationMode1 struct {
	StructureInitialization bool `json:"StructureInitialization" xml:"StructureInitialization"`
	DataInitialization      bool `json:"DataInitialization" xml:"DataInitialization"`
	DataSynchronization     bool `json:"DataSynchronization" xml:"DataSynchronization"`
}

type DescribeMigrationJobsPrecheck1 struct {
	Status  string `json:"Status" xml:"Status"`
	Percent string `json:"Percent" xml:"Percent"`
}

type DescribeMigrationJobsStructureInitialization1 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Progress     string `json:"Progress" xml:"Progress"`
}

type DescribeMigrationJobsDataInitialization1 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Progress     string `json:"Progress" xml:"Progress"`
}

type DescribeMigrationJobsDataSynchronization1 struct {
	Status       string `json:"Status" xml:"Status"`
	Percent      string `json:"Percent" xml:"Percent"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Delay        string `json:"Delay" xml:"Delay"`
}

// CreateDescribeMigrationJobsRequest creates a request to invoke DescribeMigrationJobs API
func CreateDescribeMigrationJobsRequest() (request *DescribeMigrationJobsRequest) {
	request = &DescribeMigrationJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "DescribeMigrationJobs", "dts", "openAPI")
	return
}

// CreateDescribeMigrationJobsResponse creates a response to parse from DescribeMigrationJobs response
func CreateDescribeMigrationJobsResponse() (response *DescribeMigrationJobsResponse) {
	response = &DescribeMigrationJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
