package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateKeywordLib invokes the green.UpdateKeywordLib API synchronously
// api document: https://help.aliyun.com/api/green/updatekeywordlib.html
func (client *Client) UpdateKeywordLib(request *UpdateKeywordLibRequest) (response *UpdateKeywordLibResponse, err error) {
	response = CreateUpdateKeywordLibResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateKeywordLibWithChan invokes the green.UpdateKeywordLib API asynchronously
// api document: https://help.aliyun.com/api/green/updatekeywordlib.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateKeywordLibWithChan(request *UpdateKeywordLibRequest) (<-chan *UpdateKeywordLibResponse, <-chan error) {
	responseChan := make(chan *UpdateKeywordLibResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateKeywordLib(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateKeywordLibWithCallback invokes the green.UpdateKeywordLib API asynchronously
// api document: https://help.aliyun.com/api/green/updatekeywordlib.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateKeywordLibWithCallback(request *UpdateKeywordLibRequest, callback func(response *UpdateKeywordLibResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateKeywordLibResponse
		var err error
		defer close(result)
		response, err = client.UpdateKeywordLib(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateKeywordLibRequest is the request struct for api UpdateKeywordLib
type UpdateKeywordLibRequest struct {
	*requests.RpcRequest
	SourceIp string           `position:"Query" name:"SourceIp"`
	Name     string           `position:"Query" name:"Name"`
	BizTypes string           `position:"Query" name:"BizTypes"`
	Id       requests.Integer `position:"Query" name:"Id"`
	Lang     string           `position:"Query" name:"Lang"`
}

// UpdateKeywordLibResponse is the response struct for api UpdateKeywordLib
type UpdateKeywordLibResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateKeywordLibRequest creates a request to invoke UpdateKeywordLib API
func CreateUpdateKeywordLibRequest() (request *UpdateKeywordLibRequest) {
	request = &UpdateKeywordLibRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "UpdateKeywordLib", "green", "openAPI")
	return
}

// CreateUpdateKeywordLibResponse creates a response to parse from UpdateKeywordLib response
func CreateUpdateKeywordLibResponse() (response *UpdateKeywordLibResponse) {
	response = &UpdateKeywordLibResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
