package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendRoomNotification invokes the live.SendRoomNotification API synchronously
// api document: https://help.aliyun.com/api/live/sendroomnotification.html
func (client *Client) SendRoomNotification(request *SendRoomNotificationRequest) (response *SendRoomNotificationResponse, err error) {
	response = CreateSendRoomNotificationResponse()
	err = client.DoAction(request, response)
	return
}

// SendRoomNotificationWithChan invokes the live.SendRoomNotification API asynchronously
// api document: https://help.aliyun.com/api/live/sendroomnotification.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendRoomNotificationWithChan(request *SendRoomNotificationRequest) (<-chan *SendRoomNotificationResponse, <-chan error) {
	responseChan := make(chan *SendRoomNotificationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendRoomNotification(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendRoomNotificationWithCallback invokes the live.SendRoomNotification API asynchronously
// api document: https://help.aliyun.com/api/live/sendroomnotification.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendRoomNotificationWithCallback(request *SendRoomNotificationRequest, callback func(response *SendRoomNotificationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendRoomNotificationResponse
		var err error
		defer close(result)
		response, err = client.SendRoomNotification(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendRoomNotificationRequest is the request struct for api SendRoomNotification
type SendRoomNotificationRequest struct {
	*requests.RpcRequest
	Data     string           `position:"Query" name:"Data"`
	AppUid   string           `position:"Query" name:"AppUid"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	Priority requests.Integer `position:"Query" name:"Priority"`
	RoomId   string           `position:"Query" name:"RoomId"`
	AppId    string           `position:"Query" name:"AppId"`
}

// SendRoomNotificationResponse is the response struct for api SendRoomNotification
type SendRoomNotificationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	MessageId string `json:"MessageId" xml:"MessageId"`
}

// CreateSendRoomNotificationRequest creates a request to invoke SendRoomNotification API
func CreateSendRoomNotificationRequest() (request *SendRoomNotificationRequest) {
	request = &SendRoomNotificationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SendRoomNotification", "live", "openAPI")
	return
}

// CreateSendRoomNotificationResponse creates a response to parse from SendRoomNotification response
func CreateSendRoomNotificationResponse() (response *SendRoomNotificationResponse) {
	response = &SendRoomNotificationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
