package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetSagRouteableAddress invokes the smartag.SetSagRouteableAddress API synchronously
// api document: https://help.aliyun.com/api/smartag/setsagrouteableaddress.html
func (client *Client) SetSagRouteableAddress(request *SetSagRouteableAddressRequest) (response *SetSagRouteableAddressResponse, err error) {
	response = CreateSetSagRouteableAddressResponse()
	err = client.DoAction(request, response)
	return
}

// SetSagRouteableAddressWithChan invokes the smartag.SetSagRouteableAddress API asynchronously
// api document: https://help.aliyun.com/api/smartag/setsagrouteableaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetSagRouteableAddressWithChan(request *SetSagRouteableAddressRequest) (<-chan *SetSagRouteableAddressResponse, <-chan error) {
	responseChan := make(chan *SetSagRouteableAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetSagRouteableAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetSagRouteableAddressWithCallback invokes the smartag.SetSagRouteableAddress API asynchronously
// api document: https://help.aliyun.com/api/smartag/setsagrouteableaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetSagRouteableAddressWithCallback(request *SetSagRouteableAddressRequest, callback func(response *SetSagRouteableAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetSagRouteableAddressResponse
		var err error
		defer close(result)
		response, err = client.SetSagRouteableAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetSagRouteableAddressRequest is the request struct for api SetSagRouteableAddress
type SetSagRouteableAddressRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	SagId                string           `position:"Query" name:"SagId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	RouteableAddress     string           `position:"Query" name:"RouteableAddress"`
}

// SetSagRouteableAddressResponse is the response struct for api SetSagRouteableAddress
type SetSagRouteableAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetSagRouteableAddressRequest creates a request to invoke SetSagRouteableAddress API
func CreateSetSagRouteableAddressRequest() (request *SetSagRouteableAddressRequest) {
	request = &SetSagRouteableAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "SetSagRouteableAddress", "smartag", "openAPI")
	return
}

// CreateSetSagRouteableAddressResponse creates a response to parse from SetSagRouteableAddress response
func CreateSetSagRouteableAddressResponse() (response *SetSagRouteableAddressResponse) {
	response = &SetSagRouteableAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
