package yundun_ds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDeparts invokes the yundun_ds.DescribeDeparts API synchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedeparts.html
func (client *Client) DescribeDeparts(request *DescribeDepartsRequest) (response *DescribeDepartsResponse, err error) {
	response = CreateDescribeDepartsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDepartsWithChan invokes the yundun_ds.DescribeDeparts API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedeparts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDepartsWithChan(request *DescribeDepartsRequest) (<-chan *DescribeDepartsResponse, <-chan error) {
	responseChan := make(chan *DescribeDepartsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDeparts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDepartsWithCallback invokes the yundun_ds.DescribeDeparts API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedeparts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDepartsWithCallback(request *DescribeDepartsRequest, callback func(response *DescribeDepartsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDepartsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDeparts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDepartsRequest is the request struct for api DescribeDeparts
type DescribeDepartsRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	AccountType requests.Integer `position:"Query" name:"AccountType"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Lang        string           `position:"Query" name:"Lang"`
	Key         string           `position:"Query" name:"Key"`
}

// DescribeDepartsResponse is the response struct for api DescribeDeparts
type DescribeDepartsResponse struct {
	*responses.BaseResponse
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	PageSize    int      `json:"PageSize" xml:"PageSize"`
	CurrentPage int      `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount  int      `json:"TotalCount" xml:"TotalCount"`
	Items       []Depart `json:"Items" xml:"Items"`
}

// CreateDescribeDepartsRequest creates a request to invoke DescribeDeparts API
func CreateDescribeDepartsRequest() (request *DescribeDepartsRequest) {
	request = &DescribeDepartsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-ds", "2019-01-03", "DescribeDeparts", "sddp", "openAPI")
	return
}

// CreateDescribeDepartsResponse creates a response to parse from DescribeDeparts response
func CreateDescribeDepartsResponse() (response *DescribeDepartsResponse) {
	response = &DescribeDepartsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
