package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyGroupInstance invokes the cloudapi.ModifyGroupInstance API synchronously
// api document: https://help.aliyun.com/api/cloudapi/modifygroupinstance.html
func (client *Client) ModifyGroupInstance(request *ModifyGroupInstanceRequest) (response *ModifyGroupInstanceResponse, err error) {
	response = CreateModifyGroupInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyGroupInstanceWithChan invokes the cloudapi.ModifyGroupInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/modifygroupinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyGroupInstanceWithChan(request *ModifyGroupInstanceRequest) (<-chan *ModifyGroupInstanceResponse, <-chan error) {
	responseChan := make(chan *ModifyGroupInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyGroupInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyGroupInstanceWithCallback invokes the cloudapi.ModifyGroupInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/modifygroupinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyGroupInstanceWithCallback(request *ModifyGroupInstanceRequest, callback func(response *ModifyGroupInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyGroupInstanceResponse
		var err error
		defer close(result)
		response, err = client.ModifyGroupInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyGroupInstanceRequest is the request struct for api ModifyGroupInstance
type ModifyGroupInstanceRequest struct {
	*requests.RpcRequest
	TargetInstanceId string `position:"Query" name:"TargetInstanceId"`
	SecurityToken    string `position:"Query" name:"SecurityToken"`
	GroupId          string `position:"Query" name:"GroupId"`
	Remark           string `position:"Query" name:"Remark"`
}

// ModifyGroupInstanceResponse is the response struct for api ModifyGroupInstance
type ModifyGroupInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyGroupInstanceRequest creates a request to invoke ModifyGroupInstance API
func CreateModifyGroupInstanceRequest() (request *ModifyGroupInstanceRequest) {
	request = &ModifyGroupInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "ModifyGroupInstance", "apigateway", "openAPI")
	return
}

// CreateModifyGroupInstanceResponse creates a response to parse from ModifyGroupInstance response
func CreateModifyGroupInstanceResponse() (response *ModifyGroupInstanceResponse) {
	response = &ModifyGroupInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
