package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRepoSourceRepo invokes the cr.UpdateRepoSourceRepo API synchronously
// api document: https://help.aliyun.com/api/cr/updatereposourcerepo.html
func (client *Client) UpdateRepoSourceRepo(request *UpdateRepoSourceRepoRequest) (response *UpdateRepoSourceRepoResponse, err error) {
	response = CreateUpdateRepoSourceRepoResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRepoSourceRepoWithChan invokes the cr.UpdateRepoSourceRepo API asynchronously
// api document: https://help.aliyun.com/api/cr/updatereposourcerepo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateRepoSourceRepoWithChan(request *UpdateRepoSourceRepoRequest) (<-chan *UpdateRepoSourceRepoResponse, <-chan error) {
	responseChan := make(chan *UpdateRepoSourceRepoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRepoSourceRepo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRepoSourceRepoWithCallback invokes the cr.UpdateRepoSourceRepo API asynchronously
// api document: https://help.aliyun.com/api/cr/updatereposourcerepo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateRepoSourceRepoWithCallback(request *UpdateRepoSourceRepoRequest, callback func(response *UpdateRepoSourceRepoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRepoSourceRepoResponse
		var err error
		defer close(result)
		response, err = client.UpdateRepoSourceRepo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRepoSourceRepoRequest is the request struct for api UpdateRepoSourceRepo
type UpdateRepoSourceRepoRequest struct {
	*requests.RoaRequest
	RepoNamespace string `position:"Path" name:"RepoNamespace"`
	RepoName      string `position:"Path" name:"RepoName"`
}

// UpdateRepoSourceRepoResponse is the response struct for api UpdateRepoSourceRepo
type UpdateRepoSourceRepoResponse struct {
	*responses.BaseResponse
}

// CreateUpdateRepoSourceRepoRequest creates a request to invoke UpdateRepoSourceRepo API
func CreateUpdateRepoSourceRepoRequest() (request *UpdateRepoSourceRepoRequest) {
	request = &UpdateRepoSourceRepoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "UpdateRepoSourceRepo", "/repos/[RepoNamespace]/[RepoName]/sourceRepo", "cr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateRepoSourceRepoResponse creates a response to parse from UpdateRepoSourceRepo response
func CreateUpdateRepoSourceRepoResponse() (response *UpdateRepoSourceRepoResponse) {
	response = &UpdateRepoSourceRepoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
