package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListETLJobInstance invokes the emr.ListETLJobInstance API synchronously
// api document: https://help.aliyun.com/api/emr/listetljobinstance.html
func (client *Client) ListETLJobInstance(request *ListETLJobInstanceRequest) (response *ListETLJobInstanceResponse, err error) {
	response = CreateListETLJobInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ListETLJobInstanceWithChan invokes the emr.ListETLJobInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/listetljobinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListETLJobInstanceWithChan(request *ListETLJobInstanceRequest) (<-chan *ListETLJobInstanceResponse, <-chan error) {
	responseChan := make(chan *ListETLJobInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListETLJobInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListETLJobInstanceWithCallback invokes the emr.ListETLJobInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/listetljobinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListETLJobInstanceWithCallback(request *ListETLJobInstanceRequest, callback func(response *ListETLJobInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListETLJobInstanceResponse
		var err error
		defer close(result)
		response, err = client.ListETLJobInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListETLJobInstanceRequest is the request struct for api ListETLJobInstance
type ListETLJobInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	EtlJobId        string           `position:"Query" name:"EtlJobId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	Status          string           `position:"Query" name:"Status"`
}

// ListETLJobInstanceResponse is the response struct for api ListETLJobInstance
type ListETLJobInstanceResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Total        int          `json:"Total" xml:"Total"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	PageNumber   int          `json:"PageNumber" xml:"PageNumber"`
	InstanceList InstanceList `json:"InstanceList" xml:"InstanceList"`
}

// CreateListETLJobInstanceRequest creates a request to invoke ListETLJobInstance API
func CreateListETLJobInstanceRequest() (request *ListETLJobInstanceRequest) {
	request = &ListETLJobInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListETLJobInstance", "emr", "openAPI")
	return
}

// CreateListETLJobInstanceResponse creates a response to parse from ListETLJobInstance response
func CreateListETLJobInstanceResponse() (response *ListETLJobInstanceResponse) {
	response = &ListETLJobInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
