package api

/************************************************
  generated by IDE. for [IconAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *IconAPI) Reset() *IconAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *IconAPI) Offset(offset int) *IconAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *IconAPI) Limit(limit int) *IconAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *IconAPI) Include(key string) *IconAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *IconAPI) Exclude(key string) *IconAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *IconAPI) FilterBy(key string, value interface{}) *IconAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *IconAPI) FilterMultiBy(key string, value interface{}) *IconAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *IconAPI) WithNameLike(name string) *IconAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *IconAPI) WithTag(tag string) *IconAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *IconAPI) WithTags(tags []string) *IconAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *IconAPI) WithSizeGib(size int) *IconAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// WithSharedScope 公開スコープ条件
func (api *IconAPI) WithSharedScope() *IconAPI {
	api.FilterBy("Scope", "shared")
	return api
}

// WithUserScope ユーザースコープ条件
func (api *IconAPI) WithUserScope() *IconAPI {
	api.FilterBy("Scope", "user")
	return api
}

// SortBy 指定キーでのソート
func (api *IconAPI) SortBy(key string, reverse bool) *IconAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *IconAPI) SortByName(reverse bool) *IconAPI {
	api.sortByName(reverse)
	return api
}

// func (api *IconAPI) SortBySize(reverse bool) *IconAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *IconAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *IconAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *IconAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *IconAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *IconAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *IconAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *IconAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *IconAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *IconAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *IconAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *IconAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// SetSharedScope 公開スコープ条件
func (api *IconAPI) SetSharedScope() {
	api.FilterBy("Scope", "shared")
}

// SetUserScope ユーザースコープ条件
func (api *IconAPI) SetUserScope() {
	api.FilterBy("Scope", "user")
}

// SetSortBy 指定キーでのソート
func (api *IconAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *IconAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *IconAPI) SortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// New 新規作成用パラメーター作成
func (api *IconAPI) New() *sacloud.Icon {
	return &sacloud.Icon{}
}

// Create 新規作成
func (api *IconAPI) Create(value *sacloud.Icon) (*sacloud.Icon, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.create(api.createRequest(value), res)
	})
}

// Read 読み取り
func (api *IconAPI) Read(id int64) (*sacloud.Icon, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// Update 更新
func (api *IconAPI) Update(id int64, value *sacloud.Icon) (*sacloud.Icon, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.update(id, api.createRequest(value), res)
	})
}

// Delete 削除
func (api *IconAPI) Delete(id int64) (*sacloud.Icon, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.delete(id, nil, res)
	})
}

/************************************************
  Inner functions
************************************************/

func (api *IconAPI) setStateValue(setFunc func(*sacloud.Request)) *IconAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *IconAPI) request(f func(*sacloud.Response) error) (*sacloud.Icon, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.Icon, nil
}

func (api *IconAPI) createRequest(value *sacloud.Icon) *sacloud.Request {
	req := &sacloud.Request{}
	req.Icon = value
	return req
}
