package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeQuota invokes the airec.DescribeQuota API synchronously
// api document: https://help.aliyun.com/api/airec/describequota.html
func (client *Client) DescribeQuota(request *DescribeQuotaRequest) (response *DescribeQuotaResponse, err error) {
	response = CreateDescribeQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeQuotaWithChan invokes the airec.DescribeQuota API asynchronously
// api document: https://help.aliyun.com/api/airec/describequota.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeQuotaWithChan(request *DescribeQuotaRequest) (<-chan *DescribeQuotaResponse, <-chan error) {
	responseChan := make(chan *DescribeQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeQuotaWithCallback invokes the airec.DescribeQuota API asynchronously
// api document: https://help.aliyun.com/api/airec/describequota.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeQuotaWithCallback(request *DescribeQuotaRequest, callback func(response *DescribeQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeQuotaResponse
		var err error
		defer close(result)
		response, err = client.DescribeQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeQuotaRequest is the request struct for api DescribeQuota
type DescribeQuotaRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DescribeQuotaResponse is the response struct for api DescribeQuota
type DescribeQuotaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeQuotaRequest creates a request to invoke DescribeQuota API
func CreateDescribeQuotaRequest() (request *DescribeQuotaRequest) {
	request = &DescribeQuotaRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "DescribeQuota", "/openapi/instances/[InstanceId]/quota", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeQuotaResponse creates a response to parse from DescribeQuota response
func CreateDescribeQuotaResponse() (response *DescribeQuotaResponse) {
	response = &DescribeQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
