package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGtmAddressPool invokes the alidns.DeleteGtmAddressPool API synchronously
// api document: https://help.aliyun.com/api/alidns/deletegtmaddresspool.html
func (client *Client) DeleteGtmAddressPool(request *DeleteGtmAddressPoolRequest) (response *DeleteGtmAddressPoolResponse, err error) {
	response = CreateDeleteGtmAddressPoolResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGtmAddressPoolWithChan invokes the alidns.DeleteGtmAddressPool API asynchronously
// api document: https://help.aliyun.com/api/alidns/deletegtmaddresspool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteGtmAddressPoolWithChan(request *DeleteGtmAddressPoolRequest) (<-chan *DeleteGtmAddressPoolResponse, <-chan error) {
	responseChan := make(chan *DeleteGtmAddressPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGtmAddressPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGtmAddressPoolWithCallback invokes the alidns.DeleteGtmAddressPool API asynchronously
// api document: https://help.aliyun.com/api/alidns/deletegtmaddresspool.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteGtmAddressPoolWithCallback(request *DeleteGtmAddressPoolRequest, callback func(response *DeleteGtmAddressPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGtmAddressPoolResponse
		var err error
		defer close(result)
		response, err = client.DeleteGtmAddressPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGtmAddressPoolRequest is the request struct for api DeleteGtmAddressPool
type DeleteGtmAddressPoolRequest struct {
	*requests.RpcRequest
	AddrPoolId   string `position:"Query" name:"AddrPoolId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DeleteGtmAddressPoolResponse is the response struct for api DeleteGtmAddressPool
type DeleteGtmAddressPoolResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteGtmAddressPoolRequest creates a request to invoke DeleteGtmAddressPool API
func CreateDeleteGtmAddressPoolRequest() (request *DeleteGtmAddressPoolRequest) {
	request = &DeleteGtmAddressPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DeleteGtmAddressPool", "Alidns", "openAPI")
	return
}

// CreateDeleteGtmAddressPoolResponse creates a response to parse from DeleteGtmAddressPool response
func CreateDeleteGtmAddressPoolResponse() (response *DeleteGtmAddressPoolResponse) {
	response = &DeleteGtmAddressPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
