package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSearch invokes the cr.GetSearch API synchronously
// api document: https://help.aliyun.com/api/cr/getsearch.html
func (client *Client) GetSearch(request *GetSearchRequest) (response *GetSearchResponse, err error) {
	response = CreateGetSearchResponse()
	err = client.DoAction(request, response)
	return
}

// GetSearchWithChan invokes the cr.GetSearch API asynchronously
// api document: https://help.aliyun.com/api/cr/getsearch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSearchWithChan(request *GetSearchRequest) (<-chan *GetSearchResponse, <-chan error) {
	responseChan := make(chan *GetSearchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSearch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSearchWithCallback invokes the cr.GetSearch API asynchronously
// api document: https://help.aliyun.com/api/cr/getsearch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSearchWithCallback(request *GetSearchRequest, callback func(response *GetSearchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSearchResponse
		var err error
		defer close(result)
		response, err = client.GetSearch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSearchRequest is the request struct for api GetSearch
type GetSearchRequest struct {
	*requests.RoaRequest
	Origin   string           `position:"Query" name:"Origin"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	Page     requests.Integer `position:"Query" name:"Page"`
	Keyword  string           `position:"Query" name:"Keyword"`
}

// GetSearchResponse is the response struct for api GetSearch
type GetSearchResponse struct {
	*responses.BaseResponse
}

// CreateGetSearchRequest creates a request to invoke GetSearch API
func CreateGetSearchRequest() (request *GetSearchRequest) {
	request = &GetSearchRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetSearch", "/search-delete", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetSearchResponse creates a response to parse from GetSearch response
func CreateGetSearchResponse() (response *GetSearchResponse) {
	response = &GetSearchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
