package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNavSubTree invokes the emr.ListNavSubTree API synchronously
// api document: https://help.aliyun.com/api/emr/listnavsubtree.html
func (client *Client) ListNavSubTree(request *ListNavSubTreeRequest) (response *ListNavSubTreeResponse, err error) {
	response = CreateListNavSubTreeResponse()
	err = client.DoAction(request, response)
	return
}

// ListNavSubTreeWithChan invokes the emr.ListNavSubTree API asynchronously
// api document: https://help.aliyun.com/api/emr/listnavsubtree.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNavSubTreeWithChan(request *ListNavSubTreeRequest) (<-chan *ListNavSubTreeResponse, <-chan error) {
	responseChan := make(chan *ListNavSubTreeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNavSubTree(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNavSubTreeWithCallback invokes the emr.ListNavSubTree API asynchronously
// api document: https://help.aliyun.com/api/emr/listnavsubtree.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNavSubTreeWithCallback(request *ListNavSubTreeRequest, callback func(response *ListNavSubTreeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNavSubTreeResponse
		var err error
		defer close(result)
		response, err = client.ListNavSubTree(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNavSubTreeRequest is the request struct for api ListNavSubTree
type ListNavSubTreeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Name            string           `position:"Query" name:"Name"`
	Type            string           `position:"Query" name:"Type"`
	ProjectId       string           `position:"Query" name:"ProjectId"`
	ParentId        string           `position:"Query" name:"ParentId"`
}

// ListNavSubTreeResponse is the response struct for api ListNavSubTree
type ListNavSubTreeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateListNavSubTreeRequest creates a request to invoke ListNavSubTree API
func CreateListNavSubTreeRequest() (request *ListNavSubTreeRequest) {
	request = &ListNavSubTreeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListNavSubTree", "emr", "openAPI")
	return
}

// CreateListNavSubTreeResponse creates a response to parse from ListNavSubTree response
func CreateListNavSubTreeResponse() (response *ListNavSubTreeResponse) {
	response = &ListNavSubTreeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
