package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSmartAccessGateways invokes the smartag.DescribeSmartAccessGateways API synchronously
// api document: https://help.aliyun.com/api/smartag/describesmartaccessgateways.html
func (client *Client) DescribeSmartAccessGateways(request *DescribeSmartAccessGatewaysRequest) (response *DescribeSmartAccessGatewaysResponse, err error) {
	response = CreateDescribeSmartAccessGatewaysResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSmartAccessGatewaysWithChan invokes the smartag.DescribeSmartAccessGateways API asynchronously
// api document: https://help.aliyun.com/api/smartag/describesmartaccessgateways.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSmartAccessGatewaysWithChan(request *DescribeSmartAccessGatewaysRequest) (<-chan *DescribeSmartAccessGatewaysResponse, <-chan error) {
	responseChan := make(chan *DescribeSmartAccessGatewaysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSmartAccessGateways(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSmartAccessGatewaysWithCallback invokes the smartag.DescribeSmartAccessGateways API asynchronously
// api document: https://help.aliyun.com/api/smartag/describesmartaccessgateways.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSmartAccessGatewaysWithCallback(request *DescribeSmartAccessGatewaysRequest, callback func(response *DescribeSmartAccessGatewaysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSmartAccessGatewaysResponse
		var err error
		defer close(result)
		response, err = client.DescribeSmartAccessGateways(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSmartAccessGatewaysRequest is the request struct for api DescribeSmartAccessGateways
type DescribeSmartAccessGatewaysRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SerialNumber         string           `position:"Query" name:"SerialNumber"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	AclIds               string           `position:"Query" name:"AclIds"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	AssociatedCcnId      string           `position:"Query" name:"AssociatedCcnId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	UnboundAclIds        string           `position:"Query" name:"UnboundAclIds"`
	PageNumber           string           `position:"Query" name:"PageNumber"`
	Name                 string           `position:"Query" name:"Name"`
	PageSize             string           `position:"Query" name:"PageSize"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	InstanceType         string           `position:"Query" name:"InstanceType"`
	Status               string           `position:"Query" name:"Status"`
}

// DescribeSmartAccessGatewaysResponse is the response struct for api DescribeSmartAccessGateways
type DescribeSmartAccessGatewaysResponse struct {
	*responses.BaseResponse
	RequestId           string                                           `json:"RequestId" xml:"RequestId"`
	TotalCount          int                                              `json:"TotalCount" xml:"TotalCount"`
	PageNumber          int                                              `json:"PageNumber" xml:"PageNumber"`
	PageSize            int                                              `json:"PageSize" xml:"PageSize"`
	SmartAccessGateways SmartAccessGatewaysInDescribeSmartAccessGateways `json:"SmartAccessGateways" xml:"SmartAccessGateways"`
}

// CreateDescribeSmartAccessGatewaysRequest creates a request to invoke DescribeSmartAccessGateways API
func CreateDescribeSmartAccessGatewaysRequest() (request *DescribeSmartAccessGatewaysRequest) {
	request = &DescribeSmartAccessGatewaysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSmartAccessGateways", "smartag", "openAPI")
	return
}

// CreateDescribeSmartAccessGatewaysResponse creates a response to parse from DescribeSmartAccessGateways response
func CreateDescribeSmartAccessGatewaysResponse() (response *DescribeSmartAccessGatewaysResponse) {
	response = &DescribeSmartAccessGatewaysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
