package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeServerRelatedGlobalAccelerationInstances invokes the vpc.DescribeServerRelatedGlobalAccelerationInstances API synchronously
// api document: https://help.aliyun.com/api/vpc/describeserverrelatedglobalaccelerationinstances.html
func (client *Client) DescribeServerRelatedGlobalAccelerationInstances(request *DescribeServerRelatedGlobalAccelerationInstancesRequest) (response *DescribeServerRelatedGlobalAccelerationInstancesResponse, err error) {
	response = CreateDescribeServerRelatedGlobalAccelerationInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeServerRelatedGlobalAccelerationInstancesWithChan invokes the vpc.DescribeServerRelatedGlobalAccelerationInstances API asynchronously
// api document: https://help.aliyun.com/api/vpc/describeserverrelatedglobalaccelerationinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeServerRelatedGlobalAccelerationInstancesWithChan(request *DescribeServerRelatedGlobalAccelerationInstancesRequest) (<-chan *DescribeServerRelatedGlobalAccelerationInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeServerRelatedGlobalAccelerationInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeServerRelatedGlobalAccelerationInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeServerRelatedGlobalAccelerationInstancesWithCallback invokes the vpc.DescribeServerRelatedGlobalAccelerationInstances API asynchronously
// api document: https://help.aliyun.com/api/vpc/describeserverrelatedglobalaccelerationinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeServerRelatedGlobalAccelerationInstancesWithCallback(request *DescribeServerRelatedGlobalAccelerationInstancesRequest, callback func(response *DescribeServerRelatedGlobalAccelerationInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeServerRelatedGlobalAccelerationInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeServerRelatedGlobalAccelerationInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeServerRelatedGlobalAccelerationInstancesRequest is the request struct for api DescribeServerRelatedGlobalAccelerationInstances
type DescribeServerRelatedGlobalAccelerationInstancesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ServerType           string           `position:"Query" name:"ServerType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ServerId             string           `position:"Query" name:"ServerId"`
}

// DescribeServerRelatedGlobalAccelerationInstancesResponse is the response struct for api DescribeServerRelatedGlobalAccelerationInstances
type DescribeServerRelatedGlobalAccelerationInstancesResponse struct {
	*responses.BaseResponse
	RequestId                   string                                                                        `json:"RequestId" xml:"RequestId"`
	GlobalAccelerationInstances GlobalAccelerationInstancesInDescribeServerRelatedGlobalAccelerationInstances `json:"GlobalAccelerationInstances" xml:"GlobalAccelerationInstances"`
}

// CreateDescribeServerRelatedGlobalAccelerationInstancesRequest creates a request to invoke DescribeServerRelatedGlobalAccelerationInstances API
func CreateDescribeServerRelatedGlobalAccelerationInstancesRequest() (request *DescribeServerRelatedGlobalAccelerationInstancesRequest) {
	request = &DescribeServerRelatedGlobalAccelerationInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeServerRelatedGlobalAccelerationInstances", "vpc", "openAPI")
	return
}

// CreateDescribeServerRelatedGlobalAccelerationInstancesResponse creates a response to parse from DescribeServerRelatedGlobalAccelerationInstances response
func CreateDescribeServerRelatedGlobalAccelerationInstancesResponse() (response *DescribeServerRelatedGlobalAccelerationInstancesResponse) {
	response = &DescribeServerRelatedGlobalAccelerationInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
