package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDVOrderAudit invokes the cas.CreateDVOrderAudit API synchronously
// api document: https://help.aliyun.com/api/cas/createdvorderaudit.html
func (client *Client) CreateDVOrderAudit(request *CreateDVOrderAuditRequest) (response *CreateDVOrderAuditResponse, err error) {
	response = CreateCreateDVOrderAuditResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDVOrderAuditWithChan invokes the cas.CreateDVOrderAudit API asynchronously
// api document: https://help.aliyun.com/api/cas/createdvorderaudit.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDVOrderAuditWithChan(request *CreateDVOrderAuditRequest) (<-chan *CreateDVOrderAuditResponse, <-chan error) {
	responseChan := make(chan *CreateDVOrderAuditResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDVOrderAudit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDVOrderAuditWithCallback invokes the cas.CreateDVOrderAudit API asynchronously
// api document: https://help.aliyun.com/api/cas/createdvorderaudit.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDVOrderAuditWithCallback(request *CreateDVOrderAuditRequest, callback func(response *CreateDVOrderAuditResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDVOrderAuditResponse
		var err error
		defer close(result)
		response, err = client.CreateDVOrderAudit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDVOrderAuditRequest is the request struct for api CreateDVOrderAudit
type CreateDVOrderAuditRequest struct {
	*requests.RpcRequest
	InstanceId       string `position:"Query" name:"InstanceId"`
	SourceIp         string `position:"Query" name:"SourceIp"`
	Province         string `position:"Query" name:"Province"`
	City             string `position:"Query" name:"City"`
	Domain           string `position:"Query" name:"Domain"`
	DomainVerifyType string `position:"Query" name:"DomainVerifyType"`
	Mobile           string `position:"Query" name:"Mobile"`
	Lang             string `position:"Query" name:"Lang"`
	Email            string `position:"Query" name:"Email"`
	Username         string `position:"Query" name:"Username"`
}

// CreateDVOrderAuditResponse is the response struct for api CreateDVOrderAudit
type CreateDVOrderAuditResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateDVOrderAuditRequest creates a request to invoke CreateDVOrderAudit API
func CreateCreateDVOrderAuditRequest() (request *CreateDVOrderAuditRequest) {
	request = &CreateDVOrderAuditRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2018-07-13", "CreateDVOrderAudit", "cas", "openAPI")
	return
}

// CreateCreateDVOrderAuditResponse creates a response to parse from CreateDVOrderAudit response
func CreateCreateDVOrderAuditResponse() (response *CreateDVOrderAuditResponse) {
	response = &CreateDVOrderAuditResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
