package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TwoPartiesCall invokes the ccc.TwoPartiesCall API synchronously
// api document: https://help.aliyun.com/api/ccc/twopartiescall.html
func (client *Client) TwoPartiesCall(request *TwoPartiesCallRequest) (response *TwoPartiesCallResponse, err error) {
	response = CreateTwoPartiesCallResponse()
	err = client.DoAction(request, response)
	return
}

// TwoPartiesCallWithChan invokes the ccc.TwoPartiesCall API asynchronously
// api document: https://help.aliyun.com/api/ccc/twopartiescall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TwoPartiesCallWithChan(request *TwoPartiesCallRequest) (<-chan *TwoPartiesCallResponse, <-chan error) {
	responseChan := make(chan *TwoPartiesCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TwoPartiesCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TwoPartiesCallWithCallback invokes the ccc.TwoPartiesCall API asynchronously
// api document: https://help.aliyun.com/api/ccc/twopartiescall.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TwoPartiesCallWithCallback(request *TwoPartiesCallRequest, callback func(response *TwoPartiesCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TwoPartiesCallResponse
		var err error
		defer close(result)
		response, err = client.TwoPartiesCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TwoPartiesCallRequest is the request struct for api TwoPartiesCall
type TwoPartiesCallRequest struct {
	*requests.RpcRequest
	Caller         string `position:"Query" name:"Caller"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	CalleeCustomer string `position:"Query" name:"CalleeCustomer"`
	CalleeAgent    string `position:"Query" name:"CalleeAgent"`
}

// TwoPartiesCallResponse is the response struct for api TwoPartiesCall
type TwoPartiesCallResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	StatusCode     string `json:"StatusCode" xml:"StatusCode"`
	StatusDesc     string `json:"StatusDesc" xml:"StatusDesc"`
	TaskId         string `json:"TaskId" xml:"TaskId"`
	TimeStamp      string `json:"TimeStamp" xml:"TimeStamp"`
}

// CreateTwoPartiesCallRequest creates a request to invoke TwoPartiesCall API
func CreateTwoPartiesCallRequest() (request *TwoPartiesCallRequest) {
	request = &TwoPartiesCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "TwoPartiesCall", "", "")
	return
}

// CreateTwoPartiesCallResponse creates a response to parse from TwoPartiesCall response
func CreateTwoPartiesCallResponse() (response *TwoPartiesCallResponse) {
	response = &TwoPartiesCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
