package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnDomainOriginBpsData invokes the scdn.DescribeScdnDomainOriginBpsData API synchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainoriginbpsdata.html
func (client *Client) DescribeScdnDomainOriginBpsData(request *DescribeScdnDomainOriginBpsDataRequest) (response *DescribeScdnDomainOriginBpsDataResponse, err error) {
	response = CreateDescribeScdnDomainOriginBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnDomainOriginBpsDataWithChan invokes the scdn.DescribeScdnDomainOriginBpsData API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainoriginbpsdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnDomainOriginBpsDataWithChan(request *DescribeScdnDomainOriginBpsDataRequest) (<-chan *DescribeScdnDomainOriginBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnDomainOriginBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnDomainOriginBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnDomainOriginBpsDataWithCallback invokes the scdn.DescribeScdnDomainOriginBpsData API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainoriginbpsdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnDomainOriginBpsDataWithCallback(request *DescribeScdnDomainOriginBpsDataRequest, callback func(response *DescribeScdnDomainOriginBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnDomainOriginBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnDomainOriginBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnDomainOriginBpsDataRequest is the request struct for api DescribeScdnDomainOriginBpsData
type DescribeScdnDomainOriginBpsDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Interval   string           `position:"Query" name:"Interval"`
}

// DescribeScdnDomainOriginBpsDataResponse is the response struct for api DescribeScdnDomainOriginBpsData
type DescribeScdnDomainOriginBpsDataResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	DomainName               string                   `json:"DomainName" xml:"DomainName"`
	StartTime                string                   `json:"StartTime" xml:"StartTime"`
	EndTime                  string                   `json:"EndTime" xml:"EndTime"`
	DataInterval             string                   `json:"DataInterval" xml:"DataInterval"`
	OriginBpsDataPerInterval OriginBpsDataPerInterval `json:"OriginBpsDataPerInterval" xml:"OriginBpsDataPerInterval"`
}

// CreateDescribeScdnDomainOriginBpsDataRequest creates a request to invoke DescribeScdnDomainOriginBpsData API
func CreateDescribeScdnDomainOriginBpsDataRequest() (request *DescribeScdnDomainOriginBpsDataRequest) {
	request = &DescribeScdnDomainOriginBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnDomainOriginBpsData", "scdn", "openAPI")
	return
}

// CreateDescribeScdnDomainOriginBpsDataResponse creates a response to parse from DescribeScdnDomainOriginBpsData response
func CreateDescribeScdnDomainOriginBpsDataResponse() (response *DescribeScdnDomainOriginBpsDataResponse) {
	response = &DescribeScdnDomainOriginBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
