// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1/autoscaling_policies.proto

package dataproc

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Describes an autoscaling policy for Dataproc cluster autoscaler.
type AutoscalingPolicy struct {
	// Required. The policy id.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). Cannot begin or end with underscore
	// or hyphen. Must consist of between 3 and 50 characters.
	//
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The "resource name" of the autoscaling policy, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies`, the resource name of the
	//   policy has the following format:
	//   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
	//
	// * For `projects.locations.autoscalingPolicies`, the resource name of the
	//   policy has the following format:
	//   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Autoscaling algorithm for policy.
	//
	// Types that are valid to be assigned to Algorithm:
	//	*AutoscalingPolicy_BasicAlgorithm
	Algorithm isAutoscalingPolicy_Algorithm `protobuf_oneof:"algorithm"`
	// Required. Describes how the autoscaler will operate for primary workers.
	WorkerConfig *InstanceGroupAutoscalingPolicyConfig `protobuf:"bytes,4,opt,name=worker_config,json=workerConfig,proto3" json:"worker_config,omitempty"`
	// Optional. Describes how the autoscaler will operate for secondary workers.
	SecondaryWorkerConfig *InstanceGroupAutoscalingPolicyConfig `protobuf:"bytes,5,opt,name=secondary_worker_config,json=secondaryWorkerConfig,proto3" json:"secondary_worker_config,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                              `json:"-"`
	XXX_unrecognized      []byte                                `json:"-"`
	XXX_sizecache         int32                                 `json:"-"`
}

func (m *AutoscalingPolicy) Reset()         { *m = AutoscalingPolicy{} }
func (m *AutoscalingPolicy) String() string { return proto.CompactTextString(m) }
func (*AutoscalingPolicy) ProtoMessage()    {}
func (*AutoscalingPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{0}
}

func (m *AutoscalingPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoscalingPolicy.Unmarshal(m, b)
}
func (m *AutoscalingPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoscalingPolicy.Marshal(b, m, deterministic)
}
func (m *AutoscalingPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoscalingPolicy.Merge(m, src)
}
func (m *AutoscalingPolicy) XXX_Size() int {
	return xxx_messageInfo_AutoscalingPolicy.Size(m)
}
func (m *AutoscalingPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoscalingPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_AutoscalingPolicy proto.InternalMessageInfo

func (m *AutoscalingPolicy) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AutoscalingPolicy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type isAutoscalingPolicy_Algorithm interface {
	isAutoscalingPolicy_Algorithm()
}

type AutoscalingPolicy_BasicAlgorithm struct {
	BasicAlgorithm *BasicAutoscalingAlgorithm `protobuf:"bytes,3,opt,name=basic_algorithm,json=basicAlgorithm,proto3,oneof"`
}

func (*AutoscalingPolicy_BasicAlgorithm) isAutoscalingPolicy_Algorithm() {}

func (m *AutoscalingPolicy) GetAlgorithm() isAutoscalingPolicy_Algorithm {
	if m != nil {
		return m.Algorithm
	}
	return nil
}

func (m *AutoscalingPolicy) GetBasicAlgorithm() *BasicAutoscalingAlgorithm {
	if x, ok := m.GetAlgorithm().(*AutoscalingPolicy_BasicAlgorithm); ok {
		return x.BasicAlgorithm
	}
	return nil
}

func (m *AutoscalingPolicy) GetWorkerConfig() *InstanceGroupAutoscalingPolicyConfig {
	if m != nil {
		return m.WorkerConfig
	}
	return nil
}

func (m *AutoscalingPolicy) GetSecondaryWorkerConfig() *InstanceGroupAutoscalingPolicyConfig {
	if m != nil {
		return m.SecondaryWorkerConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AutoscalingPolicy) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AutoscalingPolicy_BasicAlgorithm)(nil),
	}
}

// Basic algorithm for autoscaling.
type BasicAutoscalingAlgorithm struct {
	// Required. YARN autoscaling configuration.
	YarnConfig *BasicYarnAutoscalingConfig `protobuf:"bytes,1,opt,name=yarn_config,json=yarnConfig,proto3" json:"yarn_config,omitempty"`
	// Optional. Duration between scaling events. A scaling period starts after
	// the update operation from the previous event has completed.
	//
	// Bounds: [2m, 1d]. Default: 2m.
	CooldownPeriod       *duration.Duration `protobuf:"bytes,2,opt,name=cooldown_period,json=cooldownPeriod,proto3" json:"cooldown_period,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *BasicAutoscalingAlgorithm) Reset()         { *m = BasicAutoscalingAlgorithm{} }
func (m *BasicAutoscalingAlgorithm) String() string { return proto.CompactTextString(m) }
func (*BasicAutoscalingAlgorithm) ProtoMessage()    {}
func (*BasicAutoscalingAlgorithm) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{1}
}

func (m *BasicAutoscalingAlgorithm) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicAutoscalingAlgorithm.Unmarshal(m, b)
}
func (m *BasicAutoscalingAlgorithm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicAutoscalingAlgorithm.Marshal(b, m, deterministic)
}
func (m *BasicAutoscalingAlgorithm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicAutoscalingAlgorithm.Merge(m, src)
}
func (m *BasicAutoscalingAlgorithm) XXX_Size() int {
	return xxx_messageInfo_BasicAutoscalingAlgorithm.Size(m)
}
func (m *BasicAutoscalingAlgorithm) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicAutoscalingAlgorithm.DiscardUnknown(m)
}

var xxx_messageInfo_BasicAutoscalingAlgorithm proto.InternalMessageInfo

func (m *BasicAutoscalingAlgorithm) GetYarnConfig() *BasicYarnAutoscalingConfig {
	if m != nil {
		return m.YarnConfig
	}
	return nil
}

func (m *BasicAutoscalingAlgorithm) GetCooldownPeriod() *duration.Duration {
	if m != nil {
		return m.CooldownPeriod
	}
	return nil
}

// Basic autoscaling configurations for YARN.
type BasicYarnAutoscalingConfig struct {
	// Required. Timeout for YARN graceful decommissioning of Node Managers.
	// Specifies the duration to wait for jobs to complete before forcefully
	// removing workers (and potentially interrupting jobs). Only applicable to
	// downscaling operations.
	//
	// Bounds: [0s, 1d].
	GracefulDecommissionTimeout *duration.Duration `protobuf:"bytes,5,opt,name=graceful_decommission_timeout,json=gracefulDecommissionTimeout,proto3" json:"graceful_decommission_timeout,omitempty"`
	// Required. Fraction of average pending memory in the last cooldown period
	// for which to add workers. A scale-up factor of 1.0 will result in scaling
	// up so that there is no pending memory remaining after the update (more
	// aggressive scaling). A scale-up factor closer to 0 will result in a smaller
	// magnitude of scaling up (less aggressive scaling).
	//
	// Bounds: [0.0, 1.0].
	ScaleUpFactor float64 `protobuf:"fixed64,1,opt,name=scale_up_factor,json=scaleUpFactor,proto3" json:"scale_up_factor,omitempty"`
	// Required. Fraction of average pending memory in the last cooldown period
	// for which to remove workers. A scale-down factor of 1 will result in
	// scaling down so that there is no available memory remaining after the
	// update (more aggressive scaling). A scale-down factor of 0 disables
	// removing workers, which can be beneficial for autoscaling a single job.
	//
	// Bounds: [0.0, 1.0].
	ScaleDownFactor float64 `protobuf:"fixed64,2,opt,name=scale_down_factor,json=scaleDownFactor,proto3" json:"scale_down_factor,omitempty"`
	// Optional. Minimum scale-up threshold as a fraction of total cluster size
	// before scaling occurs. For example, in a 20-worker cluster, a threshold of
	// 0.1 means the autoscaler must recommend at least a 2-worker scale-up for
	// the cluster to scale. A threshold of 0 means the autoscaler will scale up
	// on any recommended change.
	//
	// Bounds: [0.0, 1.0]. Default: 0.0.
	ScaleUpMinWorkerFraction float64 `protobuf:"fixed64,3,opt,name=scale_up_min_worker_fraction,json=scaleUpMinWorkerFraction,proto3" json:"scale_up_min_worker_fraction,omitempty"`
	// Optional. Minimum scale-down threshold as a fraction of total cluster size
	// before scaling occurs. For example, in a 20-worker cluster, a threshold of
	// 0.1 means the autoscaler must recommend at least a 2 worker scale-down for
	// the cluster to scale. A threshold of 0 means the autoscaler will scale down
	// on any recommended change.
	//
	// Bounds: [0.0, 1.0]. Default: 0.0.
	ScaleDownMinWorkerFraction float64  `protobuf:"fixed64,4,opt,name=scale_down_min_worker_fraction,json=scaleDownMinWorkerFraction,proto3" json:"scale_down_min_worker_fraction,omitempty"`
	XXX_NoUnkeyedLiteral       struct{} `json:"-"`
	XXX_unrecognized           []byte   `json:"-"`
	XXX_sizecache              int32    `json:"-"`
}

func (m *BasicYarnAutoscalingConfig) Reset()         { *m = BasicYarnAutoscalingConfig{} }
func (m *BasicYarnAutoscalingConfig) String() string { return proto.CompactTextString(m) }
func (*BasicYarnAutoscalingConfig) ProtoMessage()    {}
func (*BasicYarnAutoscalingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{2}
}

func (m *BasicYarnAutoscalingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicYarnAutoscalingConfig.Unmarshal(m, b)
}
func (m *BasicYarnAutoscalingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicYarnAutoscalingConfig.Marshal(b, m, deterministic)
}
func (m *BasicYarnAutoscalingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicYarnAutoscalingConfig.Merge(m, src)
}
func (m *BasicYarnAutoscalingConfig) XXX_Size() int {
	return xxx_messageInfo_BasicYarnAutoscalingConfig.Size(m)
}
func (m *BasicYarnAutoscalingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicYarnAutoscalingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_BasicYarnAutoscalingConfig proto.InternalMessageInfo

func (m *BasicYarnAutoscalingConfig) GetGracefulDecommissionTimeout() *duration.Duration {
	if m != nil {
		return m.GracefulDecommissionTimeout
	}
	return nil
}

func (m *BasicYarnAutoscalingConfig) GetScaleUpFactor() float64 {
	if m != nil {
		return m.ScaleUpFactor
	}
	return 0
}

func (m *BasicYarnAutoscalingConfig) GetScaleDownFactor() float64 {
	if m != nil {
		return m.ScaleDownFactor
	}
	return 0
}

func (m *BasicYarnAutoscalingConfig) GetScaleUpMinWorkerFraction() float64 {
	if m != nil {
		return m.ScaleUpMinWorkerFraction
	}
	return 0
}

func (m *BasicYarnAutoscalingConfig) GetScaleDownMinWorkerFraction() float64 {
	if m != nil {
		return m.ScaleDownMinWorkerFraction
	}
	return 0
}

// Configuration for the size bounds of an instance group, including its
// proportional size to other groups.
type InstanceGroupAutoscalingPolicyConfig struct {
	// Optional. Minimum number of instances for this group.
	//
	// Primary workers - Bounds: [2, max_instances]. Default: 2.
	// Secondary workers - Bounds: [0, max_instances]. Default: 0.
	MinInstances int32 `protobuf:"varint,1,opt,name=min_instances,json=minInstances,proto3" json:"min_instances,omitempty"`
	// Required. Maximum number of instances for this group. Required for primary
	// workers. Note that by default, clusters will not use secondary workers.
	// Required for secondary workers if the minimum secondary instances is set.
	//
	// Primary workers - Bounds: [min_instances, ).
	// Secondary workers - Bounds: [min_instances, ). Default: 0.
	MaxInstances int32 `protobuf:"varint,2,opt,name=max_instances,json=maxInstances,proto3" json:"max_instances,omitempty"`
	// Optional. Weight for the instance group, which is used to determine the
	// fraction of total workers in the cluster from this instance group.
	// For example, if primary workers have weight 2, and secondary workers have
	// weight 1, the cluster will have approximately 2 primary workers for each
	// secondary worker.
	//
	// The cluster may not reach the specified balance if constrained
	// by min/max bounds or other autoscaling settings. For example, if
	// `max_instances` for secondary workers is 0, then only primary workers will
	// be added. The cluster can also be out of balance when created.
	//
	// If weight is not set on any instance group, the cluster will default to
	// equal weight for all groups: the cluster will attempt to maintain an equal
	// number of workers in each group within the configured size bounds for each
	// group. If weight is set for one group only, the cluster will default to
	// zero weight on the unset group. For example if weight is set only on
	// primary workers, the cluster will use primary workers only and no
	// secondary workers.
	Weight               int32    `protobuf:"varint,3,opt,name=weight,proto3" json:"weight,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InstanceGroupAutoscalingPolicyConfig) Reset()         { *m = InstanceGroupAutoscalingPolicyConfig{} }
func (m *InstanceGroupAutoscalingPolicyConfig) String() string { return proto.CompactTextString(m) }
func (*InstanceGroupAutoscalingPolicyConfig) ProtoMessage()    {}
func (*InstanceGroupAutoscalingPolicyConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{3}
}

func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Unmarshal(m, b)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Marshal(b, m, deterministic)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Merge(m, src)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_Size() int {
	return xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.Size(m)
}
func (m *InstanceGroupAutoscalingPolicyConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceGroupAutoscalingPolicyConfig proto.InternalMessageInfo

func (m *InstanceGroupAutoscalingPolicyConfig) GetMinInstances() int32 {
	if m != nil {
		return m.MinInstances
	}
	return 0
}

func (m *InstanceGroupAutoscalingPolicyConfig) GetMaxInstances() int32 {
	if m != nil {
		return m.MaxInstances
	}
	return 0
}

func (m *InstanceGroupAutoscalingPolicyConfig) GetWeight() int32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

// A request to create an autoscaling policy.
type CreateAutoscalingPolicyRequest struct {
	// Required. The "resource name" of the region or location, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.create`, the resource name
	//   of the region has the following format:
	//   `projects/{project_id}/regions/{region}`
	//
	// * For `projects.locations.autoscalingPolicies.create`, the resource name
	//   of the location has the following format:
	//   `projects/{project_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The autoscaling policy to create.
	Policy               *AutoscalingPolicy `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *CreateAutoscalingPolicyRequest) Reset()         { *m = CreateAutoscalingPolicyRequest{} }
func (m *CreateAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAutoscalingPolicyRequest) ProtoMessage()    {}
func (*CreateAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{4}
}

func (m *CreateAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *CreateAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *CreateAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAutoscalingPolicyRequest.Merge(m, src)
}
func (m *CreateAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAutoscalingPolicyRequest.Size(m)
}
func (m *CreateAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *CreateAutoscalingPolicyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAutoscalingPolicyRequest) GetPolicy() *AutoscalingPolicy {
	if m != nil {
		return m.Policy
	}
	return nil
}

// A request to fetch an autoscaling policy.
type GetAutoscalingPolicyRequest struct {
	// Required. The "resource name" of the autoscaling policy, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.get`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
	//
	// * For `projects.locations.autoscalingPolicies.get`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAutoscalingPolicyRequest) Reset()         { *m = GetAutoscalingPolicyRequest{} }
func (m *GetAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*GetAutoscalingPolicyRequest) ProtoMessage()    {}
func (*GetAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{5}
}

func (m *GetAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *GetAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *GetAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAutoscalingPolicyRequest.Merge(m, src)
}
func (m *GetAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_GetAutoscalingPolicyRequest.Size(m)
}
func (m *GetAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *GetAutoscalingPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to update an autoscaling policy.
type UpdateAutoscalingPolicyRequest struct {
	// Required. The updated autoscaling policy.
	Policy               *AutoscalingPolicy `protobuf:"bytes,1,opt,name=policy,proto3" json:"policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *UpdateAutoscalingPolicyRequest) Reset()         { *m = UpdateAutoscalingPolicyRequest{} }
func (m *UpdateAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateAutoscalingPolicyRequest) ProtoMessage()    {}
func (*UpdateAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{6}
}

func (m *UpdateAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateAutoscalingPolicyRequest.Merge(m, src)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateAutoscalingPolicyRequest.Size(m)
}
func (m *UpdateAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *UpdateAutoscalingPolicyRequest) GetPolicy() *AutoscalingPolicy {
	if m != nil {
		return m.Policy
	}
	return nil
}

// A request to delete an autoscaling policy.
//
// Autoscaling policies in use by one or more clusters will not be deleted.
type DeleteAutoscalingPolicyRequest struct {
	// Required. The "resource name" of the autoscaling policy, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.delete`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id}`
	//
	// * For `projects.locations.autoscalingPolicies.delete`, the resource name
	//   of the policy has the following format:
	//   `projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAutoscalingPolicyRequest) Reset()         { *m = DeleteAutoscalingPolicyRequest{} }
func (m *DeleteAutoscalingPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAutoscalingPolicyRequest) ProtoMessage()    {}
func (*DeleteAutoscalingPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{7}
}

func (m *DeleteAutoscalingPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAutoscalingPolicyRequest.Unmarshal(m, b)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAutoscalingPolicyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAutoscalingPolicyRequest.Merge(m, src)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAutoscalingPolicyRequest.Size(m)
}
func (m *DeleteAutoscalingPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAutoscalingPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAutoscalingPolicyRequest proto.InternalMessageInfo

func (m *DeleteAutoscalingPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to list autoscaling policies in a project.
type ListAutoscalingPoliciesRequest struct {
	// Required. The "resource name" of the region or location, as described
	// in https://cloud.google.com/apis/design/resource_names.
	//
	// * For `projects.regions.autoscalingPolicies.list`, the resource name
	//   of the region has the following format:
	//   `projects/{project_id}/regions/{region}`
	//
	// * For `projects.locations.autoscalingPolicies.list`, the resource name
	//   of the location has the following format:
	//   `projects/{project_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return in each response.
	// Must be less than or equal to 1000. Defaults to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, returned by a previous call, to request the
	// next page of results.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAutoscalingPoliciesRequest) Reset()         { *m = ListAutoscalingPoliciesRequest{} }
func (m *ListAutoscalingPoliciesRequest) String() string { return proto.CompactTextString(m) }
func (*ListAutoscalingPoliciesRequest) ProtoMessage()    {}
func (*ListAutoscalingPoliciesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{8}
}

func (m *ListAutoscalingPoliciesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAutoscalingPoliciesRequest.Unmarshal(m, b)
}
func (m *ListAutoscalingPoliciesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAutoscalingPoliciesRequest.Marshal(b, m, deterministic)
}
func (m *ListAutoscalingPoliciesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAutoscalingPoliciesRequest.Merge(m, src)
}
func (m *ListAutoscalingPoliciesRequest) XXX_Size() int {
	return xxx_messageInfo_ListAutoscalingPoliciesRequest.Size(m)
}
func (m *ListAutoscalingPoliciesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAutoscalingPoliciesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAutoscalingPoliciesRequest proto.InternalMessageInfo

func (m *ListAutoscalingPoliciesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAutoscalingPoliciesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAutoscalingPoliciesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// A response to a request to list autoscaling policies in a project.
type ListAutoscalingPoliciesResponse struct {
	// Output only. Autoscaling policies list.
	Policies []*AutoscalingPolicy `protobuf:"bytes,1,rep,name=policies,proto3" json:"policies,omitempty"`
	// Output only. This token is included in the response if there are more
	// results to fetch.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAutoscalingPoliciesResponse) Reset()         { *m = ListAutoscalingPoliciesResponse{} }
func (m *ListAutoscalingPoliciesResponse) String() string { return proto.CompactTextString(m) }
func (*ListAutoscalingPoliciesResponse) ProtoMessage()    {}
func (*ListAutoscalingPoliciesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e49a4a9859d08ad9, []int{9}
}

func (m *ListAutoscalingPoliciesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAutoscalingPoliciesResponse.Unmarshal(m, b)
}
func (m *ListAutoscalingPoliciesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAutoscalingPoliciesResponse.Marshal(b, m, deterministic)
}
func (m *ListAutoscalingPoliciesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAutoscalingPoliciesResponse.Merge(m, src)
}
func (m *ListAutoscalingPoliciesResponse) XXX_Size() int {
	return xxx_messageInfo_ListAutoscalingPoliciesResponse.Size(m)
}
func (m *ListAutoscalingPoliciesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAutoscalingPoliciesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAutoscalingPoliciesResponse proto.InternalMessageInfo

func (m *ListAutoscalingPoliciesResponse) GetPolicies() []*AutoscalingPolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *ListAutoscalingPoliciesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*AutoscalingPolicy)(nil), "google.cloud.dataproc.v1.AutoscalingPolicy")
	proto.RegisterType((*BasicAutoscalingAlgorithm)(nil), "google.cloud.dataproc.v1.BasicAutoscalingAlgorithm")
	proto.RegisterType((*BasicYarnAutoscalingConfig)(nil), "google.cloud.dataproc.v1.BasicYarnAutoscalingConfig")
	proto.RegisterType((*InstanceGroupAutoscalingPolicyConfig)(nil), "google.cloud.dataproc.v1.InstanceGroupAutoscalingPolicyConfig")
	proto.RegisterType((*CreateAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1.CreateAutoscalingPolicyRequest")
	proto.RegisterType((*GetAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1.GetAutoscalingPolicyRequest")
	proto.RegisterType((*UpdateAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1.UpdateAutoscalingPolicyRequest")
	proto.RegisterType((*DeleteAutoscalingPolicyRequest)(nil), "google.cloud.dataproc.v1.DeleteAutoscalingPolicyRequest")
	proto.RegisterType((*ListAutoscalingPoliciesRequest)(nil), "google.cloud.dataproc.v1.ListAutoscalingPoliciesRequest")
	proto.RegisterType((*ListAutoscalingPoliciesResponse)(nil), "google.cloud.dataproc.v1.ListAutoscalingPoliciesResponse")
}

func init() {
	proto.RegisterFile("google/cloud/dataproc/v1/autoscaling_policies.proto", fileDescriptor_e49a4a9859d08ad9)
}

var fileDescriptor_e49a4a9859d08ad9 = []byte{
	// 1241 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x57, 0x41, 0x6f, 0xdc, 0x44,
	0x14, 0x66, 0x9c, 0x34, 0x6a, 0x26, 0x4d, 0xab, 0x8e, 0x80, 0xdd, 0x6e, 0xca, 0x36, 0x32, 0x1c,
	0x4a, 0x0a, 0x6b, 0xb5, 0xa5, 0x2a, 0x14, 0x28, 0x38, 0x49, 0x9b, 0x56, 0x14, 0x69, 0xe5, 0xb6,
	0x42, 0xe4, 0x62, 0x4d, 0xec, 0x59, 0x67, 0x5a, 0xdb, 0x63, 0xc6, 0xb3, 0xd9, 0xa6, 0x51, 0x84,
	0xe8, 0x2f, 0x40, 0x70, 0x40, 0x48, 0x3d, 0x20, 0x71, 0x47, 0xf0, 0x0f, 0x38, 0x70, 0x82, 0x03,
	0x12, 0xdc, 0x7a, 0xea, 0x01, 0x09, 0xa9, 0xea, 0x2f, 0x80, 0x0b, 0xf2, 0xcc, 0xd8, 0xeb, 0x76,
	0xd7, 0x6e, 0x36, 0x2a, 0xa7, 0xf5, 0xce, 0x7b, 0xef, 0x7b, 0xef, 0x7d, 0xf3, 0xbd, 0x19, 0x1b,
	0x9e, 0x0d, 0x18, 0x0b, 0x42, 0x62, 0x79, 0x21, 0xeb, 0xfb, 0x96, 0x8f, 0x05, 0x4e, 0x38, 0xf3,
	0xac, 0xad, 0xd3, 0x16, 0xee, 0x0b, 0x96, 0x7a, 0x38, 0xa4, 0x71, 0xe0, 0x26, 0x2c, 0xa4, 0x1e,
	0x25, 0x69, 0x27, 0xe1, 0x4c, 0x30, 0xd4, 0x54, 0x41, 0x1d, 0x19, 0xd4, 0xc9, 0x83, 0x3a, 0x5b,
	0xa7, 0x5b, 0xc7, 0x35, 0x1c, 0x4e, 0xa8, 0x85, 0xe3, 0x98, 0x09, 0x2c, 0x28, 0x8b, 0x75, 0x5c,
	0xab, 0x51, 0xb2, 0x7a, 0x21, 0x25, 0xb1, 0xd0, 0x86, 0x13, 0x25, 0x43, 0x8f, 0x92, 0xd0, 0x77,
	0x37, 0xc8, 0x26, 0xde, 0xa2, 0x8c, 0x6b, 0x87, 0x63, 0x25, 0x07, 0x4e, 0x52, 0xd6, 0xe7, 0x1e,
	0xd1, 0xa6, 0xb6, 0x36, 0xc9, 0x7f, 0x1b, 0xfd, 0x9e, 0xe5, 0xf7, 0xb9, 0xcc, 0xaa, 0xed, 0x0b,
	0x4f, 0xdb, 0x49, 0x94, 0x88, 0x6d, 0x65, 0x34, 0xff, 0x9e, 0x86, 0x47, 0xed, 0x61, 0xa3, 0xdd,
	0xac, 0xcf, 0x6d, 0x74, 0x18, 0x1a, 0xd4, 0x6f, 0x82, 0x45, 0x70, 0x72, 0xd6, 0x31, 0xa8, 0x8f,
	0x1a, 0x70, 0x3a, 0xc6, 0x11, 0x69, 0x1a, 0xd9, 0xca, 0xf2, 0xd4, 0x43, 0x7b, 0xca, 0x91, 0x0b,
	0xc8, 0x83, 0x47, 0x36, 0x70, 0x4a, 0x3d, 0x17, 0x87, 0x01, 0xe3, 0x54, 0x6c, 0x46, 0xcd, 0xa9,
	0x45, 0x70, 0x72, 0xee, 0xcc, 0xd9, 0x4e, 0x15, 0x45, 0x9d, 0xe5, 0x2c, 0xa0, 0x94, 0xd3, 0xce,
	0x43, 0x33, 0x60, 0xe3, 0xca, 0x0b, 0xce, 0x61, 0x09, 0x59, 0x2c, 0xa3, 0x4d, 0x38, 0x3f, 0x60,
	0xfc, 0x36, 0xe1, 0xae, 0xc7, 0xe2, 0x1e, 0x0d, 0x9a, 0xd3, 0x32, 0xc5, 0xc5, 0xea, 0x14, 0x57,
	0xe3, 0x54, 0xe0, 0xd8, 0x23, 0x6b, 0x9c, 0xf5, 0x93, 0x91, 0xf6, 0x56, 0x24, 0x8a, 0xcc, 0xe6,
	0x1c, 0x52, 0xc8, 0x6a, 0x09, 0xed, 0xc0, 0x46, 0x4a, 0x3c, 0x16, 0xfb, 0x98, 0x6f, 0xbb, 0x4f,
	0xe6, 0x3c, 0xf0, 0xbc, 0x72, 0x02, 0xe7, 0xa5, 0x22, 0xc7, 0x27, 0xa5, 0xe4, 0x17, 0x7e, 0x07,
	0x8f, 0xec, 0xdf, 0x00, 0x7c, 0xbd, 0x00, 0x55, 0xa9, 0x70, 0x42, 0xd3, 0x8e, 0xc7, 0x22, 0x6b,
	0x74, 0x9b, 0xba, 0x09, 0x67, 0xb7, 0x88, 0x27, 0x52, 0x6b, 0x47, 0x3f, 0xed, 0x5a, 0x21, 0xf3,
	0x94, 0xe4, 0xac, 0x9d, 0xfc, 0x71, 0xb7, 0x2c, 0xe5, 0xae, 0x56, 0xb2, 0xb5, 0x33, 0xa2, 0xef,
	0xed, 0x5d, 0x74, 0x6d, 0x0c, 0x22, 0x27, 0x81, 0xc2, 0x53, 0x0f, 0x7b, 0x47, 0x5b, 0x9e, 0x83,
	0xb3, 0x85, 0x2e, 0xcc, 0x9f, 0x01, 0x3c, 0x56, 0xb9, 0xf5, 0x68, 0x1d, 0xce, 0x6d, 0x63, 0x1e,
	0xe7, 0x6c, 0x03, 0xc9, 0xf6, 0x5b, 0xcf, 0x10, 0xd1, 0xa7, 0x98, 0xc7, 0x25, 0xb4, 0xf2, 0xbe,
	0xc2, 0x0c, 0x4d, 0xef, 0xea, 0x1a, 0x3c, 0xe2, 0x31, 0x16, 0xfa, 0x6c, 0x10, 0xbb, 0x09, 0xe1,
	0x94, 0xf9, 0x52, 0xc8, 0x73, 0x67, 0x8e, 0xe5, 0xf8, 0xf9, 0x68, 0x74, 0x56, 0xf5, 0xe8, 0xa8,
	0x8d, 0x3a, 0x9c, 0x87, 0x75, 0x65, 0x94, 0xf9, 0xd8, 0x80, 0xad, 0xea, 0xc4, 0x68, 0x03, 0xbe,
	0x12, 0x70, 0xec, 0x91, 0x5e, 0x3f, 0x74, 0x7d, 0xe2, 0xb1, 0x28, 0xa2, 0x69, 0x4a, 0x59, 0xec,
	0x0a, 0x1a, 0x11, 0xd6, 0x17, 0x5a, 0x43, 0xf5, 0x59, 0x0d, 0x67, 0x21, 0x07, 0x59, 0x2d, 0x61,
	0xdc, 0x50, 0x10, 0xe8, 0x14, 0x3c, 0x92, 0x25, 0x25, 0x6e, 0x3f, 0x71, 0x7b, 0xd8, 0x13, 0x8c,
	0x4b, 0xae, 0x80, 0x0a, 0x9d, 0x97, 0xb6, 0x9b, 0xc9, 0x65, 0x69, 0x41, 0x16, 0x3c, 0xaa, 0x9c,
	0x65, 0xeb, 0xda, 0xdd, 0x18, 0xba, 0x2b, 0xa8, 0x55, 0x36, 0x88, 0x75, 0xc0, 0x0a, 0x3c, 0x5e,
	0xa0, 0x47, 0x34, 0xce, 0x47, 0xa0, 0xc7, 0xb1, 0x97, 0xd5, 0x27, 0x67, 0x1b, 0x28, 0x6e, 0x9a,
	0x3a, 0xd5, 0xc7, 0x34, 0x56, 0x2a, 0xbe, 0xac, 0x9d, 0xd0, 0x1a, 0x6c, 0x97, 0xb2, 0x8e, 0x83,
	0x99, 0x1e, 0xc2, 0xb4, 0x8a, 0x12, 0x46, 0x80, 0xcc, 0x6f, 0x00, 0x7c, 0x6d, 0x2f, 0x53, 0x85,
	0x4e, 0xc2, 0xf9, 0x2c, 0x0d, 0xd5, 0xbe, 0xa9, 0xa4, 0xe4, 0x80, 0x4a, 0x70, 0x28, 0xa2, 0x71,
	0x0e, 0x92, 0x4a, 0x4f, 0x7c, 0xa7, 0xe4, 0x69, 0xe4, 0x9e, 0x86, 0x73, 0x28, 0xc2, 0x77, 0x86,
	0x9e, 0x0b, 0x70, 0x66, 0x40, 0x68, 0xb0, 0x29, 0x64, 0xd3, 0x1a, 0x4c, 0x2f, 0x99, 0x3f, 0x02,
	0xd8, 0x5e, 0xe1, 0x04, 0x0b, 0x32, 0x52, 0x92, 0x43, 0x3e, 0xeb, 0x93, 0x54, 0xa0, 0xab, 0x70,
	0x26, 0xc1, 0x9c, 0xc4, 0x42, 0x1d, 0xa3, 0xcb, 0xa7, 0x1f, 0xda, 0xc6, 0x3f, 0xf6, 0x29, 0xb4,
	0xf7, 0xf1, 0x76, 0x34, 0x00, 0x5a, 0x81, 0x33, 0x6a, 0xa2, 0xb4, 0x6c, 0x4f, 0x55, 0x8f, 0xc5,
	0x38, 0x10, 0xf9, 0x6b, 0xfa, 0x70, 0x61, 0x8d, 0x88, 0xca, 0x72, 0x2f, 0xe9, 0x13, 0xfe, 0x89,
	0x62, 0x27, 0x38, 0x8b, 0xd4, 0x7d, 0x60, 0xde, 0x82, 0xed, 0x9b, 0x89, 0x5f, 0xc7, 0xcb, 0x95,
	0xa2, 0x19, 0x30, 0x71, 0x33, 0x6a, 0x9f, 0xf2, 0x8e, 0x02, 0xd8, 0x5e, 0x25, 0x21, 0xa9, 0xc9,
	0xf5, 0x9c, 0x9a, 0xfa, 0x09, 0xc0, 0xf6, 0x35, 0x9a, 0x8e, 0x90, 0x47, 0x49, 0xfa, 0x3f, 0xec,
	0xf6, 0x22, 0x9c, 0x4d, 0x70, 0x40, 0xdc, 0x94, 0xde, 0x25, 0x43, 0x79, 0x02, 0xe7, 0x60, 0xb6,
	0x7a, 0x9d, 0xde, 0x25, 0xc8, 0x84, 0x50, 0x7a, 0x08, 0x76, 0x9b, 0xa8, 0x99, 0x9c, 0x55, 0x2e,
	0x32, 0xf0, 0x46, 0xb6, 0x6a, 0xde, 0x07, 0xf0, 0x44, 0x65, 0xcd, 0x69, 0xc2, 0xe2, 0x94, 0xa0,
	0x6b, 0xf0, 0x60, 0xfe, 0x5e, 0xd3, 0x04, 0x8b, 0x53, 0xfb, 0xd8, 0x8c, 0x29, 0xa7, 0x40, 0xc8,
	0x4e, 0xa6, 0x98, 0xdc, 0x11, 0x6e, 0xa9, 0xb4, 0xd2, 0xeb, 0xc2, 0x7c, 0x66, 0xeb, 0xe6, 0xe5,
	0x9d, 0xf9, 0x61, 0x0e, 0x36, 0x47, 0x10, 0xaf, 0x13, 0xbe, 0x45, 0x3d, 0x82, 0xee, 0x1b, 0xb0,
	0x51, 0x31, 0x5d, 0xe8, 0xed, 0xea, 0x0a, 0xeb, 0x07, 0xb2, 0x35, 0x49, 0x6f, 0xe6, 0xb7, 0xe0,
	0x81, 0x3d, 0xaf, 0x36, 0xe4, 0x0d, 0x25, 0xb7, 0x7b, 0x7f, 0xfe, 0xf5, 0xb5, 0x71, 0x0f, 0x98,
	0xe7, 0xb3, 0x57, 0xc3, 0x1d, 0x65, 0x7a, 0xbf, 0xb8, 0x2d, 0x97, 0x4a, 0xf7, 0xee, 0xd2, 0xd8,
	0x1b, 0xf2, 0x82, 0x96, 0xed, 0xfa, 0x07, 0xe6, 0xb9, 0x0a, 0x88, 0xfc, 0xa2, 0xad, 0x07, 0x40,
	0xdf, 0x1b, 0xb0, 0x51, 0x31, 0x64, 0x75, 0xf4, 0xd4, 0xcf, 0xe5, 0x64, 0xf4, 0x7c, 0x07, 0x1e,
	0xd8, 0x33, 0x25, 0x5e, 0xbe, 0x04, 0xad, 0x8b, 0xaa, 0x29, 0xb9, 0xd6, 0xc9, 0xc6, 0xa6, 0x82,
	0x9c, 0xb1, 0x6f, 0x0f, 0x4b, 0xbb, 0x05, 0x3d, 0x97, 0x5b, 0xef, 0xd5, 0x21, 0x15, 0x1c, 0x3d,
	0x03, 0x07, 0xfd, 0x0b, 0xe0, 0x8b, 0xe3, 0x0e, 0x3c, 0x74, 0xae, 0xba, 0xd1, 0x9a, 0x03, 0x72,
	0x32, 0x7e, 0x3e, 0x7f, 0x60, 0xcb, 0xa3, 0x43, 0x92, 0xc3, 0x91, 0xd2, 0xcc, 0xe4, 0xa4, 0xac,
	0x9f, 0x47, 0xe7, 0xc6, 0x86, 0x3e, 0x8b, 0x05, 0xf4, 0x95, 0x01, 0x1b, 0x15, 0xe3, 0x5f, 0xa7,
	0x91, 0xfa, 0x53, 0xae, 0xf5, 0xce, 0x3e, 0x22, 0xd5, 0x59, 0x63, 0x7e, 0x21, 0x15, 0x23, 0x25,
	0xff, 0x04, 0x29, 0x93, 0x0f, 0x52, 0x41, 0xca, 0xa4, 0x03, 0x84, 0x1e, 0x03, 0xd8, 0xa8, 0xb8,
	0x31, 0xea, 0x48, 0xa9, 0xbf, 0x64, 0x5a, 0x2f, 0x8f, 0xbc, 0xce, 0x5d, 0xca, 0xbe, 0xaf, 0x9e,
	0xd2, 0xc0, 0xd2, 0xfe, 0x35, 0xb0, 0xb4, 0x3f, 0x0d, 0xb4, 0x3e, 0xfa, 0xd5, 0x6e, 0x54, 0x5c,
	0x3f, 0x7f, 0xd8, 0x9d, 0x4d, 0x21, 0x92, 0xf4, 0x82, 0x65, 0x0d, 0x06, 0x83, 0xa7, 0xef, 0x26,
	0xdc, 0x17, 0x9b, 0xea, 0x7b, 0xf8, 0xcd, 0x24, 0xc4, 0xa2, 0xc7, 0x78, 0xb4, 0xfc, 0x0b, 0x78,
	0x64, 0x5f, 0x82, 0xed, 0xaa, 0xeb, 0xcc, 0x91, 0xc5, 0xa0, 0x57, 0xf7, 0xf0, 0xf9, 0x00, 0x8f,
	0x7b, 0x2c, 0xaa, 0x64, 0x7b, 0xb9, 0x39, 0x46, 0x45, 0xdd, 0x8c, 0xd9, 0x2e, 0x58, 0xff, 0x50,
	0x47, 0x05, 0x2c, 0xc4, 0x71, 0xd0, 0x61, 0x3c, 0xb0, 0x02, 0x12, 0x4b, 0xde, 0xad, 0x61, 0x41,
	0xa3, 0x9f, 0xf2, 0xef, 0xe6, 0xcf, 0x1b, 0x33, 0xd2, 0xf9, 0xec, 0x7f, 0x01, 0x00, 0x00, 0xff,
	0xff, 0x36, 0x83, 0xe7, 0x94, 0xf6, 0x0f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AutoscalingPolicyServiceClient is the client API for AutoscalingPolicyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AutoscalingPolicyServiceClient interface {
	// Creates new autoscaling policy.
	CreateAutoscalingPolicy(ctx context.Context, in *CreateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Updates (replaces) autoscaling policy.
	//
	// Disabled check for update_mask, because all updates will be full
	// replacements.
	UpdateAutoscalingPolicy(ctx context.Context, in *UpdateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Retrieves autoscaling policy.
	GetAutoscalingPolicy(ctx context.Context, in *GetAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Lists autoscaling policies in the project.
	ListAutoscalingPolicies(ctx context.Context, in *ListAutoscalingPoliciesRequest, opts ...grpc.CallOption) (*ListAutoscalingPoliciesResponse, error)
	// Deletes an autoscaling policy. It is an error to delete an autoscaling
	// policy that is in use by one or more clusters.
	DeleteAutoscalingPolicy(ctx context.Context, in *DeleteAutoscalingPolicyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type autoscalingPolicyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAutoscalingPolicyServiceClient(cc grpc.ClientConnInterface) AutoscalingPolicyServiceClient {
	return &autoscalingPolicyServiceClient{cc}
}

func (c *autoscalingPolicyServiceClient) CreateAutoscalingPolicy(ctx context.Context, in *CreateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.AutoscalingPolicyService/CreateAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) UpdateAutoscalingPolicy(ctx context.Context, in *UpdateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.AutoscalingPolicyService/UpdateAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) GetAutoscalingPolicy(ctx context.Context, in *GetAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.AutoscalingPolicyService/GetAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) ListAutoscalingPolicies(ctx context.Context, in *ListAutoscalingPoliciesRequest, opts ...grpc.CallOption) (*ListAutoscalingPoliciesResponse, error) {
	out := new(ListAutoscalingPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.AutoscalingPolicyService/ListAutoscalingPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) DeleteAutoscalingPolicy(ctx context.Context, in *DeleteAutoscalingPolicyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1.AutoscalingPolicyService/DeleteAutoscalingPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutoscalingPolicyServiceServer is the server API for AutoscalingPolicyService service.
type AutoscalingPolicyServiceServer interface {
	// Creates new autoscaling policy.
	CreateAutoscalingPolicy(context.Context, *CreateAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Updates (replaces) autoscaling policy.
	//
	// Disabled check for update_mask, because all updates will be full
	// replacements.
	UpdateAutoscalingPolicy(context.Context, *UpdateAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Retrieves autoscaling policy.
	GetAutoscalingPolicy(context.Context, *GetAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Lists autoscaling policies in the project.
	ListAutoscalingPolicies(context.Context, *ListAutoscalingPoliciesRequest) (*ListAutoscalingPoliciesResponse, error)
	// Deletes an autoscaling policy. It is an error to delete an autoscaling
	// policy that is in use by one or more clusters.
	DeleteAutoscalingPolicy(context.Context, *DeleteAutoscalingPolicyRequest) (*empty.Empty, error)
}

// UnimplementedAutoscalingPolicyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAutoscalingPolicyServiceServer struct {
}

func (*UnimplementedAutoscalingPolicyServiceServer) CreateAutoscalingPolicy(ctx context.Context, req *CreateAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAutoscalingPolicy not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) UpdateAutoscalingPolicy(ctx context.Context, req *UpdateAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAutoscalingPolicy not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) GetAutoscalingPolicy(ctx context.Context, req *GetAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutoscalingPolicy not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) ListAutoscalingPolicies(ctx context.Context, req *ListAutoscalingPoliciesRequest) (*ListAutoscalingPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutoscalingPolicies not implemented")
}
func (*UnimplementedAutoscalingPolicyServiceServer) DeleteAutoscalingPolicy(ctx context.Context, req *DeleteAutoscalingPolicyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAutoscalingPolicy not implemented")
}

func RegisterAutoscalingPolicyServiceServer(s *grpc.Server, srv AutoscalingPolicyServiceServer) {
	s.RegisterService(&_AutoscalingPolicyService_serviceDesc, srv)
}

func _AutoscalingPolicyService_CreateAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).CreateAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.AutoscalingPolicyService/CreateAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).CreateAutoscalingPolicy(ctx, req.(*CreateAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_UpdateAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).UpdateAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.AutoscalingPolicyService/UpdateAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).UpdateAutoscalingPolicy(ctx, req.(*UpdateAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_GetAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).GetAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.AutoscalingPolicyService/GetAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).GetAutoscalingPolicy(ctx, req.(*GetAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_ListAutoscalingPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutoscalingPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).ListAutoscalingPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.AutoscalingPolicyService/ListAutoscalingPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).ListAutoscalingPolicies(ctx, req.(*ListAutoscalingPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_DeleteAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).DeleteAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1.AutoscalingPolicyService/DeleteAutoscalingPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).DeleteAutoscalingPolicy(ctx, req.(*DeleteAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AutoscalingPolicyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.AutoscalingPolicyService",
	HandlerType: (*AutoscalingPolicyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_CreateAutoscalingPolicy_Handler,
		},
		{
			MethodName: "UpdateAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_UpdateAutoscalingPolicy_Handler,
		},
		{
			MethodName: "GetAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_GetAutoscalingPolicy_Handler,
		},
		{
			MethodName: "ListAutoscalingPolicies",
			Handler:    _AutoscalingPolicyService_ListAutoscalingPolicies_Handler,
		},
		{
			MethodName: "DeleteAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_DeleteAutoscalingPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/autoscaling_policies.proto",
}
