// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2/context.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_struct "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents a context.
type Context struct {
	// Required. The unique identifier of the context. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context ID>`,
	// or `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>/contexts/<Context ID>`.
	//
	// The `Context ID` is always converted to lowercase, may only contain
	// characters in a-zA-Z0-9_-% and may be at most 250 bytes long.
	//
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment. If `User ID` is not specified, we assume default '-' user.
	//
	// The following context names are reserved for internal use by Dialogflow.
	// You should not use these contexts or create contexts with these names:
	//
	// * `__system_counters__`
	// * `*_id_dialog_context`
	// * `*_dialog_params_size`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The number of conversational query requests after which the
	// context expires. If set to `0` (the default) the context expires
	// immediately. Contexts expire automatically after 20 minutes if there
	// are no matching queries.
	LifespanCount int32 `protobuf:"varint,2,opt,name=lifespan_count,json=lifespanCount,proto3" json:"lifespan_count,omitempty"`
	// Optional. The collection of parameters associated with this context.
	// Refer to [this
	// doc](https://cloud.google.com/dialogflow/docs/intents-actions-parameters)
	// for syntax.
	Parameters           *_struct.Struct `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Context) Reset()         { *m = Context{} }
func (m *Context) String() string { return proto.CompactTextString(m) }
func (*Context) ProtoMessage()    {}
func (*Context) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7e2e3bf8515c3b3, []int{0}
}

func (m *Context) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Context.Unmarshal(m, b)
}
func (m *Context) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Context.Marshal(b, m, deterministic)
}
func (m *Context) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Context.Merge(m, src)
}
func (m *Context) XXX_Size() int {
	return xxx_messageInfo_Context.Size(m)
}
func (m *Context) XXX_DiscardUnknown() {
	xxx_messageInfo_Context.DiscardUnknown(m)
}

var xxx_messageInfo_Context proto.InternalMessageInfo

func (m *Context) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Context) GetLifespanCount() int32 {
	if m != nil {
		return m.LifespanCount
	}
	return 0
}

func (m *Context) GetParameters() *_struct.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

// The request message for [Contexts.ListContexts][google.cloud.dialogflow.v2.Contexts.ListContexts].
type ListContextsRequest struct {
	// Required. The session to list all contexts from.
	// Format: `projects/<Project ID>/agent/sessions/<Session ID>` or
	// `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>`.
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment. If `User ID` is not specified, we assume default '-' user.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListContextsRequest) Reset()         { *m = ListContextsRequest{} }
func (m *ListContextsRequest) String() string { return proto.CompactTextString(m) }
func (*ListContextsRequest) ProtoMessage()    {}
func (*ListContextsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7e2e3bf8515c3b3, []int{1}
}

func (m *ListContextsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListContextsRequest.Unmarshal(m, b)
}
func (m *ListContextsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListContextsRequest.Marshal(b, m, deterministic)
}
func (m *ListContextsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListContextsRequest.Merge(m, src)
}
func (m *ListContextsRequest) XXX_Size() int {
	return xxx_messageInfo_ListContextsRequest.Size(m)
}
func (m *ListContextsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListContextsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListContextsRequest proto.InternalMessageInfo

func (m *ListContextsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListContextsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListContextsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [Contexts.ListContexts][google.cloud.dialogflow.v2.Contexts.ListContexts].
type ListContextsResponse struct {
	// The list of contexts. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Contexts []*Context `protobuf:"bytes,1,rep,name=contexts,proto3" json:"contexts,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListContextsResponse) Reset()         { *m = ListContextsResponse{} }
func (m *ListContextsResponse) String() string { return proto.CompactTextString(m) }
func (*ListContextsResponse) ProtoMessage()    {}
func (*ListContextsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7e2e3bf8515c3b3, []int{2}
}

func (m *ListContextsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListContextsResponse.Unmarshal(m, b)
}
func (m *ListContextsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListContextsResponse.Marshal(b, m, deterministic)
}
func (m *ListContextsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListContextsResponse.Merge(m, src)
}
func (m *ListContextsResponse) XXX_Size() int {
	return xxx_messageInfo_ListContextsResponse.Size(m)
}
func (m *ListContextsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListContextsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListContextsResponse proto.InternalMessageInfo

func (m *ListContextsResponse) GetContexts() []*Context {
	if m != nil {
		return m.Contexts
	}
	return nil
}

func (m *ListContextsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [Contexts.GetContext][google.cloud.dialogflow.v2.Contexts.GetContext].
type GetContextRequest struct {
	// Required. The name of the context. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context ID>`
	// or `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>/contexts/<Context ID>`.
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment. If `User ID` is not specified, we assume default '-' user.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetContextRequest) Reset()         { *m = GetContextRequest{} }
func (m *GetContextRequest) String() string { return proto.CompactTextString(m) }
func (*GetContextRequest) ProtoMessage()    {}
func (*GetContextRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7e2e3bf8515c3b3, []int{3}
}

func (m *GetContextRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetContextRequest.Unmarshal(m, b)
}
func (m *GetContextRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetContextRequest.Marshal(b, m, deterministic)
}
func (m *GetContextRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetContextRequest.Merge(m, src)
}
func (m *GetContextRequest) XXX_Size() int {
	return xxx_messageInfo_GetContextRequest.Size(m)
}
func (m *GetContextRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetContextRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetContextRequest proto.InternalMessageInfo

func (m *GetContextRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [Contexts.CreateContext][google.cloud.dialogflow.v2.Contexts.CreateContext].
type CreateContextRequest struct {
	// Required. The session to create a context for.
	// Format: `projects/<Project ID>/agent/sessions/<Session ID>` or
	// `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>`.
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment. If `User ID` is not specified, we assume default '-' user.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The context to create.
	Context              *Context `protobuf:"bytes,2,opt,name=context,proto3" json:"context,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateContextRequest) Reset()         { *m = CreateContextRequest{} }
func (m *CreateContextRequest) String() string { return proto.CompactTextString(m) }
func (*CreateContextRequest) ProtoMessage()    {}
func (*CreateContextRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7e2e3bf8515c3b3, []int{4}
}

func (m *CreateContextRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateContextRequest.Unmarshal(m, b)
}
func (m *CreateContextRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateContextRequest.Marshal(b, m, deterministic)
}
func (m *CreateContextRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateContextRequest.Merge(m, src)
}
func (m *CreateContextRequest) XXX_Size() int {
	return xxx_messageInfo_CreateContextRequest.Size(m)
}
func (m *CreateContextRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateContextRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateContextRequest proto.InternalMessageInfo

func (m *CreateContextRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateContextRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

// The request message for [Contexts.UpdateContext][google.cloud.dialogflow.v2.Contexts.UpdateContext].
type UpdateContextRequest struct {
	// Required. The context to update.
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateContextRequest) Reset()         { *m = UpdateContextRequest{} }
func (m *UpdateContextRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateContextRequest) ProtoMessage()    {}
func (*UpdateContextRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7e2e3bf8515c3b3, []int{5}
}

func (m *UpdateContextRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateContextRequest.Unmarshal(m, b)
}
func (m *UpdateContextRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateContextRequest.Marshal(b, m, deterministic)
}
func (m *UpdateContextRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateContextRequest.Merge(m, src)
}
func (m *UpdateContextRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateContextRequest.Size(m)
}
func (m *UpdateContextRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateContextRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateContextRequest proto.InternalMessageInfo

func (m *UpdateContextRequest) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *UpdateContextRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [Contexts.DeleteContext][google.cloud.dialogflow.v2.Contexts.DeleteContext].
type DeleteContextRequest struct {
	// Required. The name of the context to delete. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>/contexts/<Context ID>`
	// or `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>/contexts/<Context ID>`.
	// If `Environment ID` is not specified, we assume default 'draft'
	// environment. If `User ID` is not specified, we assume default '-' user.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteContextRequest) Reset()         { *m = DeleteContextRequest{} }
func (m *DeleteContextRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteContextRequest) ProtoMessage()    {}
func (*DeleteContextRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7e2e3bf8515c3b3, []int{6}
}

func (m *DeleteContextRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteContextRequest.Unmarshal(m, b)
}
func (m *DeleteContextRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteContextRequest.Marshal(b, m, deterministic)
}
func (m *DeleteContextRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteContextRequest.Merge(m, src)
}
func (m *DeleteContextRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteContextRequest.Size(m)
}
func (m *DeleteContextRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteContextRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteContextRequest proto.InternalMessageInfo

func (m *DeleteContextRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [Contexts.DeleteAllContexts][google.cloud.dialogflow.v2.Contexts.DeleteAllContexts].
type DeleteAllContextsRequest struct {
	// Required. The name of the session to delete all contexts from. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>` or `projects/<Project
	// ID>/agent/environments/<Environment ID>/users/<User ID>/sessions/<Session
	// ID>`.
	// If `Environment ID` is not specified we assume default 'draft' environment.
	// If `User ID` is not specified, we assume default '-' user.
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAllContextsRequest) Reset()         { *m = DeleteAllContextsRequest{} }
func (m *DeleteAllContextsRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAllContextsRequest) ProtoMessage()    {}
func (*DeleteAllContextsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_e7e2e3bf8515c3b3, []int{7}
}

func (m *DeleteAllContextsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAllContextsRequest.Unmarshal(m, b)
}
func (m *DeleteAllContextsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAllContextsRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAllContextsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAllContextsRequest.Merge(m, src)
}
func (m *DeleteAllContextsRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAllContextsRequest.Size(m)
}
func (m *DeleteAllContextsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAllContextsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAllContextsRequest proto.InternalMessageInfo

func (m *DeleteAllContextsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func init() {
	proto.RegisterType((*Context)(nil), "google.cloud.dialogflow.v2.Context")
	proto.RegisterType((*ListContextsRequest)(nil), "google.cloud.dialogflow.v2.ListContextsRequest")
	proto.RegisterType((*ListContextsResponse)(nil), "google.cloud.dialogflow.v2.ListContextsResponse")
	proto.RegisterType((*GetContextRequest)(nil), "google.cloud.dialogflow.v2.GetContextRequest")
	proto.RegisterType((*CreateContextRequest)(nil), "google.cloud.dialogflow.v2.CreateContextRequest")
	proto.RegisterType((*UpdateContextRequest)(nil), "google.cloud.dialogflow.v2.UpdateContextRequest")
	proto.RegisterType((*DeleteContextRequest)(nil), "google.cloud.dialogflow.v2.DeleteContextRequest")
	proto.RegisterType((*DeleteAllContextsRequest)(nil), "google.cloud.dialogflow.v2.DeleteAllContextsRequest")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2/context.proto", fileDescriptor_e7e2e3bf8515c3b3)
}

var fileDescriptor_e7e2e3bf8515c3b3 = []byte{
	// 984 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xcf, 0x6f, 0xdc, 0x44,
	0x14, 0xd6, 0x38, 0xd0, 0x26, 0x93, 0x6e, 0x51, 0xa7, 0x11, 0xd9, 0xba, 0x15, 0x2c, 0xae, 0x84,
	0x96, 0x55, 0x6a, 0xc3, 0xc2, 0x85, 0x40, 0x01, 0x27, 0xa1, 0x45, 0x08, 0xa4, 0x68, 0x43, 0x91,
	0x08, 0x42, 0xab, 0x89, 0xf3, 0xd6, 0x31, 0xf1, 0xce, 0x18, 0xcf, 0x6c, 0x12, 0x1a, 0x45, 0x95,
	0x7a, 0x46, 0x48, 0xc0, 0x8d, 0x1f, 0x07, 0xb8, 0x20, 0xf8, 0x23, 0xf8, 0x03, 0x38, 0xc2, 0x2d,
	0xa7, 0x1e, 0x38, 0x20, 0x2e, 0x48, 0x88, 0x03, 0xe2, 0x54, 0x79, 0x3c, 0x5e, 0x7b, 0xd7, 0x9b,
	0xcd, 0x26, 0xcd, 0x29, 0xde, 0x37, 0xef, 0x7d, 0xf3, 0xde, 0xf7, 0xde, 0xfb, 0xec, 0xe0, 0xba,
	0xcf, 0xb9, 0x1f, 0x82, 0xe3, 0x85, 0xbc, 0xb7, 0xe9, 0x6c, 0x06, 0x34, 0xe4, 0x7e, 0x27, 0xe4,
	0xbb, 0xce, 0x4e, 0xd3, 0xf1, 0x38, 0x93, 0xb0, 0x27, 0xed, 0x28, 0xe6, 0x92, 0x13, 0x33, 0xf5,
	0xb4, 0x95, 0xa7, 0x9d, 0x7b, 0xda, 0x3b, 0x4d, 0xf3, 0x9a, 0x46, 0xa1, 0x51, 0xe0, 0x50, 0xc6,
	0xb8, 0xa4, 0x32, 0xe0, 0x4c, 0xa4, 0x91, 0xe6, 0x7c, 0xe1, 0xd4, 0x0b, 0x03, 0x60, 0x1a, 0xd2,
	0x7c, 0xba, 0x70, 0xd0, 0x09, 0x20, 0xdc, 0x6c, 0x6f, 0xc0, 0x16, 0xdd, 0x09, 0x78, 0xac, 0x1d,
	0xae, 0x14, 0x1c, 0x62, 0x10, 0xbc, 0x17, 0x7b, 0xa0, 0x8f, 0xae, 0xea, 0x23, 0xf5, 0x6b, 0xa3,
	0xd7, 0x71, 0xa0, 0x1b, 0xc9, 0x4f, 0xf5, 0x61, 0x6d, 0xf8, 0x30, 0x45, 0xef, 0x52, 0xb1, 0xad,
	0x3d, 0xae, 0x0d, 0x7b, 0x08, 0x19, 0xf7, 0x3c, 0x9d, 0x98, 0xf5, 0x2f, 0xc2, 0xe7, 0x97, 0xd3,
	0xea, 0xc9, 0x3c, 0x7e, 0x8c, 0xd1, 0x2e, 0x54, 0x51, 0x0d, 0xd5, 0x67, 0x96, 0xa6, 0x1e, 0xb8,
	0x46, 0x4b, 0x19, 0x48, 0x03, 0x5f, 0x0c, 0x83, 0x0e, 0x88, 0x88, 0xb2, 0xb6, 0xc7, 0x7b, 0x4c,
	0x56, 0x8d, 0x1a, 0xaa, 0x3f, 0x9e, 0xb8, 0xa0, 0x56, 0x25, 0x3b, 0x5a, 0x4e, 0x4e, 0xc8, 0xab,
	0x18, 0x47, 0x34, 0xa6, 0x5d, 0x90, 0x10, 0x8b, 0xea, 0x54, 0x0d, 0xd5, 0x67, 0x9b, 0xf3, 0xb6,
	0x66, 0x34, 0xcb, 0xc1, 0x5e, 0x53, 0x39, 0xa4, 0x00, 0x05, 0xff, 0xc5, 0xce, 0x5f, 0xae, 0x87,
	0x9f, 0x29, 0x50, 0x9e, 0x06, 0xd2, 0x28, 0x10, 0xb6, 0xc7, 0xbb, 0x4e, 0x96, 0xea, 0x6b, 0x51,
	0xcc, 0x3f, 0x06, 0x4f, 0x0a, 0x67, 0x5f, 0x3f, 0x1d, 0x38, 0xd4, 0x07, 0x26, 0x1d, 0x01, 0x42,
	0x24, 0x1d, 0x71, 0xf6, 0xf5, 0xd3, 0x41, 0xd6, 0x5d, 0xe1, 0xec, 0xeb, 0xa7, 0x03, 0x6b, 0x0f,
	0x5f, 0x7e, 0x27, 0x10, 0x52, 0xc3, 0x89, 0x16, 0x7c, 0xd2, 0x03, 0x21, 0xc9, 0x55, 0x7c, 0x2e,
	0xa2, 0x31, 0x30, 0x59, 0xe4, 0x40, 0x9b, 0x48, 0x0d, 0xcf, 0x44, 0xd4, 0x87, 0xb6, 0x08, 0xee,
	0x42, 0x91, 0x80, 0xe9, 0xc4, 0xba, 0x16, 0xdc, 0x05, 0x62, 0x25, 0xb5, 0xfb, 0xd0, 0x96, 0x7c,
	0x1b, 0x98, 0xaa, 0x7d, 0x26, 0x75, 0x51, 0x81, 0xef, 0x25, 0x56, 0xeb, 0x1e, 0x9e, 0x1b, 0xbc,
	0x59, 0x44, 0x9c, 0x09, 0x20, 0xaf, 0xe3, 0xe9, 0x2c, 0xcf, 0x2a, 0xaa, 0x4d, 0xd5, 0x67, 0x9b,
	0xd7, 0xed, 0xa3, 0xe7, 0xd0, 0xd6, 0xf1, 0xad, 0x7e, 0x10, 0x79, 0x16, 0x3f, 0xc1, 0x60, 0x4f,
	0xb6, 0x0b, 0x19, 0x24, 0x49, 0xce, 0xb4, 0x2a, 0x89, 0x79, 0xb5, 0x9f, 0x40, 0x0b, 0x5f, 0xba,
	0x0d, 0xd9, 0xfd, 0x59, 0xe1, 0x37, 0x07, 0x5a, 0xff, 0xdc, 0x03, 0xd7, 0xf8, 0xdf, 0xbd, 0x3e,
	0x41, 0x23, 0xd2, 0x01, 0xb1, 0xbe, 0x43, 0x78, 0x6e, 0x39, 0x06, 0x2a, 0x61, 0x08, 0xd7, 0x1d,
	0x22, 0x54, 0x23, 0x93, 0x09, 0x90, 0x33, 0xda, 0x97, 0xf0, 0x79, 0x5d, 0xa3, 0xaa, 0x67, 0x32,
	0x5e, 0xd2, 0xce, 0x65, 0x81, 0xd6, 0xb7, 0x08, 0xcf, 0xdd, 0x89, 0x36, 0xcb, 0xf9, 0x15, 0xc0,
	0xd1, 0x29, 0xc1, 0xc9, 0x1b, 0x78, 0xb6, 0xa7, 0xb0, 0xd5, 0xd6, 0xe9, 0x24, 0xcd, 0xd2, 0xc8,
	0xdf, 0x4a, 0x16, 0xf3, 0x5d, 0x2a, 0xb6, 0xf5, 0xd4, 0xa7, 0x31, 0x89, 0xc1, 0xba, 0x83, 0xe7,
	0x56, 0x20, 0x84, 0x52, 0x76, 0x8f, 0xd8, 0x95, 0x8f, 0x70, 0x35, 0x85, 0x75, 0xc3, 0x70, 0x78,
	0xd2, 0x1f, 0xbd, 0x31, 0xcd, 0xaf, 0x2b, 0x78, 0x3a, 0x83, 0x25, 0xf7, 0x0d, 0x7c, 0xa1, 0x38,
	0xd7, 0xc4, 0x19, 0x47, 0xe4, 0x88, 0xdd, 0x33, 0x9f, 0x9f, 0x3c, 0x20, 0x5d, 0x19, 0xeb, 0x73,
	0x74, 0xe8, 0xea, 0x64, 0xee, 0xff, 0xfe, 0xc7, 0x57, 0xc6, 0x3d, 0xf2, 0x42, 0x22, 0xe6, 0xfb,
	0xa9, 0xe9, 0x66, 0x5f, 0x22, 0x1a, 0xc3, 0xd2, 0xd0, 0xc8, 0x35, 0x61, 0xfd, 0x6d, 0xf2, 0xd6,
	0xd8, 0x20, 0x60, 0x3b, 0x41, 0xcc, 0x59, 0x17, 0x98, 0x32, 0xf6, 0x04, 0xc4, 0xc9, 0xdf, 0x51,
	0x58, 0xe4, 0x6f, 0x84, 0x71, 0xbe, 0x5b, 0xe4, 0xc6, 0xb8, 0x8a, 0x4a, 0x3b, 0x68, 0x4e, 0x32,
	0x7a, 0xd6, 0x67, 0xe8, 0xd0, 0x55, 0xdd, 0x1d, 0xa8, 0x38, 0x31, 0x8c, 0xab, 0x37, 0x97, 0xc0,
	0xc6, 0x41, 0xbf, 0xe2, 0xd1, 0x41, 0xc7, 0xd6, 0x5b, 0xc4, 0x22, 0x5f, 0x1a, 0xb8, 0x32, 0xb0,
	0xf8, 0x64, 0x6c, 0x1b, 0x47, 0x69, 0xc4, 0x64, 0x75, 0xff, 0x84, 0x0e, 0xdd, 0x8b, 0x69, 0x8f,
	0x16, 0x74, 0x02, 0x8a, 0x81, 0x2f, 0x90, 0x75, 0xf2, 0xa6, 0x2f, 0x66, 0xbb, 0xbb, 0xbe, 0x66,
	0x9d, 0x59, 0xf7, 0xfb, 0xa0, 0xe4, 0x47, 0x03, 0x57, 0x06, 0xd4, 0x66, 0x3c, 0x29, 0xa3, 0x84,
	0x69, 0x32, 0x52, 0x7e, 0x41, 0x87, 0xee, 0x65, 0x7d, 0xeb, 0x42, 0x41, 0x83, 0x14, 0x33, 0xdf,
	0xa3, 0xe6, 0xcb, 0xaa, 0xb6, 0xec, 0xe3, 0xe6, 0x24, 0x43, 0x92, 0x33, 0xf4, 0x61, 0x73, 0x75,
	0x02, 0x94, 0x13, 0x4d, 0x4d, 0xce, 0xd4, 0x9f, 0x08, 0x57, 0x06, 0x94, 0x6f, 0x3c, 0x53, 0xa3,
	0x44, 0xd2, 0x7c, 0xb2, 0xa4, 0xb4, 0x6f, 0x26, 0xdf, 0x47, 0xc3, 0x9b, 0xd2, 0x38, 0xcd, 0xa6,
	0x34, 0xce, 0x6e, 0x53, 0xfe, 0x41, 0xf8, 0x52, 0x49, 0x8d, 0xc9, 0x4b, 0xc7, 0x97, 0x5b, 0x16,
	0xef, 0x23, 0x4b, 0x2e, 0x09, 0x62, 0xe3, 0x34, 0x82, 0xd8, 0x38, 0xb3, 0x95, 0x30, 0xf7, 0x7e,
	0x75, 0xaf, 0x1c, 0xf9, 0x42, 0xf9, 0xcd, 0xfd, 0x60, 0x4b, 0xca, 0x48, 0x2c, 0x3a, 0xce, 0xee,
	0x6e, 0xe9, 0x6d, 0x43, 0x7b, 0x72, 0x2b, 0xfd, 0x56, 0xbf, 0x11, 0x85, 0x54, 0x76, 0x78, 0xdc,
	0x5d, 0x38, 0xce, 0x3d, 0xbf, 0x6a, 0xe9, 0x1b, 0x84, 0x9f, 0xf2, 0x78, 0x77, 0x0c, 0xbd, 0x4b,
	0x17, 0x34, 0xad, 0xab, 0x09, 0x89, 0xab, 0x68, 0x7d, 0x45, 0xfb, 0xfa, 0x3c, 0xa4, 0xcc, 0xb7,
	0x79, 0xec, 0x3b, 0x3e, 0x30, 0x45, 0xb1, 0x93, 0xdf, 0x36, 0xea, 0xff, 0x87, 0x57, 0xf2, 0x5f,
	0xff, 0x21, 0xf4, 0x83, 0x61, 0xac, 0xdc, 0xfa, 0xd9, 0x30, 0x6f, 0xa7, 0x70, 0xcb, 0xea, 0xea,
	0x95, 0xfc, 0xea, 0xf7, 0x9b, 0x1b, 0xe7, 0x14, 0xea, 0x8b, 0x0f, 0x03, 0x00, 0x00, 0xff, 0xff,
	0xa8, 0x34, 0xb6, 0x4c, 0x94, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ContextsClient is the client API for Contexts service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ContextsClient interface {
	// Returns the list of all contexts in the specified session.
	ListContexts(ctx context.Context, in *ListContextsRequest, opts ...grpc.CallOption) (*ListContextsResponse, error)
	// Retrieves the specified context.
	GetContext(ctx context.Context, in *GetContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Creates a context.
	//
	// If the specified context already exists, overrides the context.
	CreateContext(ctx context.Context, in *CreateContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Updates the specified context.
	UpdateContext(ctx context.Context, in *UpdateContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Deletes the specified context.
	DeleteContext(ctx context.Context, in *DeleteContextRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Deletes all active contexts in the specified session.
	DeleteAllContexts(ctx context.Context, in *DeleteAllContextsRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type contextsClient struct {
	cc grpc.ClientConnInterface
}

func NewContextsClient(cc grpc.ClientConnInterface) ContextsClient {
	return &contextsClient{cc}
}

func (c *contextsClient) ListContexts(ctx context.Context, in *ListContextsRequest, opts ...grpc.CallOption) (*ListContextsResponse, error) {
	out := new(ListContextsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Contexts/ListContexts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contextsClient) GetContext(ctx context.Context, in *GetContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Contexts/GetContext", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contextsClient) CreateContext(ctx context.Context, in *CreateContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Contexts/CreateContext", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contextsClient) UpdateContext(ctx context.Context, in *UpdateContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Contexts/UpdateContext", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contextsClient) DeleteContext(ctx context.Context, in *DeleteContextRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Contexts/DeleteContext", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contextsClient) DeleteAllContexts(ctx context.Context, in *DeleteAllContextsRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Contexts/DeleteAllContexts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ContextsServer is the server API for Contexts service.
type ContextsServer interface {
	// Returns the list of all contexts in the specified session.
	ListContexts(context.Context, *ListContextsRequest) (*ListContextsResponse, error)
	// Retrieves the specified context.
	GetContext(context.Context, *GetContextRequest) (*Context, error)
	// Creates a context.
	//
	// If the specified context already exists, overrides the context.
	CreateContext(context.Context, *CreateContextRequest) (*Context, error)
	// Updates the specified context.
	UpdateContext(context.Context, *UpdateContextRequest) (*Context, error)
	// Deletes the specified context.
	DeleteContext(context.Context, *DeleteContextRequest) (*empty.Empty, error)
	// Deletes all active contexts in the specified session.
	DeleteAllContexts(context.Context, *DeleteAllContextsRequest) (*empty.Empty, error)
}

// UnimplementedContextsServer can be embedded to have forward compatible implementations.
type UnimplementedContextsServer struct {
}

func (*UnimplementedContextsServer) ListContexts(ctx context.Context, req *ListContextsRequest) (*ListContextsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListContexts not implemented")
}
func (*UnimplementedContextsServer) GetContext(ctx context.Context, req *GetContextRequest) (*Context, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetContext not implemented")
}
func (*UnimplementedContextsServer) CreateContext(ctx context.Context, req *CreateContextRequest) (*Context, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateContext not implemented")
}
func (*UnimplementedContextsServer) UpdateContext(ctx context.Context, req *UpdateContextRequest) (*Context, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateContext not implemented")
}
func (*UnimplementedContextsServer) DeleteContext(ctx context.Context, req *DeleteContextRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteContext not implemented")
}
func (*UnimplementedContextsServer) DeleteAllContexts(ctx context.Context, req *DeleteAllContextsRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAllContexts not implemented")
}

func RegisterContextsServer(s *grpc.Server, srv ContextsServer) {
	s.RegisterService(&_Contexts_serviceDesc, srv)
}

func _Contexts_ListContexts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListContextsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).ListContexts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Contexts/ListContexts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).ListContexts(ctx, req.(*ListContextsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Contexts_GetContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).GetContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Contexts/GetContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).GetContext(ctx, req.(*GetContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Contexts_CreateContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).CreateContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Contexts/CreateContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).CreateContext(ctx, req.(*CreateContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Contexts_UpdateContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).UpdateContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Contexts/UpdateContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).UpdateContext(ctx, req.(*UpdateContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Contexts_DeleteContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).DeleteContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Contexts/DeleteContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).DeleteContext(ctx, req.(*DeleteContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Contexts_DeleteAllContexts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAllContextsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContextsServer).DeleteAllContexts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Contexts/DeleteAllContexts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContextsServer).DeleteAllContexts(ctx, req.(*DeleteAllContextsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Contexts_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Contexts",
	HandlerType: (*ContextsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListContexts",
			Handler:    _Contexts_ListContexts_Handler,
		},
		{
			MethodName: "GetContext",
			Handler:    _Contexts_GetContext_Handler,
		},
		{
			MethodName: "CreateContext",
			Handler:    _Contexts_CreateContext_Handler,
		},
		{
			MethodName: "UpdateContext",
			Handler:    _Contexts_UpdateContext_Handler,
		},
		{
			MethodName: "DeleteContext",
			Handler:    _Contexts_DeleteContext_Handler,
		},
		{
			MethodName: "DeleteAllContexts",
			Handler:    _Contexts_DeleteAllContexts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/context.proto",
}
