// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

package recaptchaenterprise

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Enum that reprensents the types of annotations.
type AnnotateAssessmentRequest_Annotation int32

const (
	// Default unspecified type.
	AnnotateAssessmentRequest_ANNOTATION_UNSPECIFIED AnnotateAssessmentRequest_Annotation = 0
	// Provides information that the event turned out to be legitimate.
	AnnotateAssessmentRequest_LEGITIMATE AnnotateAssessmentRequest_Annotation = 1
	// Provides information that the event turned out to be fraudulent.
	AnnotateAssessmentRequest_FRAUDULENT AnnotateAssessmentRequest_Annotation = 2
	// Provides information that the event was related to a login event in which
	// the user typed the correct password.
	AnnotateAssessmentRequest_PASSWORD_CORRECT AnnotateAssessmentRequest_Annotation = 3
	// Provides information that the event was related to a login event in which
	// the user typed the incorrect password.
	AnnotateAssessmentRequest_PASSWORD_INCORRECT AnnotateAssessmentRequest_Annotation = 4
)

var AnnotateAssessmentRequest_Annotation_name = map[int32]string{
	0: "ANNOTATION_UNSPECIFIED",
	1: "LEGITIMATE",
	2: "FRAUDULENT",
	3: "PASSWORD_CORRECT",
	4: "PASSWORD_INCORRECT",
}

var AnnotateAssessmentRequest_Annotation_value = map[string]int32{
	"ANNOTATION_UNSPECIFIED": 0,
	"LEGITIMATE":             1,
	"FRAUDULENT":             2,
	"PASSWORD_CORRECT":       3,
	"PASSWORD_INCORRECT":     4,
}

func (x AnnotateAssessmentRequest_Annotation) String() string {
	return proto.EnumName(AnnotateAssessmentRequest_Annotation_name, int32(x))
}

func (AnnotateAssessmentRequest_Annotation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{1, 0}
}

// LINT.IfChange(classification_reason)
// Reasons contributing to the risk analysis verdict.
type RiskAnalysis_ClassificationReason int32

const (
	// Default unspecified type.
	RiskAnalysis_CLASSIFICATION_REASON_UNSPECIFIED RiskAnalysis_ClassificationReason = 0
	// Interactions matched the behavior of an automated agent.
	RiskAnalysis_AUTOMATION RiskAnalysis_ClassificationReason = 1
	// The event originated from an illegitimate environment.
	RiskAnalysis_UNEXPECTED_ENVIRONMENT RiskAnalysis_ClassificationReason = 2
	// Traffic volume from the event source is higher than normal.
	RiskAnalysis_TOO_MUCH_TRAFFIC RiskAnalysis_ClassificationReason = 3
	// Interactions with the site were significantly different than expected
	// patterns.
	RiskAnalysis_UNEXPECTED_USAGE_PATTERNS RiskAnalysis_ClassificationReason = 4
	// Too little traffic has been received from this site thus far to generate
	// quality risk analysis.
	RiskAnalysis_LOW_CONFIDENCE_SCORE RiskAnalysis_ClassificationReason = 5
)

var RiskAnalysis_ClassificationReason_name = map[int32]string{
	0: "CLASSIFICATION_REASON_UNSPECIFIED",
	1: "AUTOMATION",
	2: "UNEXPECTED_ENVIRONMENT",
	3: "TOO_MUCH_TRAFFIC",
	4: "UNEXPECTED_USAGE_PATTERNS",
	5: "LOW_CONFIDENCE_SCORE",
}

var RiskAnalysis_ClassificationReason_value = map[string]int32{
	"CLASSIFICATION_REASON_UNSPECIFIED": 0,
	"AUTOMATION":                        1,
	"UNEXPECTED_ENVIRONMENT":            2,
	"TOO_MUCH_TRAFFIC":                  3,
	"UNEXPECTED_USAGE_PATTERNS":         4,
	"LOW_CONFIDENCE_SCORE":              5,
}

func (x RiskAnalysis_ClassificationReason) String() string {
	return proto.EnumName(RiskAnalysis_ClassificationReason_name, int32(x))
}

func (RiskAnalysis_ClassificationReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{5, 0}
}

// LINT.IfChange
// Enum that represents the types of invalid token reasons.
type TokenProperties_InvalidReason int32

const (
	// Default unspecified type.
	TokenProperties_INVALID_REASON_UNSPECIFIED TokenProperties_InvalidReason = 0
	// If the failure reason was not accounted for.
	TokenProperties_UNKNOWN_INVALID_REASON TokenProperties_InvalidReason = 1
	// The provided user verification token was malformed.
	TokenProperties_MALFORMED TokenProperties_InvalidReason = 2
	// The user verification token had expired.
	TokenProperties_EXPIRED TokenProperties_InvalidReason = 3
	// The user verification had already been seen.
	TokenProperties_DUPE TokenProperties_InvalidReason = 4
	// The user verification token was not present.
	TokenProperties_MISSING TokenProperties_InvalidReason = 5
)

var TokenProperties_InvalidReason_name = map[int32]string{
	0: "INVALID_REASON_UNSPECIFIED",
	1: "UNKNOWN_INVALID_REASON",
	2: "MALFORMED",
	3: "EXPIRED",
	4: "DUPE",
	5: "MISSING",
}

var TokenProperties_InvalidReason_value = map[string]int32{
	"INVALID_REASON_UNSPECIFIED": 0,
	"UNKNOWN_INVALID_REASON":     1,
	"MALFORMED":                  2,
	"EXPIRED":                    3,
	"DUPE":                       4,
	"MISSING":                    5,
}

func (x TokenProperties_InvalidReason) String() string {
	return proto.EnumName(TokenProperties_InvalidReason_name, int32(x))
}

func (TokenProperties_InvalidReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{6, 0}
}

// Enum that represents the integration types for web keys.
type WebKeySettings_IntegrationType int32

const (
	// Default type that indicates this enum hasn't been specified. This is not
	// a valid IntegrationType, one of the other types must be specified
	// instead.
	WebKeySettings_INTEGRATION_TYPE_UNSPECIFIED WebKeySettings_IntegrationType = 0
	// Only used to produce scores. It doesn't display the "I'm not a robot"
	// checkbox and never shows captcha challenges.
	WebKeySettings_SCORE WebKeySettings_IntegrationType = 1
	// Displays the "I'm not a robot" checkbox and may show captcha challenges
	// after it is checked.
	WebKeySettings_CHECKBOX WebKeySettings_IntegrationType = 2
	// Doesn't display the "I'm not a robot" checkbox, but may show captcha
	// challenges after risk analysis.
	WebKeySettings_INVISIBLE WebKeySettings_IntegrationType = 3
)

var WebKeySettings_IntegrationType_name = map[int32]string{
	0: "INTEGRATION_TYPE_UNSPECIFIED",
	1: "SCORE",
	2: "CHECKBOX",
	3: "INVISIBLE",
}

var WebKeySettings_IntegrationType_value = map[string]int32{
	"INTEGRATION_TYPE_UNSPECIFIED": 0,
	"SCORE":                        1,
	"CHECKBOX":                     2,
	"INVISIBLE":                    3,
}

func (x WebKeySettings_IntegrationType) String() string {
	return proto.EnumName(WebKeySettings_IntegrationType_name, int32(x))
}

func (WebKeySettings_IntegrationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{14, 0}
}

// Enum that represents the possible challenge frequency and difficulty
// configurations for a web key.
type WebKeySettings_ChallengeSecurityPreference int32

const (
	// Default type that indicates this enum hasn't been specified.
	WebKeySettings_CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED WebKeySettings_ChallengeSecurityPreference = 0
	// Key tends to show fewer and easier challenges.
	WebKeySettings_USABILITY WebKeySettings_ChallengeSecurityPreference = 1
	// Key tends to show balanced (in amount and difficulty) challenges.
	WebKeySettings_BALANCE WebKeySettings_ChallengeSecurityPreference = 2
	// Key tends to show more and harder challenges.
	WebKeySettings_SECURITY WebKeySettings_ChallengeSecurityPreference = 3
)

var WebKeySettings_ChallengeSecurityPreference_name = map[int32]string{
	0: "CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED",
	1: "USABILITY",
	2: "BALANCE",
	3: "SECURITY",
}

var WebKeySettings_ChallengeSecurityPreference_value = map[string]int32{
	"CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED": 0,
	"USABILITY": 1,
	"BALANCE":   2,
	"SECURITY":  3,
}

func (x WebKeySettings_ChallengeSecurityPreference) String() string {
	return proto.EnumName(WebKeySettings_ChallengeSecurityPreference_name, int32(x))
}

func (WebKeySettings_ChallengeSecurityPreference) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{14, 1}
}

// The create assessment request message.
type CreateAssessmentRequest struct {
	// Required. The name of the project in which the assessment will be created,
	// in the format "projects/{project}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The assessment details.
	Assessment           *Assessment `protobuf:"bytes,2,opt,name=assessment,proto3" json:"assessment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateAssessmentRequest) Reset()         { *m = CreateAssessmentRequest{} }
func (m *CreateAssessmentRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAssessmentRequest) ProtoMessage()    {}
func (*CreateAssessmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{0}
}

func (m *CreateAssessmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAssessmentRequest.Unmarshal(m, b)
}
func (m *CreateAssessmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAssessmentRequest.Marshal(b, m, deterministic)
}
func (m *CreateAssessmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAssessmentRequest.Merge(m, src)
}
func (m *CreateAssessmentRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAssessmentRequest.Size(m)
}
func (m *CreateAssessmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAssessmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAssessmentRequest proto.InternalMessageInfo

func (m *CreateAssessmentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAssessmentRequest) GetAssessment() *Assessment {
	if m != nil {
		return m.Assessment
	}
	return nil
}

// The request message to annotate an Assessment.
type AnnotateAssessmentRequest struct {
	// Required. The resource name of the Assessment, in the format
	// "projects/{project}/assessments/{assessment}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The annotation that will be assigned to the Event.
	Annotation           AnnotateAssessmentRequest_Annotation `protobuf:"varint,2,opt,name=annotation,proto3,enum=google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest_Annotation" json:"annotation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *AnnotateAssessmentRequest) Reset()         { *m = AnnotateAssessmentRequest{} }
func (m *AnnotateAssessmentRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateAssessmentRequest) ProtoMessage()    {}
func (*AnnotateAssessmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{1}
}

func (m *AnnotateAssessmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateAssessmentRequest.Unmarshal(m, b)
}
func (m *AnnotateAssessmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateAssessmentRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateAssessmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateAssessmentRequest.Merge(m, src)
}
func (m *AnnotateAssessmentRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateAssessmentRequest.Size(m)
}
func (m *AnnotateAssessmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateAssessmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateAssessmentRequest proto.InternalMessageInfo

func (m *AnnotateAssessmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AnnotateAssessmentRequest) GetAnnotation() AnnotateAssessmentRequest_Annotation {
	if m != nil {
		return m.Annotation
	}
	return AnnotateAssessmentRequest_ANNOTATION_UNSPECIFIED
}

// Empty response for AnnotateAssessment.
type AnnotateAssessmentResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateAssessmentResponse) Reset()         { *m = AnnotateAssessmentResponse{} }
func (m *AnnotateAssessmentResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateAssessmentResponse) ProtoMessage()    {}
func (*AnnotateAssessmentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{2}
}

func (m *AnnotateAssessmentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateAssessmentResponse.Unmarshal(m, b)
}
func (m *AnnotateAssessmentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateAssessmentResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateAssessmentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateAssessmentResponse.Merge(m, src)
}
func (m *AnnotateAssessmentResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateAssessmentResponse.Size(m)
}
func (m *AnnotateAssessmentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateAssessmentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateAssessmentResponse proto.InternalMessageInfo

// A recaptcha assessment resource.
type Assessment struct {
	// Output only. The resource name for the Assessment in the format
	// "projects/{project}/assessments/{assessment}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The event being assessed.
	Event *Event `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	// Output only. The risk analysis result for the event being assessed.
	RiskAnalysis *RiskAnalysis `protobuf:"bytes,3,opt,name=risk_analysis,json=riskAnalysis,proto3" json:"risk_analysis,omitempty"`
	// Output only. Properties of the provided event token.
	TokenProperties      *TokenProperties `protobuf:"bytes,4,opt,name=token_properties,json=tokenProperties,proto3" json:"token_properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Assessment) Reset()         { *m = Assessment{} }
func (m *Assessment) String() string { return proto.CompactTextString(m) }
func (*Assessment) ProtoMessage()    {}
func (*Assessment) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{3}
}

func (m *Assessment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Assessment.Unmarshal(m, b)
}
func (m *Assessment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Assessment.Marshal(b, m, deterministic)
}
func (m *Assessment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Assessment.Merge(m, src)
}
func (m *Assessment) XXX_Size() int {
	return xxx_messageInfo_Assessment.Size(m)
}
func (m *Assessment) XXX_DiscardUnknown() {
	xxx_messageInfo_Assessment.DiscardUnknown(m)
}

var xxx_messageInfo_Assessment proto.InternalMessageInfo

func (m *Assessment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Assessment) GetEvent() *Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *Assessment) GetRiskAnalysis() *RiskAnalysis {
	if m != nil {
		return m.RiskAnalysis
	}
	return nil
}

func (m *Assessment) GetTokenProperties() *TokenProperties {
	if m != nil {
		return m.TokenProperties
	}
	return nil
}

type Event struct {
	// Optional. The user response token provided by the reCAPTCHA client-side integration
	// on your site.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Optional. The site key that was used to invoke reCAPTCHA on your site and generate
	// the token.
	SiteKey string `protobuf:"bytes,2,opt,name=site_key,json=siteKey,proto3" json:"site_key,omitempty"`
	// Optional. The user agent present in the request from the user's device related to
	// this event.
	UserAgent string `protobuf:"bytes,3,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	// Optional. The IP address in the request from the user's device related to this event.
	UserIpAddress string `protobuf:"bytes,4,opt,name=user_ip_address,json=userIpAddress,proto3" json:"user_ip_address,omitempty"`
	// Optional. The expected action for this type of event. This should be the same action
	// provided at token generation time on client-side platforms already
	// integrated with recaptcha enterprise.
	ExpectedAction       string   `protobuf:"bytes,5,opt,name=expected_action,json=expectedAction,proto3" json:"expected_action,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{4}
}

func (m *Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Event.Unmarshal(m, b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Event.Marshal(b, m, deterministic)
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return xxx_messageInfo_Event.Size(m)
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

func (m *Event) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *Event) GetSiteKey() string {
	if m != nil {
		return m.SiteKey
	}
	return ""
}

func (m *Event) GetUserAgent() string {
	if m != nil {
		return m.UserAgent
	}
	return ""
}

func (m *Event) GetUserIpAddress() string {
	if m != nil {
		return m.UserIpAddress
	}
	return ""
}

func (m *Event) GetExpectedAction() string {
	if m != nil {
		return m.ExpectedAction
	}
	return ""
}

// Risk analysis result for an event.
type RiskAnalysis struct {
	// Legitimate event score from 0.0 to 1.0.
	// (1.0 means very likely legitimate traffic while 0.0 means very likely
	// non-legitimate traffic).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// Reasons contributing to the risk analysis verdict.
	Reasons              []RiskAnalysis_ClassificationReason `protobuf:"varint,2,rep,packed,name=reasons,proto3,enum=google.cloud.recaptchaenterprise.v1.RiskAnalysis_ClassificationReason" json:"reasons,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *RiskAnalysis) Reset()         { *m = RiskAnalysis{} }
func (m *RiskAnalysis) String() string { return proto.CompactTextString(m) }
func (*RiskAnalysis) ProtoMessage()    {}
func (*RiskAnalysis) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{5}
}

func (m *RiskAnalysis) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RiskAnalysis.Unmarshal(m, b)
}
func (m *RiskAnalysis) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RiskAnalysis.Marshal(b, m, deterministic)
}
func (m *RiskAnalysis) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RiskAnalysis.Merge(m, src)
}
func (m *RiskAnalysis) XXX_Size() int {
	return xxx_messageInfo_RiskAnalysis.Size(m)
}
func (m *RiskAnalysis) XXX_DiscardUnknown() {
	xxx_messageInfo_RiskAnalysis.DiscardUnknown(m)
}

var xxx_messageInfo_RiskAnalysis proto.InternalMessageInfo

func (m *RiskAnalysis) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *RiskAnalysis) GetReasons() []RiskAnalysis_ClassificationReason {
	if m != nil {
		return m.Reasons
	}
	return nil
}

type TokenProperties struct {
	// Whether the provided user response token is valid. When valid = false, the
	// reason could be specified in invalid_reason or it could also be due to
	// a user failing to solve a challenge or a sitekey mismatch (i.e the sitekey
	// used to generate the token was different than the one specified in the
	// assessment).
	Valid bool `protobuf:"varint,1,opt,name=valid,proto3" json:"valid,omitempty"`
	// Reason associated with the response when valid = false.
	InvalidReason TokenProperties_InvalidReason `protobuf:"varint,2,opt,name=invalid_reason,json=invalidReason,proto3,enum=google.cloud.recaptchaenterprise.v1.TokenProperties_InvalidReason" json:"invalid_reason,omitempty"`
	// The timestamp corresponding to the generation of the token.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The hostname of the page on which the token was generated.
	Hostname string `protobuf:"bytes,4,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Action name provided at token generation.
	Action               string   `protobuf:"bytes,5,opt,name=action,proto3" json:"action,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TokenProperties) Reset()         { *m = TokenProperties{} }
func (m *TokenProperties) String() string { return proto.CompactTextString(m) }
func (*TokenProperties) ProtoMessage()    {}
func (*TokenProperties) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{6}
}

func (m *TokenProperties) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TokenProperties.Unmarshal(m, b)
}
func (m *TokenProperties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TokenProperties.Marshal(b, m, deterministic)
}
func (m *TokenProperties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TokenProperties.Merge(m, src)
}
func (m *TokenProperties) XXX_Size() int {
	return xxx_messageInfo_TokenProperties.Size(m)
}
func (m *TokenProperties) XXX_DiscardUnknown() {
	xxx_messageInfo_TokenProperties.DiscardUnknown(m)
}

var xxx_messageInfo_TokenProperties proto.InternalMessageInfo

func (m *TokenProperties) GetValid() bool {
	if m != nil {
		return m.Valid
	}
	return false
}

func (m *TokenProperties) GetInvalidReason() TokenProperties_InvalidReason {
	if m != nil {
		return m.InvalidReason
	}
	return TokenProperties_INVALID_REASON_UNSPECIFIED
}

func (m *TokenProperties) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *TokenProperties) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *TokenProperties) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

// The create key request message.
type CreateKeyRequest struct {
	// Required. The name of the project in which the key will be created, in the
	// format "projects/{project}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Information to create a reCAPTCHA Enterprise key.
	Key                  *Key     `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateKeyRequest) Reset()         { *m = CreateKeyRequest{} }
func (m *CreateKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateKeyRequest) ProtoMessage()    {}
func (*CreateKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{7}
}

func (m *CreateKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateKeyRequest.Unmarshal(m, b)
}
func (m *CreateKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateKeyRequest.Merge(m, src)
}
func (m *CreateKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateKeyRequest.Size(m)
}
func (m *CreateKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateKeyRequest proto.InternalMessageInfo

func (m *CreateKeyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateKeyRequest) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

// The list keys request message.
type ListKeysRequest struct {
	// Required. The name of the project that contains the keys that will be
	// listed, in the format "projects/{project}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of keys to return. Default is 10. Max limit is
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous.
	// ListKeysRequest, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeysRequest) Reset()         { *m = ListKeysRequest{} }
func (m *ListKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListKeysRequest) ProtoMessage()    {}
func (*ListKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{8}
}

func (m *ListKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeysRequest.Unmarshal(m, b)
}
func (m *ListKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeysRequest.Marshal(b, m, deterministic)
}
func (m *ListKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeysRequest.Merge(m, src)
}
func (m *ListKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListKeysRequest.Size(m)
}
func (m *ListKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeysRequest proto.InternalMessageInfo

func (m *ListKeysRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListKeysRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListKeysRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response to request to list keys in a project.
type ListKeysResponse struct {
	// Key details.
	Keys []*Key `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// Token to retrieve the next page of results. It is set to empty if no keys
	// remain in results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListKeysResponse) Reset()         { *m = ListKeysResponse{} }
func (m *ListKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListKeysResponse) ProtoMessage()    {}
func (*ListKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{9}
}

func (m *ListKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListKeysResponse.Unmarshal(m, b)
}
func (m *ListKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListKeysResponse.Marshal(b, m, deterministic)
}
func (m *ListKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListKeysResponse.Merge(m, src)
}
func (m *ListKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListKeysResponse.Size(m)
}
func (m *ListKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListKeysResponse proto.InternalMessageInfo

func (m *ListKeysResponse) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *ListKeysResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The get key request message.
type GetKeyRequest struct {
	// Required. The name of the requested key, in the format
	// "projects/{project}/keys/{key}".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetKeyRequest) Reset()         { *m = GetKeyRequest{} }
func (m *GetKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetKeyRequest) ProtoMessage()    {}
func (*GetKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{10}
}

func (m *GetKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetKeyRequest.Unmarshal(m, b)
}
func (m *GetKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetKeyRequest.Merge(m, src)
}
func (m *GetKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetKeyRequest.Size(m)
}
func (m *GetKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetKeyRequest proto.InternalMessageInfo

func (m *GetKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The update key request message.
type UpdateKeyRequest struct {
	// Required. The key to update.
	Key *Key `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. The mask to control which field of the key get updated. If the mask is not
	// present, all fields will be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateKeyRequest) Reset()         { *m = UpdateKeyRequest{} }
func (m *UpdateKeyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateKeyRequest) ProtoMessage()    {}
func (*UpdateKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{11}
}

func (m *UpdateKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateKeyRequest.Unmarshal(m, b)
}
func (m *UpdateKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateKeyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateKeyRequest.Merge(m, src)
}
func (m *UpdateKeyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateKeyRequest.Size(m)
}
func (m *UpdateKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateKeyRequest proto.InternalMessageInfo

func (m *UpdateKeyRequest) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *UpdateKeyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The delete key request message.
type DeleteKeyRequest struct {
	// Required. The name of the key to be deleted, in the format
	// "projects/{project}/keys/{key}".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteKeyRequest) Reset()         { *m = DeleteKeyRequest{} }
func (m *DeleteKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteKeyRequest) ProtoMessage()    {}
func (*DeleteKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{12}
}

func (m *DeleteKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteKeyRequest.Unmarshal(m, b)
}
func (m *DeleteKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteKeyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteKeyRequest.Merge(m, src)
}
func (m *DeleteKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteKeyRequest.Size(m)
}
func (m *DeleteKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteKeyRequest proto.InternalMessageInfo

func (m *DeleteKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A key used to identify and configure applications (web and/or mobile) that
// use reCAPTCHA Enterprise.
type Key struct {
	// The resource name for the Key in the format
	// "projects/{project}/keys/{key}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human-readable display name of this key. Modifiable by user.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Platform specific settings for this key. The key can only be used on one
	// platform, the one it has settings for.
	//
	// Types that are valid to be assigned to PlatformSettings:
	//	*Key_WebSettings
	//	*Key_AndroidSettings
	//	*Key_IosSettings
	PlatformSettings isKey_PlatformSettings `protobuf_oneof:"platform_settings"`
	// Optional. See <a href="https://cloud.google.com/recaptcha-enterprise/docs/labels">
	// Creating and managing labels</a>.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The timestamp corresponding to the creation of this Key.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Key) Reset()         { *m = Key{} }
func (m *Key) String() string { return proto.CompactTextString(m) }
func (*Key) ProtoMessage()    {}
func (*Key) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{13}
}

func (m *Key) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Key.Unmarshal(m, b)
}
func (m *Key) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Key.Marshal(b, m, deterministic)
}
func (m *Key) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Key.Merge(m, src)
}
func (m *Key) XXX_Size() int {
	return xxx_messageInfo_Key.Size(m)
}
func (m *Key) XXX_DiscardUnknown() {
	xxx_messageInfo_Key.DiscardUnknown(m)
}

var xxx_messageInfo_Key proto.InternalMessageInfo

func (m *Key) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Key) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

type isKey_PlatformSettings interface {
	isKey_PlatformSettings()
}

type Key_WebSettings struct {
	WebSettings *WebKeySettings `protobuf:"bytes,3,opt,name=web_settings,json=webSettings,proto3,oneof"`
}

type Key_AndroidSettings struct {
	AndroidSettings *AndroidKeySettings `protobuf:"bytes,4,opt,name=android_settings,json=androidSettings,proto3,oneof"`
}

type Key_IosSettings struct {
	IosSettings *IOSKeySettings `protobuf:"bytes,5,opt,name=ios_settings,json=iosSettings,proto3,oneof"`
}

func (*Key_WebSettings) isKey_PlatformSettings() {}

func (*Key_AndroidSettings) isKey_PlatformSettings() {}

func (*Key_IosSettings) isKey_PlatformSettings() {}

func (m *Key) GetPlatformSettings() isKey_PlatformSettings {
	if m != nil {
		return m.PlatformSettings
	}
	return nil
}

func (m *Key) GetWebSettings() *WebKeySettings {
	if x, ok := m.GetPlatformSettings().(*Key_WebSettings); ok {
		return x.WebSettings
	}
	return nil
}

func (m *Key) GetAndroidSettings() *AndroidKeySettings {
	if x, ok := m.GetPlatformSettings().(*Key_AndroidSettings); ok {
		return x.AndroidSettings
	}
	return nil
}

func (m *Key) GetIosSettings() *IOSKeySettings {
	if x, ok := m.GetPlatformSettings().(*Key_IosSettings); ok {
		return x.IosSettings
	}
	return nil
}

func (m *Key) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Key) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Key) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Key_WebSettings)(nil),
		(*Key_AndroidSettings)(nil),
		(*Key_IosSettings)(nil),
	}
}

// Settings specific to keys that can be used by websites.
type WebKeySettings struct {
	// If set to true, it means allowed_domains will not be enforced.
	AllowAllDomains bool `protobuf:"varint,3,opt,name=allow_all_domains,json=allowAllDomains,proto3" json:"allow_all_domains,omitempty"`
	// Domains or subdomains of websites allowed to use the key. All subdomains
	// of an allowed domain are automatically allowed. A valid domain requires a
	// host and must not include any path, port, query or fragment.
	// Examples: 'example.com' or 'subdomain.example.com'
	AllowedDomains []string `protobuf:"bytes,1,rep,name=allowed_domains,json=allowedDomains,proto3" json:"allowed_domains,omitempty"`
	// Required. Whether this key can be used on AMP (Accelerated Mobile Pages) websites.
	AllowAmpTraffic bool `protobuf:"varint,2,opt,name=allow_amp_traffic,json=allowAmpTraffic,proto3" json:"allow_amp_traffic,omitempty"`
	// Required. Describes how this key is integrated with the website.
	IntegrationType WebKeySettings_IntegrationType `protobuf:"varint,4,opt,name=integration_type,json=integrationType,proto3,enum=google.cloud.recaptchaenterprise.v1.WebKeySettings_IntegrationType" json:"integration_type,omitempty"`
	// Settings for the frequency and difficulty at which this key triggers
	// captcha challenges. This should only be specified for IntegrationTypes
	// CHECKBOX and INVISIBLE.
	ChallengeSecurityPreference WebKeySettings_ChallengeSecurityPreference `protobuf:"varint,5,opt,name=challenge_security_preference,json=challengeSecurityPreference,proto3,enum=google.cloud.recaptchaenterprise.v1.WebKeySettings_ChallengeSecurityPreference" json:"challenge_security_preference,omitempty"`
	XXX_NoUnkeyedLiteral        struct{}                                   `json:"-"`
	XXX_unrecognized            []byte                                     `json:"-"`
	XXX_sizecache               int32                                      `json:"-"`
}

func (m *WebKeySettings) Reset()         { *m = WebKeySettings{} }
func (m *WebKeySettings) String() string { return proto.CompactTextString(m) }
func (*WebKeySettings) ProtoMessage()    {}
func (*WebKeySettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{14}
}

func (m *WebKeySettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WebKeySettings.Unmarshal(m, b)
}
func (m *WebKeySettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WebKeySettings.Marshal(b, m, deterministic)
}
func (m *WebKeySettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WebKeySettings.Merge(m, src)
}
func (m *WebKeySettings) XXX_Size() int {
	return xxx_messageInfo_WebKeySettings.Size(m)
}
func (m *WebKeySettings) XXX_DiscardUnknown() {
	xxx_messageInfo_WebKeySettings.DiscardUnknown(m)
}

var xxx_messageInfo_WebKeySettings proto.InternalMessageInfo

func (m *WebKeySettings) GetAllowAllDomains() bool {
	if m != nil {
		return m.AllowAllDomains
	}
	return false
}

func (m *WebKeySettings) GetAllowedDomains() []string {
	if m != nil {
		return m.AllowedDomains
	}
	return nil
}

func (m *WebKeySettings) GetAllowAmpTraffic() bool {
	if m != nil {
		return m.AllowAmpTraffic
	}
	return false
}

func (m *WebKeySettings) GetIntegrationType() WebKeySettings_IntegrationType {
	if m != nil {
		return m.IntegrationType
	}
	return WebKeySettings_INTEGRATION_TYPE_UNSPECIFIED
}

func (m *WebKeySettings) GetChallengeSecurityPreference() WebKeySettings_ChallengeSecurityPreference {
	if m != nil {
		return m.ChallengeSecurityPreference
	}
	return WebKeySettings_CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED
}

// Settings specific to keys that can be used by Android apps.
type AndroidKeySettings struct {
	// Android package names of apps allowed to use the key.
	// Example: 'com.companyname.appname'
	AllowedPackageNames  []string `protobuf:"bytes,1,rep,name=allowed_package_names,json=allowedPackageNames,proto3" json:"allowed_package_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AndroidKeySettings) Reset()         { *m = AndroidKeySettings{} }
func (m *AndroidKeySettings) String() string { return proto.CompactTextString(m) }
func (*AndroidKeySettings) ProtoMessage()    {}
func (*AndroidKeySettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{15}
}

func (m *AndroidKeySettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AndroidKeySettings.Unmarshal(m, b)
}
func (m *AndroidKeySettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AndroidKeySettings.Marshal(b, m, deterministic)
}
func (m *AndroidKeySettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AndroidKeySettings.Merge(m, src)
}
func (m *AndroidKeySettings) XXX_Size() int {
	return xxx_messageInfo_AndroidKeySettings.Size(m)
}
func (m *AndroidKeySettings) XXX_DiscardUnknown() {
	xxx_messageInfo_AndroidKeySettings.DiscardUnknown(m)
}

var xxx_messageInfo_AndroidKeySettings proto.InternalMessageInfo

func (m *AndroidKeySettings) GetAllowedPackageNames() []string {
	if m != nil {
		return m.AllowedPackageNames
	}
	return nil
}

// Settings specific to keys that can be used by iOS apps.
type IOSKeySettings struct {
	// iOS bundle ids of apps allowed to use the key.
	// Example: 'com.companyname.productname.appname'
	AllowedBundleIds     []string `protobuf:"bytes,1,rep,name=allowed_bundle_ids,json=allowedBundleIds,proto3" json:"allowed_bundle_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IOSKeySettings) Reset()         { *m = IOSKeySettings{} }
func (m *IOSKeySettings) String() string { return proto.CompactTextString(m) }
func (*IOSKeySettings) ProtoMessage()    {}
func (*IOSKeySettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_f777376f650e105f, []int{16}
}

func (m *IOSKeySettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IOSKeySettings.Unmarshal(m, b)
}
func (m *IOSKeySettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IOSKeySettings.Marshal(b, m, deterministic)
}
func (m *IOSKeySettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IOSKeySettings.Merge(m, src)
}
func (m *IOSKeySettings) XXX_Size() int {
	return xxx_messageInfo_IOSKeySettings.Size(m)
}
func (m *IOSKeySettings) XXX_DiscardUnknown() {
	xxx_messageInfo_IOSKeySettings.DiscardUnknown(m)
}

var xxx_messageInfo_IOSKeySettings proto.InternalMessageInfo

func (m *IOSKeySettings) GetAllowedBundleIds() []string {
	if m != nil {
		return m.AllowedBundleIds
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest_Annotation", AnnotateAssessmentRequest_Annotation_name, AnnotateAssessmentRequest_Annotation_value)
	proto.RegisterEnum("google.cloud.recaptchaenterprise.v1.RiskAnalysis_ClassificationReason", RiskAnalysis_ClassificationReason_name, RiskAnalysis_ClassificationReason_value)
	proto.RegisterEnum("google.cloud.recaptchaenterprise.v1.TokenProperties_InvalidReason", TokenProperties_InvalidReason_name, TokenProperties_InvalidReason_value)
	proto.RegisterEnum("google.cloud.recaptchaenterprise.v1.WebKeySettings_IntegrationType", WebKeySettings_IntegrationType_name, WebKeySettings_IntegrationType_value)
	proto.RegisterEnum("google.cloud.recaptchaenterprise.v1.WebKeySettings_ChallengeSecurityPreference", WebKeySettings_ChallengeSecurityPreference_name, WebKeySettings_ChallengeSecurityPreference_value)
	proto.RegisterType((*CreateAssessmentRequest)(nil), "google.cloud.recaptchaenterprise.v1.CreateAssessmentRequest")
	proto.RegisterType((*AnnotateAssessmentRequest)(nil), "google.cloud.recaptchaenterprise.v1.AnnotateAssessmentRequest")
	proto.RegisterType((*AnnotateAssessmentResponse)(nil), "google.cloud.recaptchaenterprise.v1.AnnotateAssessmentResponse")
	proto.RegisterType((*Assessment)(nil), "google.cloud.recaptchaenterprise.v1.Assessment")
	proto.RegisterType((*Event)(nil), "google.cloud.recaptchaenterprise.v1.Event")
	proto.RegisterType((*RiskAnalysis)(nil), "google.cloud.recaptchaenterprise.v1.RiskAnalysis")
	proto.RegisterType((*TokenProperties)(nil), "google.cloud.recaptchaenterprise.v1.TokenProperties")
	proto.RegisterType((*CreateKeyRequest)(nil), "google.cloud.recaptchaenterprise.v1.CreateKeyRequest")
	proto.RegisterType((*ListKeysRequest)(nil), "google.cloud.recaptchaenterprise.v1.ListKeysRequest")
	proto.RegisterType((*ListKeysResponse)(nil), "google.cloud.recaptchaenterprise.v1.ListKeysResponse")
	proto.RegisterType((*GetKeyRequest)(nil), "google.cloud.recaptchaenterprise.v1.GetKeyRequest")
	proto.RegisterType((*UpdateKeyRequest)(nil), "google.cloud.recaptchaenterprise.v1.UpdateKeyRequest")
	proto.RegisterType((*DeleteKeyRequest)(nil), "google.cloud.recaptchaenterprise.v1.DeleteKeyRequest")
	proto.RegisterType((*Key)(nil), "google.cloud.recaptchaenterprise.v1.Key")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recaptchaenterprise.v1.Key.LabelsEntry")
	proto.RegisterType((*WebKeySettings)(nil), "google.cloud.recaptchaenterprise.v1.WebKeySettings")
	proto.RegisterType((*AndroidKeySettings)(nil), "google.cloud.recaptchaenterprise.v1.AndroidKeySettings")
	proto.RegisterType((*IOSKeySettings)(nil), "google.cloud.recaptchaenterprise.v1.IOSKeySettings")
}

func init() {
	proto.RegisterFile("google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto", fileDescriptor_f777376f650e105f)
}

var fileDescriptor_f777376f650e105f = []byte{
	// 2117 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xcd, 0x73, 0xdb, 0xc6,
	0x15, 0x0f, 0x48, 0x51, 0x16, 0x9f, 0xbe, 0x90, 0x8d, 0x6b, 0xcb, 0xf4, 0x47, 0x65, 0xb8, 0x4d,
	0x1c, 0xc5, 0x26, 0x47, 0x72, 0x3c, 0x6d, 0x95, 0x4f, 0x10, 0x84, 0x64, 0x54, 0x14, 0xc8, 0x02,
	0xa0, 0x6c, 0x37, 0x9e, 0x41, 0x21, 0x70, 0x45, 0xa1, 0x02, 0x01, 0x14, 0x0b, 0x49, 0x66, 0x3c,
	0xee, 0x74, 0xd2, 0x63, 0x7b, 0x6a, 0xa6, 0xd3, 0x43, 0xa7, 0x33, 0x9d, 0x4e, 0x4f, 0xfd, 0x0b,
	0x7a, 0xe8, 0x25, 0xd7, 0x1c, 0x72, 0x68, 0x6f, 0x39, 0xf9, 0xd0, 0x93, 0xff, 0x80, 0x1e, 0x7a,
	0xea, 0x60, 0x17, 0x00, 0x3f, 0x4c, 0xbb, 0xa4, 0xda, 0xdc, 0xb8, 0xef, 0xf3, 0xb7, 0xef, 0xbd,
	0x7d, 0xef, 0x81, 0xf0, 0x41, 0xc7, 0xf7, 0x3b, 0x2e, 0xae, 0xd8, 0xae, 0x7f, 0xdc, 0xae, 0x84,
	0xd8, 0xb6, 0x82, 0xc8, 0x3e, 0xb4, 0xb0, 0x17, 0xe1, 0x30, 0x08, 0x1d, 0x82, 0x2b, 0x27, 0xeb,
	0xe3, 0xc8, 0xe5, 0x20, 0xf4, 0x23, 0x1f, 0xdd, 0x60, 0xea, 0x65, 0xaa, 0x5e, 0x1e, 0x27, 0x77,
	0xb2, 0x5e, 0xba, 0x92, 0xf8, 0xb0, 0x02, 0xa7, 0x62, 0x79, 0x9e, 0x1f, 0x59, 0x91, 0xe3, 0x7b,
	0x84, 0x99, 0x28, 0x5d, 0x1c, 0xe0, 0xda, 0xae, 0x83, 0xbd, 0x28, 0x61, 0x7c, 0x7b, 0x80, 0x71,
	0xe0, 0x60, 0xb7, 0x6d, 0xee, 0xe3, 0x43, 0xeb, 0xc4, 0xf1, 0xc3, 0x44, 0xe0, 0xd2, 0x80, 0x40,
	0x88, 0x89, 0x7f, 0x1c, 0xda, 0x09, 0xae, 0xd2, 0xe5, 0x84, 0x45, 0x4f, 0xfb, 0xc7, 0x07, 0x15,
	0xdc, 0x0d, 0xa2, 0x5e, 0xc2, 0x5c, 0x1d, 0x65, 0x32, 0xeb, 0x5d, 0x8b, 0x1c, 0x8d, 0xb8, 0xce,
	0x24, 0x22, 0xa7, 0x8b, 0x49, 0x64, 0x75, 0x03, 0x26, 0x20, 0xfc, 0x8d, 0x83, 0x8b, 0x52, 0x88,
	0xad, 0x08, 0x8b, 0x84, 0x60, 0x42, 0xba, 0xd8, 0x8b, 0x34, 0xfc, 0xb3, 0x63, 0x4c, 0x22, 0xb4,
	0x03, 0xb3, 0x81, 0x15, 0x62, 0x2f, 0x5a, 0xe1, 0x56, 0xb9, 0x9b, 0xc5, 0xea, 0x9d, 0x67, 0x62,
	0xee, 0xdf, 0xe2, 0x6d, 0x78, 0x87, 0x06, 0x29, 0x05, 0xda, 0xb5, 0x3c, 0xab, 0x83, 0xc3, 0x32,
	0xf3, 0x64, 0x05, 0x0e, 0x29, 0xdb, 0x7e, 0xb7, 0xd2, 0x0c, 0xfd, 0x9f, 0x62, 0x3b, 0xd2, 0x12,
	0x13, 0xc8, 0x00, 0xb0, 0x32, 0x0f, 0x2b, 0xb9, 0x55, 0xee, 0xe6, 0xfc, 0x46, 0xa5, 0x3c, 0x41,
	0xd4, 0xcb, 0x7d, 0x60, 0xd5, 0xfc, 0x33, 0x31, 0xa7, 0x0d, 0xd8, 0x11, 0xbe, 0xca, 0xc1, 0x25,
	0x91, 0x65, 0x62, 0xcc, 0x05, 0x14, 0x98, 0xf1, 0xac, 0x2e, 0x4e, 0xe0, 0xdf, 0xa5, 0xf0, 0x2b,
	0x70, 0x7b, 0x9c, 0x9f, 0x11, 0xf4, 0x03, 0xb6, 0xa8, 0x09, 0xe4, 0x01, 0xf4, 0x33, 0x4e, 0xe1,
	0x2f, 0x6d, 0x28, 0x93, 0xc1, 0x7f, 0x19, 0xbc, 0x94, 0xe3, 0xf8, 0x5e, 0x7a, 0xb1, 0x8c, 0x20,
	0x9c, 0x00, 0xf4, 0xd9, 0xa8, 0x04, 0x17, 0x44, 0x55, 0x6d, 0x18, 0xa2, 0xa1, 0x34, 0x54, 0xb3,
	0xa5, 0xea, 0x4d, 0x59, 0x52, 0xb6, 0x14, 0xb9, 0xc6, 0xbf, 0x86, 0x96, 0x00, 0xea, 0xf2, 0xb6,
	0x62, 0x28, 0xbb, 0xa2, 0x21, 0xf3, 0x5c, 0x7c, 0xde, 0xd2, 0xc4, 0x56, 0xad, 0x55, 0x97, 0x55,
	0x83, 0xcf, 0xa1, 0xf3, 0xc0, 0x37, 0x45, 0x5d, 0xbf, 0xdf, 0xd0, 0x6a, 0xa6, 0xd4, 0xd0, 0x34,
	0x59, 0x32, 0xf8, 0x3c, 0xba, 0x00, 0x28, 0xa3, 0x2a, 0x6a, 0x4a, 0x9f, 0x11, 0xae, 0x40, 0x69,
	0x1c, 0x60, 0x12, 0xf8, 0x1e, 0xc1, 0xc2, 0xaf, 0xf2, 0x00, 0x7d, 0x32, 0xba, 0x38, 0x14, 0xdf,
	0xfc, 0x33, 0x31, 0x9f, 0x44, 0xeb, 0x63, 0x28, 0xe0, 0x93, 0x7e, 0x9e, 0xd7, 0x26, 0x0a, 0x94,
	0x1c, 0x6b, 0x68, 0x4c, 0x11, 0x7d, 0x02, 0x8b, 0xa1, 0x43, 0x8e, 0x4c, 0xcb, 0xb3, 0xdc, 0x1e,
	0x71, 0xc8, 0x4a, 0x9e, 0x5a, 0x5a, 0x9f, 0xc8, 0x92, 0xe6, 0x90, 0x23, 0x31, 0x51, 0x64, 0xb0,
	0x16, 0xc2, 0x01, 0x12, 0x6a, 0x03, 0x1f, 0xf9, 0x47, 0xd8, 0x33, 0x83, 0xd0, 0x0f, 0x70, 0x18,
	0x39, 0x98, 0xac, 0xcc, 0x50, 0xfb, 0xef, 0x4e, 0x64, 0xdf, 0x88, 0x95, 0x9b, 0x99, 0x2e, 0x73,
	0xb1, 0x1c, 0x0d, 0x53, 0x37, 0xcd, 0xe7, 0xe2, 0xa3, 0x29, 0x8b, 0x0d, 0xbd, 0x13, 0xb0, 0x67,
	0x43, 0x2a, 0x4f, 0x92, 0x5f, 0x4f, 0x2b, 0xfd, 0x72, 0x27, 0x95, 0x27, 0xfd, 0xc3, 0x53, 0xe1,
	0x0b, 0x0e, 0x0a, 0x34, 0x68, 0xe8, 0x12, 0x14, 0xa8, 0xf7, 0x7e, 0x26, 0x38, 0x8d, 0x51, 0xd0,
	0x35, 0x98, 0x23, 0x4e, 0x84, 0xcd, 0x23, 0xdc, 0xa3, 0xd9, 0x48, 0xb8, 0xe7, 0x62, 0xe2, 0x0e,
	0xee, 0x21, 0x01, 0xe0, 0x98, 0xe0, 0xd0, 0xb4, 0x3a, 0x71, 0xbe, 0xf2, 0x7d, 0x89, 0x62, 0x4c,
	0x16, 0x3b, 0x14, 0x15, 0x2c, 0x53, 0x19, 0x27, 0x30, 0xad, 0x76, 0xfc, 0xf0, 0x59, 0xb8, 0x12,
	0xc1, 0xc5, 0x98, 0xa7, 0x04, 0x22, 0xe3, 0xa0, 0x5b, 0xb0, 0x8c, 0x1f, 0x07, 0xd8, 0x8e, 0x70,
	0xdb, 0xb4, 0x6c, 0xfa, 0x5c, 0x0a, 0x7d, 0xe1, 0xa5, 0x94, 0x27, 0x52, 0x96, 0xf0, 0x45, 0x0e,
	0x16, 0x06, 0xd3, 0x85, 0xce, 0x43, 0x81, 0xd8, 0x7e, 0xc8, 0x8a, 0x2a, 0xa7, 0xb1, 0x03, 0xfa,
	0x09, 0x9c, 0x0b, 0xb1, 0x45, 0x7c, 0x8f, 0xac, 0xe4, 0x56, 0xf3, 0x37, 0x97, 0x36, 0xb6, 0xa6,
	0x2e, 0x84, 0xb2, 0xe4, 0x5a, 0x84, 0x38, 0x07, 0x8e, 0x4d, 0xdf, 0x94, 0x46, 0xcd, 0x69, 0xa9,
	0x59, 0xe1, 0xaf, 0x1c, 0x9c, 0x1f, 0x27, 0x81, 0xbe, 0x0b, 0xd7, 0xa5, 0xba, 0xa8, 0xeb, 0xca,
	0x96, 0x22, 0xb1, 0xf7, 0xa7, 0xc9, 0xa2, 0x3e, 0xee, 0x19, 0x8a, 0x2d, 0xa3, 0xb1, 0x4b, 0x45,
	0x78, 0x2e, 0x7e, 0xb2, 0x2d, 0x55, 0x7e, 0xd0, 0x94, 0x25, 0x43, 0xae, 0x99, 0xb2, 0xba, 0xa7,
	0x68, 0x0d, 0x75, 0x37, 0x7b, 0x92, 0x46, 0xa3, 0x61, 0xee, 0xb6, 0xa4, 0x7b, 0xa6, 0xa1, 0x89,
	0x5b, 0x5b, 0x8a, 0xc4, 0xe7, 0xd1, 0x55, 0xb8, 0x34, 0xa0, 0xd1, 0xd2, 0xc5, 0x6d, 0xd9, 0x6c,
	0x8a, 0x86, 0x21, 0x6b, 0xaa, 0xce, 0xcf, 0xa0, 0x15, 0x38, 0x5f, 0x6f, 0xdc, 0x37, 0xa5, 0x86,
	0xba, 0xa5, 0xd4, 0x64, 0x55, 0x92, 0x4d, 0x5d, 0x6a, 0x68, 0x32, 0x5f, 0x10, 0x7e, 0x99, 0x87,
	0xe5, 0x91, 0x92, 0x8c, 0xc3, 0x78, 0x62, 0xb9, 0x4e, 0x9b, 0x86, 0x71, 0x4e, 0x63, 0x07, 0xe4,
	0xc0, 0x92, 0xe3, 0xd1, 0x9f, 0x26, 0xbb, 0x77, 0xd2, 0xc9, 0xaa, 0x67, 0x29, 0xfb, 0xb2, 0xc2,
	0x4c, 0x25, 0x91, 0x5c, 0x74, 0x06, 0x8f, 0xe8, 0x3d, 0x98, 0xb7, 0xe9, 0x5c, 0x31, 0xe3, 0x91,
	0x93, 0x3c, 0xdf, 0x52, 0xea, 0x27, 0x9d, 0x47, 0x65, 0x23, 0x9d, 0x47, 0x1a, 0x30, 0xf1, 0x98,
	0x80, 0x4a, 0x30, 0x77, 0xe8, 0x93, 0x88, 0x36, 0x17, 0x5a, 0x69, 0x5a, 0x76, 0x46, 0x17, 0x60,
	0x76, 0xb0, 0xac, 0xb4, 0xe4, 0x24, 0xfc, 0x1c, 0x16, 0x87, 0x00, 0xa1, 0x6b, 0x50, 0x52, 0xd4,
	0x3d, 0xb1, 0xae, 0xd4, 0xc6, 0x67, 0x8c, 0x66, 0x68, 0x47, 0x6d, 0xdc, 0x57, 0xcd, 0x61, 0x39,
	0x9e, 0x43, 0x8b, 0x50, 0xdc, 0x15, 0xeb, 0x5b, 0x0d, 0x6d, 0x57, 0xae, 0xf1, 0x39, 0x34, 0x0f,
	0xe7, 0xe4, 0x07, 0x4d, 0x45, 0x93, 0x6b, 0x7c, 0x1e, 0xcd, 0xc1, 0x4c, 0xad, 0xd5, 0x94, 0xf9,
	0x99, 0x98, 0xbc, 0xab, 0xe8, 0xba, 0xa2, 0x6e, 0xf3, 0x05, 0xe1, 0x8f, 0x1c, 0xf0, 0x6c, 0x92,
	0xee, 0xe0, 0xde, 0x37, 0x32, 0x42, 0x3f, 0x82, 0x7c, 0xfa, 0x8a, 0xe7, 0x37, 0x6e, 0x4e, 0x94,
	0xb2, 0x1d, 0xdc, 0x63, 0xb3, 0x25, 0xd6, 0x14, 0xfe, 0xcc, 0xc1, 0x72, 0xdd, 0x21, 0xd1, 0x0e,
	0xee, 0x91, 0x6f, 0x04, 0xe1, 0x2a, 0x14, 0x03, 0xab, 0x83, 0x4d, 0xe2, 0x7c, 0x8a, 0x29, 0xce,
	0x02, 0x7b, 0xf5, 0x73, 0x31, 0x55, 0x77, 0x3e, 0xc5, 0x71, 0xbb, 0xa1, 0x12, 0xac, 0x5d, 0x0d,
	0xb6, 0x9b, 0x98, 0x4c, 0x2b, 0x4c, 0x78, 0x0c, 0x7c, 0x1f, 0x25, 0x9b, 0x3c, 0xe8, 0x7d, 0x98,
	0x39, 0xc2, 0x3d, 0xb2, 0xc2, 0xad, 0xe6, 0xa7, 0xb9, 0xbc, 0x46, 0xb5, 0xd0, 0x9b, 0xb0, 0xec,
	0xe1, 0xc7, 0x91, 0x39, 0xe0, 0x9a, 0xf6, 0x42, 0x6d, 0x31, 0x26, 0x37, 0x33, 0xcf, 0x3a, 0x2c,
	0x6e, 0xe3, 0x68, 0x20, 0x7f, 0xd5, 0xa1, 0x09, 0x57, 0xa6, 0xb1, 0xb9, 0x09, 0x6f, 0x4e, 0xd0,
	0xd4, 0xa9, 0xf3, 0x58, 0x57, 0xf8, 0x2d, 0x07, 0x7c, 0x2b, 0x68, 0x0f, 0x17, 0x46, 0x92, 0x4b,
	0xee, 0xac, 0xb9, 0x44, 0x1f, 0xc3, 0xfc, 0x31, 0x35, 0x4a, 0xd7, 0xbd, 0xa4, 0x28, 0x5e, 0x7c,
	0x5f, 0x5b, 0xf1, 0x46, 0xb8, 0x6b, 0x91, 0x23, 0x16, 0x65, 0x60, 0x3a, 0x31, 0x41, 0xd8, 0x03,
	0xbe, 0x86, 0x5d, 0x3c, 0x04, 0xeb, 0xff, 0x71, 0xdf, 0xcf, 0x0a, 0x90, 0x8f, 0x27, 0x0b, 0x1a,
	0xb4, 0x95, 0x2c, 0x06, 0xd7, 0x61, 0xa1, 0xed, 0x90, 0xc0, 0xb5, 0x7a, 0x26, 0xe5, 0xb1, 0x2c,
	0xcc, 0x27, 0x34, 0x35, 0x16, 0x79, 0x00, 0x0b, 0xa7, 0x78, 0xdf, 0x24, 0x38, 0x8a, 0x1c, 0xaf,
	0x93, 0x0e, 0xfe, 0x3b, 0x13, 0x85, 0xe8, 0x3e, 0xde, 0xdf, 0xc1, 0x3d, 0x3d, 0x51, 0xbd, 0xf7,
	0x9a, 0x36, 0x7f, 0x8a, 0xf7, 0xd3, 0x63, 0x3c, 0xf6, 0x2d, 0xaf, 0x1d, 0xfa, 0x4e, 0xbb, 0x6f,
	0x9d, 0x8d, 0xfd, 0xef, 0x4d, 0xb8, 0xc9, 0x51, 0xe5, 0x61, 0x0f, 0xcb, 0x89, 0xc9, 0xcc, 0xcb,
	0x03, 0x58, 0x70, 0x7c, 0xd2, 0xf7, 0x50, 0x98, 0x02, 0xbf, 0xd2, 0xd0, 0x47, 0xf0, 0x3b, 0x3e,
	0xc9, 0x2c, 0xff, 0x08, 0x66, 0x5d, 0x6b, 0x1f, 0xbb, 0x64, 0x65, 0x96, 0xbe, 0x82, 0x77, 0x27,
	0x2d, 0x9b, 0x72, 0x9d, 0xaa, 0xc9, 0x5e, 0x14, 0xf6, 0x58, 0x1d, 0x24, 0x86, 0x46, 0xbb, 0xf4,
	0xb9, 0x69, 0xba, 0x74, 0xe9, 0x07, 0x30, 0x3f, 0x60, 0x18, 0xf1, 0xfd, 0x92, 0x2e, 0xb2, 0x1a,
	0x65, 0x43, 0xe8, 0x38, 0x4d, 0x33, 0x3b, 0x6c, 0xe6, 0xbe, 0xcf, 0x6d, 0xfe, 0xf0, 0xb9, 0xb8,
	0x3d, 0x69, 0x59, 0xa1, 0xab, 0x63, 0x96, 0xa2, 0xf8, 0x59, 0x57, 0x9e, 0x1c, 0xe1, 0xde, 0xd3,
	0xea, 0x1b, 0xf0, 0x7a, 0xe0, 0x5a, 0xd1, 0x81, 0x1f, 0x76, 0xb3, 0xa8, 0x0b, 0xff, 0x9a, 0x81,
	0xa5, 0xe1, 0x6a, 0x40, 0x6b, 0xf0, 0xba, 0xe5, 0xba, 0xfe, 0xa9, 0x69, 0xb9, 0xae, 0xd9, 0xf6,
	0xbb, 0x96, 0xe3, 0xb1, 0xea, 0x9a, 0xd3, 0x96, 0x29, 0x43, 0x74, 0xdd, 0x1a, 0x23, 0xa3, 0xb7,
	0x80, 0x91, 0x70, 0x3b, 0x93, 0x8c, 0x3b, 0x4f, 0x51, 0x5b, 0x4a, 0xc8, 0xa9, 0x60, 0x25, 0x33,
	0xda, 0x0d, 0xcc, 0x28, 0xb4, 0x0e, 0x0e, 0x1c, 0x9b, 0x5e, 0x77, 0x8e, 0xbd, 0xd5, 0xc4, 0x72,
	0x37, 0x30, 0x18, 0x0f, 0x11, 0xe0, 0x1d, 0x2f, 0xc2, 0x9d, 0x90, 0xee, 0x18, 0x66, 0xd4, 0x0b,
	0xd8, 0x88, 0x5b, 0xda, 0x90, 0xce, 0x50, 0xe2, 0x65, 0xa5, 0x6f, 0xcb, 0xe8, 0x05, 0x38, 0x71,
	0xea, 0x0c, 0x53, 0xd1, 0xe7, 0x1c, 0x5c, 0xb5, 0x0f, 0x2d, 0xd7, 0xc5, 0x5e, 0xdc, 0x9d, 0xb1,
	0x7d, 0x1c, 0x3a, 0x51, 0xcf, 0x0c, 0x42, 0x7c, 0x80, 0x43, 0xec, 0xd9, 0x98, 0x56, 0xe9, 0xd2,
	0x46, 0xe3, 0x2c, 0x10, 0xa4, 0xd4, 0xb0, 0x9e, 0xd8, 0x6d, 0x66, 0x66, 0xb5, 0xcb, 0xf6, 0xcb,
	0x99, 0xc2, 0x27, 0xb0, 0x3c, 0x02, 0x1f, 0xad, 0xc2, 0x15, 0x45, 0x35, 0xe4, 0x6d, 0x8d, 0x6d,
	0x5a, 0xc6, 0xc3, 0xa6, 0x3c, 0x32, 0xb5, 0x8b, 0x50, 0x60, 0x7b, 0x0f, 0x87, 0x16, 0x60, 0x4e,
	0xba, 0x27, 0x4b, 0x3b, 0xd5, 0xc6, 0x03, 0x3e, 0x17, 0x8f, 0x6c, 0x45, 0xdd, 0x53, 0x74, 0xa5,
	0x5a, 0x97, 0xf9, 0xbc, 0x70, 0x02, 0x97, 0x5f, 0x01, 0x0c, 0xdd, 0x86, 0xb7, 0xa5, 0x7b, 0x62,
	0xbd, 0x2e, 0xab, 0xdb, 0xb2, 0xa9, 0xcb, 0x52, 0x4b, 0x53, 0x8c, 0x87, 0x66, 0x53, 0x93, 0xb7,
	0x64, 0x8d, 0x2e, 0x57, 0xc3, 0x5e, 0x17, 0xa1, 0xd8, 0xd2, 0xc5, 0xaa, 0x52, 0x57, 0x8c, 0x87,
	0x3c, 0x17, 0x0f, 0xfe, 0xaa, 0x58, 0x17, 0x55, 0x49, 0xe6, 0x73, 0x31, 0x8c, 0xd4, 0x00, 0x9f,
	0x17, 0xee, 0x01, 0x7a, 0xb1, 0x4f, 0xa0, 0x0d, 0xf8, 0x56, 0x5a, 0x4f, 0x81, 0x65, 0x1f, 0xc5,
	0x63, 0x28, 0xee, 0x7f, 0x69, 0x55, 0xbd, 0x91, 0x30, 0x9b, 0x8c, 0x17, 0xf7, 0x41, 0x22, 0x7c,
	0x08, 0x4b, 0xc3, 0xfd, 0x00, 0xdd, 0x02, 0x94, 0x5a, 0xd9, 0x3f, 0xf6, 0xda, 0x2e, 0x36, 0x9d,
	0x76, 0x6a, 0x82, 0x4f, 0x38, 0x55, 0xca, 0x50, 0xda, 0x64, 0xe3, 0x37, 0x00, 0x25, 0x2d, 0xcd,
	0xa0, 0x9c, 0x65, 0x50, 0xc7, 0xe1, 0x89, 0x63, 0x63, 0xf4, 0x55, 0xb6, 0xaf, 0x0c, 0x7c, 0x7f,
	0xbc, 0x3f, 0x51, 0x01, 0xbc, 0xe4, 0x0f, 0x83, 0xd2, 0xb4, 0xdf, 0xf3, 0xc2, 0xce, 0xd7, 0xe2,
	0xeb, 0x6c, 0x75, 0xb8, 0xd5, 0xff, 0xb0, 0xf9, 0xec, 0x1f, 0xff, 0xfc, 0x3c, 0xb7, 0x2e, 0xdc,
	0xa8, 0x9c, 0xac, 0x57, 0x9e, 0x30, 0xee, 0x07, 0x59, 0x07, 0x58, 0x1b, 0xfa, 0x1e, 0xda, 0x1c,
	0xf8, 0x2f, 0x00, 0x3d, 0xe3, 0xe2, 0xd0, 0x8f, 0x7e, 0xbb, 0xa2, 0x0f, 0xff, 0xb7, 0xaf, 0xf4,
	0xd2, 0x47, 0x67, 0xd6, 0x4f, 0x3e, 0x9a, 0x95, 0xaf, 0xc5, 0xe5, 0x38, 0xd9, 0xb7, 0xfa, 0x9f,
	0xf7, 0xc9, 0x15, 0x6f, 0xd1, 0x2b, 0xc6, 0xbc, 0x81, 0x0b, 0x0e, 0x7d, 0xef, 0xad, 0x3d, 0xdd,
	0x4c, 0xb4, 0xf0, 0x26, 0xb7, 0x86, 0x7e, 0xc7, 0x41, 0x31, 0xdb, 0x31, 0xd1, 0xdd, 0x29, 0x92,
	0xd5, 0x9f, 0xf1, 0xa5, 0x89, 0xb7, 0x0d, 0xe1, 0x6d, 0x8a, 0xf3, 0x86, 0x70, 0xe5, 0x65, 0xa9,
	0x88, 0xbb, 0xf0, 0x26, 0x6d, 0xf5, 0x7f, 0xe0, 0x60, 0x2e, 0x5d, 0xda, 0xd0, 0x64, 0x83, 0x69,
	0x64, 0x13, 0x2d, 0xdd, 0x9d, 0x52, 0x2b, 0x09, 0xef, 0x77, 0x28, 0xc8, 0x6b, 0xe8, 0x95, 0x20,
	0xd1, 0xaf, 0x39, 0x98, 0x65, 0xab, 0x1d, 0xda, 0x98, 0xc8, 0xcf, 0xd0, 0x1e, 0x38, 0x45, 0xcc,
	0x86, 0xe1, 0x8c, 0xe6, 0x96, 0x8e, 0xad, 0xb5, 0xa7, 0xe8, 0xf7, 0x1c, 0x14, 0xb3, 0x9d, 0x70,
	0xc2, 0x44, 0x8e, 0xee, 0x90, 0x53, 0x80, 0xba, 0x4d, 0x41, 0xbd, 0xb5, 0xb1, 0x4a, 0x41, 0x1d,
	0xe1, 0x5e, 0xf9, 0x25, 0xc0, 0x58, 0x32, 0x7f, 0xc1, 0x41, 0x31, 0x5b, 0x0d, 0x27, 0x44, 0x37,
	0xba, 0x4a, 0x96, 0x2e, 0xbc, 0xb0, 0x45, 0xc8, 0xdd, 0x20, 0xca, 0x02, 0xb4, 0xf6, 0xca, 0x00,
	0x95, 0xf6, 0xbe, 0x14, 0x85, 0xff, 0xbe, 0x1e, 0xfc, 0x5d, 0x2c, 0x1f, 0x46, 0x51, 0x40, 0x36,
	0x2b, 0x95, 0xd3, 0xd3, 0xd3, 0xd1, 0xdd, 0xc1, 0x3a, 0x8e, 0x0e, 0xd9, 0xff, 0xc1, 0xb7, 0xd3,
	0x05, 0xa1, 0xfa, 0x9c, 0x83, 0xeb, 0xb6, 0xdf, 0x4d, 0xb1, 0x8d, 0xbf, 0x4c, 0x75, 0x65, 0x4c,
	0xdf, 0x6c, 0xc6, 0xd7, 0x68, 0x72, 0x3f, 0xde, 0x4b, 0x54, 0x3b, 0xbe, 0x6b, 0x79, 0x9d, 0xb2,
	0x1f, 0x76, 0x2a, 0x1d, 0xec, 0xd1, 0x4b, 0x56, 0xfa, 0x00, 0x5e, 0xf9, 0x3f, 0xf4, 0x7b, 0x63,
	0xc8, 0x7f, 0xca, 0xcd, 0x6c, 0x4b, 0x9a, 0xfc, 0x97, 0xdc, 0x8d, 0x6d, 0x66, 0x5f, 0xa2, 0xd1,
	0x1e, 0x03, 0xa4, 0xbc, 0xb7, 0xfe, 0x65, 0x2a, 0xf5, 0x88, 0x4a, 0x3d, 0x1a, 0x23, 0xf5, 0x68,
	0x6f, 0x7d, 0x7f, 0x96, 0xa2, 0xba, 0xf3, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x39, 0x08, 0xf0,
	0x01, 0x1c, 0x17, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RecaptchaEnterpriseServiceClient is the client API for RecaptchaEnterpriseService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RecaptchaEnterpriseServiceClient interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fradulent.
	AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error)
	// Creates a new reCAPTCHA Enterprise key.
	CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Returns the list of all keys that belong to a project.
	ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error)
	// Returns the specified key.
	GetKey(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Updates the specified key.
	UpdateKey(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*Key, error)
	// Deletes the specified key.
	DeleteKey(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type recaptchaEnterpriseServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRecaptchaEnterpriseServiceClient(cc grpc.ClientConnInterface) RecaptchaEnterpriseServiceClient {
	return &recaptchaEnterpriseServiceClient{cc}
}

func (c *recaptchaEnterpriseServiceClient) CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error) {
	out := new(Assessment)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateAssessment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error) {
	out := new(AnnotateAssessmentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/AnnotateAssessment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) CreateKey(ctx context.Context, in *CreateKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) ListKeys(ctx context.Context, in *ListKeysRequest, opts ...grpc.CallOption) (*ListKeysResponse, error) {
	out := new(ListKeysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) GetKey(ctx context.Context, in *GetKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/GetKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) UpdateKey(ctx context.Context, in *UpdateKeyRequest, opts ...grpc.CallOption) (*Key, error) {
	out := new(Key)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/UpdateKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceClient) DeleteKey(ctx context.Context, in *DeleteKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/DeleteKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecaptchaEnterpriseServiceServer is the server API for RecaptchaEnterpriseService service.
type RecaptchaEnterpriseServiceServer interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(context.Context, *CreateAssessmentRequest) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fradulent.
	AnnotateAssessment(context.Context, *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error)
	// Creates a new reCAPTCHA Enterprise key.
	CreateKey(context.Context, *CreateKeyRequest) (*Key, error)
	// Returns the list of all keys that belong to a project.
	ListKeys(context.Context, *ListKeysRequest) (*ListKeysResponse, error)
	// Returns the specified key.
	GetKey(context.Context, *GetKeyRequest) (*Key, error)
	// Updates the specified key.
	UpdateKey(context.Context, *UpdateKeyRequest) (*Key, error)
	// Deletes the specified key.
	DeleteKey(context.Context, *DeleteKeyRequest) (*empty.Empty, error)
}

// UnimplementedRecaptchaEnterpriseServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRecaptchaEnterpriseServiceServer struct {
}

func (*UnimplementedRecaptchaEnterpriseServiceServer) CreateAssessment(ctx context.Context, req *CreateAssessmentRequest) (*Assessment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAssessment not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) AnnotateAssessment(ctx context.Context, req *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnnotateAssessment not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) CreateKey(ctx context.Context, req *CreateKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) ListKeys(ctx context.Context, req *ListKeysRequest) (*ListKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListKeys not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) GetKey(ctx context.Context, req *GetKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) UpdateKey(ctx context.Context, req *UpdateKeyRequest) (*Key, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateKey not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceServer) DeleteKey(ctx context.Context, req *DeleteKeyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteKey not implemented")
}

func RegisterRecaptchaEnterpriseServiceServer(s *grpc.Server, srv RecaptchaEnterpriseServiceServer) {
	s.RegisterService(&_RecaptchaEnterpriseService_serviceDesc, srv)
}

func _RecaptchaEnterpriseService_CreateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).CreateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateAssessment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).CreateAssessment(ctx, req.(*CreateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_AnnotateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).AnnotateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/AnnotateAssessment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).AnnotateAssessment(ctx, req.(*AnnotateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_CreateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).CreateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/CreateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).CreateKey(ctx, req.(*CreateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_ListKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).ListKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/ListKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).ListKeys(ctx, req.(*ListKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_GetKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).GetKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/GetKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).GetKey(ctx, req.(*GetKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_UpdateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).UpdateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/UpdateKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).UpdateKey(ctx, req.(*UpdateKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseService_DeleteKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceServer).DeleteKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService/DeleteKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceServer).DeleteKey(ctx, req.(*DeleteKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RecaptchaEnterpriseService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recaptchaenterprise.v1.RecaptchaEnterpriseService",
	HandlerType: (*RecaptchaEnterpriseServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAssessment",
			Handler:    _RecaptchaEnterpriseService_CreateAssessment_Handler,
		},
		{
			MethodName: "AnnotateAssessment",
			Handler:    _RecaptchaEnterpriseService_AnnotateAssessment_Handler,
		},
		{
			MethodName: "CreateKey",
			Handler:    _RecaptchaEnterpriseService_CreateKey_Handler,
		},
		{
			MethodName: "ListKeys",
			Handler:    _RecaptchaEnterpriseService_ListKeys_Handler,
		},
		{
			MethodName: "GetKey",
			Handler:    _RecaptchaEnterpriseService_GetKey_Handler,
		},
		{
			MethodName: "UpdateKey",
			Handler:    _RecaptchaEnterpriseService_UpdateKey_Handler,
		},
		{
			MethodName: "DeleteKey",
			Handler:    _RecaptchaEnterpriseService_DeleteKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto",
}
