package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Recommend invokes the airec.Recommend API synchronously
// api document: https://help.aliyun.com/api/airec/recommend.html
func (client *Client) Recommend(request *RecommendRequest) (response *RecommendResponse, err error) {
	response = CreateRecommendResponse()
	err = client.DoAction(request, response)
	return
}

// RecommendWithChan invokes the airec.Recommend API asynchronously
// api document: https://help.aliyun.com/api/airec/recommend.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecommendWithChan(request *RecommendRequest) (<-chan *RecommendResponse, <-chan error) {
	responseChan := make(chan *RecommendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Recommend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecommendWithCallback invokes the airec.Recommend API asynchronously
// api document: https://help.aliyun.com/api/airec/recommend.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecommendWithCallback(request *RecommendRequest, callback func(response *RecommendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecommendResponse
		var err error
		defer close(result)
		response, err = client.Recommend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecommendRequest is the request struct for api Recommend
type RecommendRequest struct {
	*requests.RoaRequest
	ReturnCount requests.Integer `position:"Query" name:"ReturnCount"`
	InstanceId  string           `position:"Path" name:"InstanceId"`
	Ip          string           `position:"Query" name:"Ip"`
	SceneId     string           `position:"Query" name:"SceneId"`
	Imei        string           `position:"Query" name:"Imei"`
	UserId      string           `position:"Query" name:"UserId"`
	Items       string           `position:"Query" name:"Items"`
}

// RecommendResponse is the response struct for api Recommend
type RecommendResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Code      string       `json:"Code" xml:"Code"`
	Message   string       `json:"Message" xml:"Message"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateRecommendRequest creates a request to invoke Recommend API
func CreateRecommendRequest() (request *RecommendRequest) {
	request = &RecommendRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "Recommend", "/openapi/instances/[InstanceId]/actions/recommend", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateRecommendResponse creates a response to parse from Recommend response
func CreateRecommendResponse() (response *RecommendResponse) {
	response = &RecommendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
