//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package dts

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSubscriptionInstances invokes the dts.DescribeSubscriptionInstances API synchronously
// api document: https://help.aliyun.com/api/dts/describesubscriptioninstances.html
func (client *Client) DescribeSubscriptionInstances(request *DescribeSubscriptionInstancesRequest) (response *DescribeSubscriptionInstancesResponse, err error) {
	response = CreateDescribeSubscriptionInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSubscriptionInstancesWithChan invokes the dts.DescribeSubscriptionInstances API asynchronously
// api document: https://help.aliyun.com/api/dts/describesubscriptioninstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSubscriptionInstancesWithChan(request *DescribeSubscriptionInstancesRequest) (<-chan *DescribeSubscriptionInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeSubscriptionInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSubscriptionInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSubscriptionInstancesWithCallback invokes the dts.DescribeSubscriptionInstances API asynchronously
// api document: https://help.aliyun.com/api/dts/describesubscriptioninstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSubscriptionInstancesWithCallback(request *DescribeSubscriptionInstancesRequest, callback func(response *DescribeSubscriptionInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSubscriptionInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeSubscriptionInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSubscriptionInstancesRequest is the request struct for api DescribeSubscriptionInstances
type DescribeSubscriptionInstancesRequest struct {
	*requests.RpcRequest
	PageSize                 requests.Integer `position:"Query" name:"PageSize"`
	PageNum                  requests.Integer `position:"Query" name:"PageNum"`
	SubscriptionInstanceName string           `position:"Query" name:"SubscriptionInstanceName"`
	ClientToken              string           `position:"Query" name:"ClientToken"`
	OwnerId                  string           `position:"Query" name:"OwnerId"`
}

// DescribeSubscriptionInstancesResponse is the response struct for api DescribeSubscriptionInstances
type DescribeSubscriptionInstancesResponse struct {
	*responses.BaseResponse
	PageNumber            int                                                 `json:"PageNumber" xml:"PageNumber"`
	TotalRecordCount      int64                                               `json:"TotalRecordCount" xml:"TotalRecordCount"`
	PageRecordCount       int                                                 `json:"PageRecordCount" xml:"PageRecordCount"`
	SubscriptionInstances DescribeSubscriptionInstancesSubscriptionInstances0 `json:"SubscriptionInstances" xml:"SubscriptionInstances"`
}

type DescribeSubscriptionInstancesSubscriptionInstances0 struct {
	SubscriptionInstance []DescribeSubscriptionInstancesSubscriptionInstance1 `json:"SubscriptionInstance" xml:"SubscriptionInstance"`
}

type DescribeSubscriptionInstancesSubscriptionInstance1 struct {
	SubscriptionInstanceID   string                                             `json:"SubscriptionInstanceID" xml:"SubscriptionInstanceID"`
	SubscriptionInstanceName string                                             `json:"SubscriptionInstanceName" xml:"SubscriptionInstanceName"`
	PayType                  string                                             `json:"PayType" xml:"PayType"`
	Status                   string                                             `json:"Status" xml:"Status"`
	ErrorMessage             string                                             `json:"ErrorMessage" xml:"ErrorMessage"`
	ConsumptionCheckpoint    string                                             `json:"ConsumptionCheckpoint" xml:"ConsumptionCheckpoint"`
	BeginTimestamp           string                                             `json:"BeginTimestamp" xml:"BeginTimestamp"`
	EndTimestamp             string                                             `json:"EndTimestamp" xml:"EndTimestamp"`
	ConsumptionClient        string                                             `json:"ConsumptionClient" xml:"ConsumptionClient"`
	SubscriptionObject       []DescribeSubscriptionInstancesSubscriptionObject1 `json:"SubscriptionObject" xml:"SubscriptionObject"`
	SourceEndpoint           DescribeSubscriptionInstancesSourceEndpoint1       `json:"SourceEndpoint" xml:"SourceEndpoint"`
	SubscriptionDataType     DescribeSubscriptionInstancesSubscriptionDataType1 `json:"SubscriptionDataType" xml:"SubscriptionDataType"`
}

type DescribeSubscriptionInstancesSubscriptionObject1 struct {
	SynchronousObject []DescribeSubscriptionInstancesSynchronousObject2 `json:"SynchronousObject" xml:"SynchronousObject"`
}

type DescribeSubscriptionInstancesSynchronousObject2 struct {
	DatabaseName  string   `json:"DatabaseName" xml:"DatabaseName"`
	WholeDatabase string   `json:"WholeDatabase" xml:"WholeDatabase"`
	TableList     []string `json:"TableList" xml:"TableList"`
}

type DescribeSubscriptionInstancesSourceEndpoint1 struct {
	InstanceID   string `json:"InstanceID" xml:"InstanceID"`
	InstanceType string `json:"InstanceType" xml:"InstanceType"`
}

type DescribeSubscriptionInstancesSubscriptionDataType1 struct {
	DDL bool `json:"DDL" xml:"DDL"`
	DML bool `json:"DML" xml:"DML"`
}

// CreateDescribeSubscriptionInstancesRequest creates a request to invoke DescribeSubscriptionInstances API
func CreateDescribeSubscriptionInstancesRequest() (request *DescribeSubscriptionInstancesRequest) {
	request = &DescribeSubscriptionInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2018-08-01", "DescribeSubscriptionInstances", "dts", "openAPI")
	return
}

// CreateDescribeSubscriptionInstancesResponse creates a response to parse from DescribeSubscriptionInstances response
func CreateDescribeSubscriptionInstancesResponse() (response *DescribeSubscriptionInstancesResponse) {
	response = &DescribeSubscriptionInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
