package industry_brain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceInputMapping invokes the industry_brain.GetServiceInputMapping API synchronously
// api document: https://help.aliyun.com/api/industry-brain/getserviceinputmapping.html
func (client *Client) GetServiceInputMapping(request *GetServiceInputMappingRequest) (response *GetServiceInputMappingResponse, err error) {
	response = CreateGetServiceInputMappingResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceInputMappingWithChan invokes the industry_brain.GetServiceInputMapping API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getserviceinputmapping.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetServiceInputMappingWithChan(request *GetServiceInputMappingRequest) (<-chan *GetServiceInputMappingResponse, <-chan error) {
	responseChan := make(chan *GetServiceInputMappingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceInputMapping(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceInputMappingWithCallback invokes the industry_brain.GetServiceInputMapping API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/getserviceinputmapping.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetServiceInputMappingWithCallback(request *GetServiceInputMappingRequest, callback func(response *GetServiceInputMappingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceInputMappingResponse
		var err error
		defer close(result)
		response, err = client.GetServiceInputMapping(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceInputMappingRequest is the request struct for api GetServiceInputMapping
type GetServiceInputMappingRequest struct {
	*requests.RpcRequest
	ShowLatestData requests.Boolean `position:"Query" name:"ShowLatestData"`
	Limit          requests.Integer `position:"Query" name:"Limit"`
	ServiceId      string           `position:"Query" name:"ServiceId"`
	AlgorithmId    string           `position:"Query" name:"AlgorithmId"`
}

// GetServiceInputMappingResponse is the response struct for api GetServiceInputMapping
type GetServiceInputMappingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateGetServiceInputMappingRequest creates a request to invoke GetServiceInputMapping API
func CreateGetServiceInputMappingRequest() (request *GetServiceInputMappingRequest) {
	request = &GetServiceInputMappingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("industry-brain", "2018-07-12", "GetServiceInputMapping", "", "")
	return
}

// CreateGetServiceInputMappingResponse creates a response to parse from GetServiceInputMapping response
func CreateGetServiceInputMappingResponse() (response *GetServiceInputMappingResponse) {
	response = &GetServiceInputMappingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
