package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AllowPushStream invokes the live.AllowPushStream API synchronously
// api document: https://help.aliyun.com/api/live/allowpushstream.html
func (client *Client) AllowPushStream(request *AllowPushStreamRequest) (response *AllowPushStreamResponse, err error) {
	response = CreateAllowPushStreamResponse()
	err = client.DoAction(request, response)
	return
}

// AllowPushStreamWithChan invokes the live.AllowPushStream API asynchronously
// api document: https://help.aliyun.com/api/live/allowpushstream.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AllowPushStreamWithChan(request *AllowPushStreamRequest) (<-chan *AllowPushStreamResponse, <-chan error) {
	responseChan := make(chan *AllowPushStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AllowPushStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AllowPushStreamWithCallback invokes the live.AllowPushStream API asynchronously
// api document: https://help.aliyun.com/api/live/allowpushstream.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AllowPushStreamWithCallback(request *AllowPushStreamRequest, callback func(response *AllowPushStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AllowPushStreamResponse
		var err error
		defer close(result)
		response, err = client.AllowPushStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AllowPushStreamRequest is the request struct for api AllowPushStream
type AllowPushStreamRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	RoomId  string           `position:"Query" name:"RoomId"`
	AppId   string           `position:"Query" name:"AppId"`
}

// AllowPushStreamResponse is the response struct for api AllowPushStream
type AllowPushStreamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAllowPushStreamRequest creates a request to invoke AllowPushStream API
func CreateAllowPushStreamRequest() (request *AllowPushStreamRequest) {
	request = &AllowPushStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AllowPushStream", "live", "openAPI")
	return
}

// CreateAllowPushStreamResponse creates a response to parse from AllowPushStream response
func CreateAllowPushStreamResponse() (response *AllowPushStreamResponse) {
	response = &AllowPushStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
