package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceNetInfo invokes the r_kvstore.DescribeDBInstanceNetInfo API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/describedbinstancenetinfo.html
func (client *Client) DescribeDBInstanceNetInfo(request *DescribeDBInstanceNetInfoRequest) (response *DescribeDBInstanceNetInfoResponse, err error) {
	response = CreateDescribeDBInstanceNetInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceNetInfoWithChan invokes the r_kvstore.DescribeDBInstanceNetInfo API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describedbinstancenetinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDBInstanceNetInfoWithChan(request *DescribeDBInstanceNetInfoRequest) (<-chan *DescribeDBInstanceNetInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceNetInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceNetInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceNetInfoWithCallback invokes the r_kvstore.DescribeDBInstanceNetInfo API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describedbinstancenetinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDBInstanceNetInfoWithCallback(request *DescribeDBInstanceNetInfoRequest, callback func(response *DescribeDBInstanceNetInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceNetInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceNetInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceNetInfoRequest is the request struct for api DescribeDBInstanceNetInfo
type DescribeDBInstanceNetInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBInstanceNetInfoResponse is the response struct for api DescribeDBInstanceNetInfo
type DescribeDBInstanceNetInfoResponse struct {
	*responses.BaseResponse
	RequestId           string                                  `json:"RequestId" xml:"RequestId"`
	InstanceNetworkType string                                  `json:"InstanceNetworkType" xml:"InstanceNetworkType"`
	NetInfoItems        NetInfoItemsInDescribeDBInstanceNetInfo `json:"NetInfoItems" xml:"NetInfoItems"`
}

// CreateDescribeDBInstanceNetInfoRequest creates a request to invoke DescribeDBInstanceNetInfo API
func CreateDescribeDBInstanceNetInfoRequest() (request *DescribeDBInstanceNetInfoRequest) {
	request = &DescribeDBInstanceNetInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeDBInstanceNetInfo", "redisa", "openAPI")
	return
}

// CreateDescribeDBInstanceNetInfoResponse creates a response to parse from DescribeDBInstanceNetInfo response
func CreateDescribeDBInstanceNetInfoResponse() (response *DescribeDBInstanceNetInfoResponse) {
	response = &DescribeDBInstanceNetInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
