package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTrademarkMonitorResults invokes the trademark.QueryTrademarkMonitorResults API synchronously
// api document: https://help.aliyun.com/api/trademark/querytrademarkmonitorresults.html
func (client *Client) QueryTrademarkMonitorResults(request *QueryTrademarkMonitorResultsRequest) (response *QueryTrademarkMonitorResultsResponse, err error) {
	response = CreateQueryTrademarkMonitorResultsResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTrademarkMonitorResultsWithChan invokes the trademark.QueryTrademarkMonitorResults API asynchronously
// api document: https://help.aliyun.com/api/trademark/querytrademarkmonitorresults.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTrademarkMonitorResultsWithChan(request *QueryTrademarkMonitorResultsRequest) (<-chan *QueryTrademarkMonitorResultsResponse, <-chan error) {
	responseChan := make(chan *QueryTrademarkMonitorResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTrademarkMonitorResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTrademarkMonitorResultsWithCallback invokes the trademark.QueryTrademarkMonitorResults API asynchronously
// api document: https://help.aliyun.com/api/trademark/querytrademarkmonitorresults.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTrademarkMonitorResultsWithCallback(request *QueryTrademarkMonitorResultsRequest, callback func(response *QueryTrademarkMonitorResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTrademarkMonitorResultsResponse
		var err error
		defer close(result)
		response, err = client.QueryTrademarkMonitorResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTrademarkMonitorResultsRequest is the request struct for api QueryTrademarkMonitorResults
type QueryTrademarkMonitorResultsRequest struct {
	*requests.RpcRequest
	ActionType         requests.Integer `position:"Query" name:"ActionType"`
	TmName             string           `position:"Query" name:"TmName"`
	ApplyYear          string           `position:"Query" name:"ApplyYear"`
	PageSize           requests.Integer `position:"Query" name:"PageSize"`
	ProcedureStatus    requests.Integer `position:"Query" name:"ProcedureStatus"`
	RuleId             requests.Integer `position:"Query" name:"RuleId"`
	Classification     string           `position:"Query" name:"Classification"`
	PageNum            requests.Integer `position:"Query" name:"PageNum"`
	RegistrationNumber string           `position:"Query" name:"RegistrationNumber"`
}

// QueryTrademarkMonitorResultsResponse is the response struct for api QueryTrademarkMonitorResults
type QueryTrademarkMonitorResultsResponse struct {
	*responses.BaseResponse
	RequestId      string                             `json:"RequestId" xml:"RequestId"`
	TotalItemNum   int                                `json:"TotalItemNum" xml:"TotalItemNum"`
	CurrentPageNum int                                `json:"CurrentPageNum" xml:"CurrentPageNum"`
	PageSize       int                                `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int                                `json:"TotalPageNum" xml:"TotalPageNum"`
	PrePage        bool                               `json:"PrePage" xml:"PrePage"`
	NextPage       bool                               `json:"NextPage" xml:"NextPage"`
	Data           DataInQueryTrademarkMonitorResults `json:"Data" xml:"Data"`
}

// CreateQueryTrademarkMonitorResultsRequest creates a request to invoke QueryTrademarkMonitorResults API
func CreateQueryTrademarkMonitorResultsRequest() (request *QueryTrademarkMonitorResultsRequest) {
	request = &QueryTrademarkMonitorResultsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "QueryTrademarkMonitorResults", "trademark", "openAPI")
	return
}

// CreateQueryTrademarkMonitorResultsResponse creates a response to parse from QueryTrademarkMonitorResults response
func CreateQueryTrademarkMonitorResultsResponse() (response *QueryTrademarkMonitorResultsResponse) {
	response = &QueryTrademarkMonitorResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
