package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokeInstanceFromCen invokes the vpc.RevokeInstanceFromCen API synchronously
// api document: https://help.aliyun.com/api/vpc/revokeinstancefromcen.html
func (client *Client) RevokeInstanceFromCen(request *RevokeInstanceFromCenRequest) (response *RevokeInstanceFromCenResponse, err error) {
	response = CreateRevokeInstanceFromCenResponse()
	err = client.DoAction(request, response)
	return
}

// RevokeInstanceFromCenWithChan invokes the vpc.RevokeInstanceFromCen API asynchronously
// api document: https://help.aliyun.com/api/vpc/revokeinstancefromcen.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RevokeInstanceFromCenWithChan(request *RevokeInstanceFromCenRequest) (<-chan *RevokeInstanceFromCenResponse, <-chan error) {
	responseChan := make(chan *RevokeInstanceFromCenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokeInstanceFromCen(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokeInstanceFromCenWithCallback invokes the vpc.RevokeInstanceFromCen API asynchronously
// api document: https://help.aliyun.com/api/vpc/revokeinstancefromcen.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RevokeInstanceFromCenWithCallback(request *RevokeInstanceFromCenRequest, callback func(response *RevokeInstanceFromCenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokeInstanceFromCenResponse
		var err error
		defer close(result)
		response, err = client.RevokeInstanceFromCen(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokeInstanceFromCenRequest is the request struct for api RevokeInstanceFromCen
type RevokeInstanceFromCenRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	CenId                string           `position:"Query" name:"CenId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	InstanceType         string           `position:"Query" name:"InstanceType"`
	CenOwnerId           requests.Integer `position:"Query" name:"CenOwnerId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// RevokeInstanceFromCenResponse is the response struct for api RevokeInstanceFromCen
type RevokeInstanceFromCenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRevokeInstanceFromCenRequest creates a request to invoke RevokeInstanceFromCen API
func CreateRevokeInstanceFromCenRequest() (request *RevokeInstanceFromCenRequest) {
	request = &RevokeInstanceFromCenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "RevokeInstanceFromCen", "vpc", "openAPI")
	return
}

// CreateRevokeInstanceFromCenResponse creates a response to parse from RevokeInstanceFromCen response
func CreateRevokeInstanceFromCenResponse() (response *RevokeInstanceFromCenResponse) {
	response = &RevokeInstanceFromCenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
