package qnamakerruntime

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RuntimeClient is the an API for QnAMaker runtime
type RuntimeClient struct {
	BaseClient
}

// NewRuntimeClient creates an instance of the RuntimeClient client.
func NewRuntimeClient(runtimeEndpoint string) RuntimeClient {
	return RuntimeClient{New(runtimeEndpoint)}
}

// GenerateAnswer sends the generate answer request.
// Parameters:
// kbID - knowledgebase id.
// generateAnswerPayload - post body of the request.
func (client RuntimeClient) GenerateAnswer(ctx context.Context, kbID string, generateAnswerPayload QueryDTO) (result QnASearchResultList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuntimeClient.GenerateAnswer")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GenerateAnswerPreparer(ctx, kbID, generateAnswerPayload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "qnamakerruntime.RuntimeClient", "GenerateAnswer", nil, "Failure preparing request")
		return
	}

	resp, err := client.GenerateAnswerSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "qnamakerruntime.RuntimeClient", "GenerateAnswer", resp, "Failure sending request")
		return
	}

	result, err = client.GenerateAnswerResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "qnamakerruntime.RuntimeClient", "GenerateAnswer", resp, "Failure responding to request")
	}

	return
}

// GenerateAnswerPreparer prepares the GenerateAnswer request.
func (client RuntimeClient) GenerateAnswerPreparer(ctx context.Context, kbID string, generateAnswerPayload QueryDTO) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"RuntimeEndpoint": client.RuntimeEndpoint,
	}

	pathParameters := map[string]interface{}{
		"kbId": autorest.Encode("path", kbID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{RuntimeEndpoint}/qnamaker", urlParameters),
		autorest.WithPathParameters("/knowledgebases/{kbId}/generateAnswer", pathParameters),
		autorest.WithJSON(generateAnswerPayload))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GenerateAnswerSender sends the GenerateAnswer request. The method will close the
// http.Response Body if it receives an error.
func (client RuntimeClient) GenerateAnswerSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GenerateAnswerResponder handles the response to the GenerateAnswer request. The method always
// closes the http.Response Body.
func (client RuntimeClient) GenerateAnswerResponder(resp *http.Response) (result QnASearchResultList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Train sends the train request.
// Parameters:
// kbID - knowledgebase id.
// trainPayload - post body of the request.
func (client RuntimeClient) Train(ctx context.Context, kbID string, trainPayload FeedbackRecordsDTO) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuntimeClient.Train")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.TrainPreparer(ctx, kbID, trainPayload)
	if err != nil {
		err = autorest.NewErrorWithError(err, "qnamakerruntime.RuntimeClient", "Train", nil, "Failure preparing request")
		return
	}

	resp, err := client.TrainSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "qnamakerruntime.RuntimeClient", "Train", resp, "Failure sending request")
		return
	}

	result, err = client.TrainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "qnamakerruntime.RuntimeClient", "Train", resp, "Failure responding to request")
	}

	return
}

// TrainPreparer prepares the Train request.
func (client RuntimeClient) TrainPreparer(ctx context.Context, kbID string, trainPayload FeedbackRecordsDTO) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"RuntimeEndpoint": client.RuntimeEndpoint,
	}

	pathParameters := map[string]interface{}{
		"kbId": autorest.Encode("path", kbID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{RuntimeEndpoint}/qnamaker", urlParameters),
		autorest.WithPathParameters("/knowledgebases/{kbId}/train", pathParameters),
		autorest.WithJSON(trainPayload))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TrainSender sends the Train request. The method will close the
// http.Response Body if it receives an error.
func (client RuntimeClient) TrainSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// TrainResponder handles the response to the Train request. The method always
// closes the http.Response Body.
func (client RuntimeClient) TrainResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}
