package operationalinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/operationalinsights/mgmt/2015-11-01-preview/operationalinsights"

// DataSourceKind enumerates the values for data source kind.
type DataSourceKind string

const (
	// AzureActivityLog ...
	AzureActivityLog DataSourceKind = "AzureActivityLog"
	// ChangeTrackingCustomRegistry ...
	ChangeTrackingCustomRegistry DataSourceKind = "ChangeTrackingCustomRegistry"
	// ChangeTrackingDefaultPath ...
	ChangeTrackingDefaultPath DataSourceKind = "ChangeTrackingDefaultPath"
	// ChangeTrackingDefaultRegistry ...
	ChangeTrackingDefaultRegistry DataSourceKind = "ChangeTrackingDefaultRegistry"
	// ChangeTrackingPath ...
	ChangeTrackingPath DataSourceKind = "ChangeTrackingPath"
	// CustomLog ...
	CustomLog DataSourceKind = "CustomLog"
	// CustomLogCollection ...
	CustomLogCollection DataSourceKind = "CustomLogCollection"
	// GenericDataSource ...
	GenericDataSource DataSourceKind = "GenericDataSource"
	// IISLogs ...
	IISLogs DataSourceKind = "IISLogs"
	// LinuxPerformanceCollection ...
	LinuxPerformanceCollection DataSourceKind = "LinuxPerformanceCollection"
	// LinuxPerformanceObject ...
	LinuxPerformanceObject DataSourceKind = "LinuxPerformanceObject"
	// LinuxSyslog ...
	LinuxSyslog DataSourceKind = "LinuxSyslog"
	// LinuxSyslogCollection ...
	LinuxSyslogCollection DataSourceKind = "LinuxSyslogCollection"
	// WindowsEvent ...
	WindowsEvent DataSourceKind = "WindowsEvent"
	// WindowsPerformanceCounter ...
	WindowsPerformanceCounter DataSourceKind = "WindowsPerformanceCounter"
)

// PossibleDataSourceKindValues returns an array of possible values for the DataSourceKind const type.
func PossibleDataSourceKindValues() []DataSourceKind {
	return []DataSourceKind{AzureActivityLog, ChangeTrackingCustomRegistry, ChangeTrackingDefaultPath, ChangeTrackingDefaultRegistry, ChangeTrackingPath, CustomLog, CustomLogCollection, GenericDataSource, IISLogs, LinuxPerformanceCollection, LinuxPerformanceObject, LinuxSyslog, LinuxSyslogCollection, WindowsEvent, WindowsPerformanceCounter}
}

// EntityStatus enumerates the values for entity status.
type EntityStatus string

const (
	// Canceled ...
	Canceled EntityStatus = "Canceled"
	// Creating ...
	Creating EntityStatus = "Creating"
	// Deleting ...
	Deleting EntityStatus = "Deleting"
	// Failed ...
	Failed EntityStatus = "Failed"
	// ProvisioningAccount ...
	ProvisioningAccount EntityStatus = "ProvisioningAccount"
	// Succeeded ...
	Succeeded EntityStatus = "Succeeded"
)

// PossibleEntityStatusValues returns an array of possible values for the EntityStatus const type.
func PossibleEntityStatusValues() []EntityStatus {
	return []EntityStatus{Canceled, Creating, Deleting, Failed, ProvisioningAccount, Succeeded}
}

// SkuNameEnum enumerates the values for sku name enum.
type SkuNameEnum string

const (
	// CapacityReservation ...
	CapacityReservation SkuNameEnum = "CapacityReservation"
	// Free ...
	Free SkuNameEnum = "Free"
	// PerGB2018 ...
	PerGB2018 SkuNameEnum = "PerGB2018"
	// PerNode ...
	PerNode SkuNameEnum = "PerNode"
	// Premium ...
	Premium SkuNameEnum = "Premium"
	// Standalone ...
	Standalone SkuNameEnum = "Standalone"
	// Standard ...
	Standard SkuNameEnum = "Standard"
)

// PossibleSkuNameEnumValues returns an array of possible values for the SkuNameEnum const type.
func PossibleSkuNameEnumValues() []SkuNameEnum {
	return []SkuNameEnum{CapacityReservation, Free, PerGB2018, PerNode, Premium, Standalone, Standard}
}

// DataSource datasources under OMS Workspace.
type DataSource struct {
	autorest.Response `json:"-"`
	// Properties - The data source properties in raw json format, each kind of data source have it's own schema.
	Properties interface{} `json:"properties,omitempty"`
	// ETag - The ETag of the data source.
	ETag *string `json:"eTag,omitempty"`
	// Kind - Possible values include: 'AzureActivityLog', 'ChangeTrackingPath', 'ChangeTrackingDefaultPath', 'ChangeTrackingDefaultRegistry', 'ChangeTrackingCustomRegistry', 'CustomLog', 'CustomLogCollection', 'GenericDataSource', 'IISLogs', 'LinuxPerformanceObject', 'LinuxPerformanceCollection', 'LinuxSyslog', 'LinuxSyslogCollection', 'WindowsEvent', 'WindowsPerformanceCounter'
	Kind DataSourceKind `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DataSource.
func (ds DataSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.Properties != nil {
		objectMap["properties"] = ds.Properties
	}
	if ds.ETag != nil {
		objectMap["eTag"] = ds.ETag
	}
	if ds.Kind != "" {
		objectMap["kind"] = ds.Kind
	}
	if ds.Tags != nil {
		objectMap["tags"] = ds.Tags
	}
	return json.Marshal(objectMap)
}

// DataSourceFilter dataSource filter. Right now, only filter by kind is supported.
type DataSourceFilter struct {
	// Kind - Possible values include: 'AzureActivityLog', 'ChangeTrackingPath', 'ChangeTrackingDefaultPath', 'ChangeTrackingDefaultRegistry', 'ChangeTrackingCustomRegistry', 'CustomLog', 'CustomLogCollection', 'GenericDataSource', 'IISLogs', 'LinuxPerformanceObject', 'LinuxPerformanceCollection', 'LinuxSyslog', 'LinuxSyslogCollection', 'WindowsEvent', 'WindowsPerformanceCounter'
	Kind DataSourceKind `json:"kind,omitempty"`
}

// DataSourceListResult the list data source by workspace operation response.
type DataSourceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of datasources.
	Value *[]DataSource `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of datasources.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataSourceListResultIterator provides access to a complete listing of DataSource values.
type DataSourceListResultIterator struct {
	i    int
	page DataSourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DataSourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataSourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DataSourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DataSourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DataSourceListResultIterator) Response() DataSourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DataSourceListResultIterator) Value() DataSource {
	if !iter.page.NotDone() {
		return DataSource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DataSourceListResultIterator type.
func NewDataSourceListResultIterator(page DataSourceListResultPage) DataSourceListResultIterator {
	return DataSourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dslr DataSourceListResult) IsEmpty() bool {
	return dslr.Value == nil || len(*dslr.Value) == 0
}

// dataSourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dslr DataSourceListResult) dataSourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if dslr.NextLink == nil || len(to.String(dslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dslr.NextLink)))
}

// DataSourceListResultPage contains a page of DataSource values.
type DataSourceListResultPage struct {
	fn   func(context.Context, DataSourceListResult) (DataSourceListResult, error)
	dslr DataSourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DataSourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataSourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dslr)
	if err != nil {
		return err
	}
	page.dslr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DataSourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DataSourceListResultPage) NotDone() bool {
	return !page.dslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DataSourceListResultPage) Response() DataSourceListResult {
	return page.dslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DataSourceListResultPage) Values() []DataSource {
	if page.dslr.IsEmpty() {
		return nil
	}
	return *page.dslr.Value
}

// Creates a new instance of the DataSourceListResultPage type.
func NewDataSourceListResultPage(getNextPage func(context.Context, DataSourceListResult) (DataSourceListResult, error)) DataSourceListResultPage {
	return DataSourceListResultPage{fn: getNextPage}
}

// ErrorResponse describes the format of Error response.
type ErrorResponse struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// IntelligencePack intelligence Pack containing a string name and boolean indicating if it's enabled.
type IntelligencePack struct {
	// Name - The name of the intelligence pack.
	Name *string `json:"name,omitempty"`
	// Enabled - The enabled boolean for the intelligence pack.
	Enabled *bool `json:"enabled,omitempty"`
	// DisplayName - The display name of the intelligence pack.
	DisplayName *string `json:"displayName,omitempty"`
}

// LinkedService the top level Linked service resource container.
type LinkedService struct {
	autorest.Response `json:"-"`
	// LinkedServiceProperties - The properties of the linked service.
	*LinkedServiceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LinkedService.
func (ls LinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ls.LinkedServiceProperties != nil {
		objectMap["properties"] = ls.LinkedServiceProperties
	}
	if ls.Tags != nil {
		objectMap["tags"] = ls.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LinkedService struct.
func (ls *LinkedService) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var linkedServiceProperties LinkedServiceProperties
				err = json.Unmarshal(*v, &linkedServiceProperties)
				if err != nil {
					return err
				}
				ls.LinkedServiceProperties = &linkedServiceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ls.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ls.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ls.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ls.Tags = tags
			}
		}
	}

	return nil
}

// LinkedServiceListResult the list linked service operation response.
type LinkedServiceListResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of linked service instances.
	Value *[]LinkedService `json:"value,omitempty"`
}

// LinkedServiceProperties linked service properties.
type LinkedServiceProperties struct {
	// ResourceID - The resource id of the resource that will be linked to the workspace.
	ResourceID *string `json:"resourceId,omitempty"`
}

// ListIntelligencePack ...
type ListIntelligencePack struct {
	autorest.Response `json:"-"`
	Value             *[]IntelligencePack `json:"value,omitempty"`
}

// ManagementGroup a management group that is connected to a workspace
type ManagementGroup struct {
	// ManagementGroupProperties - The properties of the management group.
	*ManagementGroupProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagementGroup.
func (mg ManagementGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mg.ManagementGroupProperties != nil {
		objectMap["properties"] = mg.ManagementGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagementGroup struct.
func (mg *ManagementGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managementGroupProperties ManagementGroupProperties
				err = json.Unmarshal(*v, &managementGroupProperties)
				if err != nil {
					return err
				}
				mg.ManagementGroupProperties = &managementGroupProperties
			}
		}
	}

	return nil
}

// ManagementGroupProperties management group properties.
type ManagementGroupProperties struct {
	// ServerCount - The number of servers connected to the management group.
	ServerCount *int32 `json:"serverCount,omitempty"`
	// IsGateway - Gets or sets a value indicating whether the management group is a gateway.
	IsGateway *bool `json:"isGateway,omitempty"`
	// Name - The name of the management group.
	Name *string `json:"name,omitempty"`
	// ID - The unique ID of the management group.
	ID *string `json:"id,omitempty"`
	// Created - The datetime that the management group was created.
	Created *date.Time `json:"created,omitempty"`
	// DataReceived - The last datetime that the management group received data.
	DataReceived *date.Time `json:"dataReceived,omitempty"`
	// Version - The version of System Center that is managing the management group.
	Version *string `json:"version,omitempty"`
	// Sku - The SKU of System Center that is managing the management group.
	Sku *string `json:"sku,omitempty"`
}

// MetricName the name of a metric.
type MetricName struct {
	// Value - The system name of the metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - The localized name of the metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// Operation supported operation of OperationalInsights resource provider.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft OperationsManagement.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list solution operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of solution operations supported by the OperationsManagement resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// OperationStatus the status of operation.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ID - The operation Id.
	ID *string `json:"id,omitempty"`
	// Name - The operation name.
	Name *string `json:"name,omitempty"`
	// StartTime - The start time of the operation.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - The end time of the operation.
	EndTime *string `json:"endTime,omitempty"`
	// Status - The status of the operation.
	Status *string `json:"status,omitempty"`
	// Error - The error detail of the operation if any.
	Error *ErrorResponse `json:"error,omitempty"`
}

// PrivateEndpointConnection a private endpoint connection
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	if pec.Tags != nil {
		objectMap["tags"] = pec.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pec.Tags = tags
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult a list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateEndpointConnectionListResultIterator provides access to a complete listing of
// PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultIterator struct {
	i    int
	page PrivateEndpointConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListResultIterator) Response() PrivateEndpointConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListResultIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListResultIterator type.
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return PrivateEndpointConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (peclr PrivateEndpointConnectionListResult) IsEmpty() bool {
	return peclr.Value == nil || len(*peclr.Value) == 0
}

// privateEndpointConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (peclr PrivateEndpointConnectionListResult) privateEndpointConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if peclr.NextLink == nil || len(to.String(peclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(peclr.NextLink)))
}

// PrivateEndpointConnectionListResultPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultPage struct {
	fn    func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)
	peclr PrivateEndpointConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.peclr)
	if err != nil {
		return err
	}
	page.peclr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListResultPage) NotDone() bool {
	return !page.peclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListResultPage) Response() PrivateEndpointConnectionListResult {
	return page.peclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListResultPage) Values() []PrivateEndpointConnection {
	if page.peclr.IsEmpty() {
		return nil
	}
	return *page.peclr.Value
}

// Creates a new instance of the PrivateEndpointConnectionListResultPage type.
func NewPrivateEndpointConnectionListResultPage(getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return PrivateEndpointConnectionListResultPage{fn: getNextPage}
}

// PrivateEndpointConnectionProperties properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) Result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("operationalinsights.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "operationalinsights.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *PrivateEndpointConnectionsDeleteFuture) Result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("operationalinsights.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateEndpointProperty private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// ID - Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	if plr.Tags != nil {
		objectMap["tags"] = plr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				plr.Tags = tags
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateLinkResourceListResultIterator provides access to a complete listing of PrivateLinkResource
// values.
type PrivateLinkResourceListResultIterator struct {
	i    int
	page PrivateLinkResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourceListResultIterator) Response() PrivateLinkResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourceListResultIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourceListResultIterator type.
func NewPrivateLinkResourceListResultIterator(page PrivateLinkResourceListResultPage) PrivateLinkResourceListResultIterator {
	return PrivateLinkResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plrlr PrivateLinkResourceListResult) IsEmpty() bool {
	return plrlr.Value == nil || len(*plrlr.Value) == 0
}

// privateLinkResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plrlr PrivateLinkResourceListResult) privateLinkResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if plrlr.NextLink == nil || len(to.String(plrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plrlr.NextLink)))
}

// PrivateLinkResourceListResultPage contains a page of PrivateLinkResource values.
type PrivateLinkResourceListResultPage struct {
	fn    func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)
	plrlr PrivateLinkResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.plrlr)
	if err != nil {
		return err
	}
	page.plrlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourceListResultPage) NotDone() bool {
	return !page.plrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourceListResultPage) Response() PrivateLinkResourceListResult {
	return page.plrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourceListResultPage) Values() []PrivateLinkResource {
	if page.plrlr.IsEmpty() {
		return nil
	}
	return *page.plrlr.Value
}

// Creates a new instance of the PrivateLinkResourceListResultPage type.
func NewPrivateLinkResourceListResultPage(getNextPage func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)) PrivateLinkResourceListResultPage {
	return PrivateLinkResourceListResultPage{fn: getNextPage}
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
}

// PrivateLinkServiceConnectionStateProperty state of the private endpoint connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// Status - The private link service connection status.
	Status *string `json:"status,omitempty"`
	// Description - The private link service connection description.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - READ-ONLY; The actions required for private link service connection.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ProxyResource common properties of proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pr.Tags != nil {
		objectMap["tags"] = pr.Tags
	}
	return json.Marshal(objectMap)
}

// Resource the resource definition.
type Resource struct {
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// SharedKeys the shared keys for a workspace.
type SharedKeys struct {
	autorest.Response `json:"-"`
	// PrimarySharedKey - The primary shared key of a workspace.
	PrimarySharedKey *string `json:"primarySharedKey,omitempty"`
	// SecondarySharedKey - The secondary shared key of a workspace.
	SecondarySharedKey *string `json:"secondarySharedKey,omitempty"`
}

// Sku the SKU (tier) of a workspace.
type Sku struct {
	// Name - The name of the SKU. Possible values include: 'Free', 'Standard', 'Premium', 'PerNode', 'PerGB2018', 'Standalone', 'CapacityReservation'
	Name SkuNameEnum `json:"name,omitempty"`
}

// UsageMetric a metric describing the usage of a resource.
type UsageMetric struct {
	// Name - The name of the metric.
	Name *MetricName `json:"name,omitempty"`
	// Unit - The units used for the metric.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - The current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - The quota limit for the metric.
	Limit *float64 `json:"limit,omitempty"`
	// NextResetTime - The time that the metric's value will reset.
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	// QuotaPeriod - The quota period that determines the length of time between value resets.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
}

// Workspace the top level Workspace resource container.
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - Workspace properties.
	*WorkspaceProperties `json:"properties,omitempty"`
	// ETag - The ETag of the workspace.
	ETag *string `json:"eTag,omitempty"`
	// ID - READ-ONLY; Resource Id
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.ETag != nil {
		objectMap["eTag"] = w.ETag
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				w.ETag = &eTag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		}
	}

	return nil
}

// WorkspaceListManagementGroupsResult the list workspace management groups operation response.
type WorkspaceListManagementGroupsResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of management groups attached to the workspace.
	Value *[]ManagementGroup `json:"value,omitempty"`
}

// WorkspaceListResult the list workspaces operation response.
type WorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of workspaces.
	Value *[]Workspace `json:"value,omitempty"`
}

// WorkspaceListUsagesResult the list workspace usages operation response.
type WorkspaceListUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets a list of usage metrics for a workspace.
	Value *[]UsageMetric `json:"value,omitempty"`
}

// WorkspaceProperties workspace properties.
type WorkspaceProperties struct {
	// ProvisioningState - The provisioning state of the workspace. Possible values include: 'Creating', 'Succeeded', 'Failed', 'Canceled', 'Deleting', 'ProvisioningAccount'
	ProvisioningState EntityStatus `json:"provisioningState,omitempty"`
	// Source - READ-ONLY; This is a read-only legacy property. It is always set to 'Azure' by the service. Kept here for backward compatibility.
	Source *string `json:"source,omitempty"`
	// CustomerID - READ-ONLY; This is a read-only property. Represents the ID associated with the workspace.
	CustomerID *string `json:"customerId,omitempty"`
	// PortalURL - READ-ONLY; This is a legacy property and is not used anymore. Kept here for backward compatibility.
	PortalURL *string `json:"portalUrl,omitempty"`
	// Sku - The SKU of the workspace.
	Sku *Sku `json:"sku,omitempty"`
	// RetentionInDays - The workspace data retention in days. -1 means Unlimited retention for the Unlimited Sku. 730 days is the maximum allowed for all other Skus.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
}

// WorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type WorkspacesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkspacesCreateOrUpdateFuture) Result(client WorkspacesClient) (w Workspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "operationalinsights.WorkspacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("operationalinsights.WorkspacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateOrUpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "operationalinsights.WorkspacesCreateOrUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}
