package dbs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigureBackupPlan invokes the dbs.ConfigureBackupPlan API synchronously
// api document: https://help.aliyun.com/api/dbs/configurebackupplan.html
func (client *Client) ConfigureBackupPlan(request *ConfigureBackupPlanRequest) (response *ConfigureBackupPlanResponse, err error) {
	response = CreateConfigureBackupPlanResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigureBackupPlanWithChan invokes the dbs.ConfigureBackupPlan API asynchronously
// api document: https://help.aliyun.com/api/dbs/configurebackupplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigureBackupPlanWithChan(request *ConfigureBackupPlanRequest) (<-chan *ConfigureBackupPlanResponse, <-chan error) {
	responseChan := make(chan *ConfigureBackupPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigureBackupPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigureBackupPlanWithCallback invokes the dbs.ConfigureBackupPlan API asynchronously
// api document: https://help.aliyun.com/api/dbs/configurebackupplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigureBackupPlanWithCallback(request *ConfigureBackupPlanRequest, callback func(response *ConfigureBackupPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigureBackupPlanResponse
		var err error
		defer close(result)
		response, err = client.ConfigureBackupPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigureBackupPlanRequest is the request struct for api ConfigureBackupPlan
type ConfigureBackupPlanRequest struct {
	*requests.RpcRequest
	SourceEndpointRegion              string           `position:"Query" name:"SourceEndpointRegion"`
	DuplicationArchivePeriod          requests.Integer `position:"Query" name:"DuplicationArchivePeriod"`
	BackupGatewayId                   requests.Integer `position:"Query" name:"BackupGatewayId"`
	SourceEndpointInstanceID          string           `position:"Query" name:"SourceEndpointInstanceID"`
	SourceEndpointUserName            string           `position:"Query" name:"SourceEndpointUserName"`
	ClientToken                       string           `position:"Query" name:"ClientToken"`
	SourceEndpointPassword            string           `position:"Query" name:"SourceEndpointPassword"`
	BackupPlanId                      string           `position:"Query" name:"BackupPlanId"`
	BackupObjects                     string           `position:"Query" name:"BackupObjects"`
	OwnerId                           string           `position:"Query" name:"OwnerId"`
	SourceEndpointPort                requests.Integer `position:"Query" name:"SourceEndpointPort"`
	SourceEndpointDatabaseName        string           `position:"Query" name:"SourceEndpointDatabaseName"`
	BackupRetentionPeriod             requests.Integer `position:"Query" name:"BackupRetentionPeriod"`
	DuplicationInfrequentAccessPeriod requests.Integer `position:"Query" name:"DuplicationInfrequentAccessPeriod"`
	BackupPeriod                      string           `position:"Query" name:"BackupPeriod"`
	BackupStartTime                   string           `position:"Query" name:"BackupStartTime"`
	SourceEndpointInstanceType        string           `position:"Query" name:"SourceEndpointInstanceType"`
	SourceEndpointIP                  string           `position:"Query" name:"SourceEndpointIP"`
	BackupPlanName                    string           `position:"Query" name:"BackupPlanName"`
	SourceEndpointOracleSID           string           `position:"Query" name:"SourceEndpointOracleSID"`
	OSSBucketName                     string           `position:"Query" name:"OSSBucketName"`
	EnableBackupLog                   requests.Boolean `position:"Query" name:"EnableBackupLog"`
}

// ConfigureBackupPlanResponse is the response struct for api ConfigureBackupPlan
type ConfigureBackupPlanResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	BackupPlanId   string `json:"BackupPlanId" xml:"BackupPlanId"`
}

// CreateConfigureBackupPlanRequest creates a request to invoke ConfigureBackupPlan API
func CreateConfigureBackupPlanRequest() (request *ConfigureBackupPlanRequest) {
	request = &ConfigureBackupPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dbs", "2019-03-06", "ConfigureBackupPlan", "cbs", "openAPI")
	return
}

// CreateConfigureBackupPlanResponse creates a response to parse from ConfigureBackupPlan response
func CreateConfigureBackupPlanResponse() (response *ConfigureBackupPlanResponse) {
	response = &ConfigureBackupPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
